/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.sdk.modelmsg;

import android.graphics.Bitmap;
import android.os.Bundle;
import com.tencent.mm.sdk.b.b;
import com.tencent.mm.sdk.modelmsg.WXMediaMessage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;

public class WXImageObject
implements WXMediaMessage.IMediaObject {
    private static final String TAG = "MicroMsg.SDK.WXImageObject";
    private static final int CONTENT_LENGTH_LIMIT = 0xA00000;
    private static final int PATH_LENGTH_LIMIT = 10240;
    public byte[] imageData;
    public String imagePath;

    public WXImageObject() {
    }

    public WXImageObject(byte[] byArray) {
        this.imageData = byArray;
    }

    public WXImageObject(Bitmap bitmap) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.JPEG, 85, (OutputStream)byteArrayOutputStream);
            this.imageData = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void setImagePath(String string) {
        this.imagePath = string;
    }

    @Override
    public void serialize(Bundle bundle) {
        bundle.putByteArray("_wximageobject_imageData", this.imageData);
        bundle.putString("_wximageobject_imagePath", this.imagePath);
    }

    @Override
    public void unserialize(Bundle bundle) {
        this.imageData = bundle.getByteArray("_wximageobject_imageData");
        this.imagePath = bundle.getString("_wximageobject_imagePath");
    }

    @Override
    public int type() {
        return 2;
    }

    @Override
    public boolean checkArgs() {
        if (!(this.imageData != null && this.imageData.length != 0 || this.imagePath != null && this.imagePath.length() != 0)) {
            b.b(TAG, "checkArgs fail, all arguments are null");
            return false;
        }
        if (this.imageData != null && this.imageData.length > 0xA00000) {
            b.b(TAG, "checkArgs fail, content is too large");
            return false;
        }
        if (this.imagePath != null && this.imagePath.length() > 10240) {
            b.b(TAG, "checkArgs fail, path is invalid");
            return false;
        }
        if (this.imagePath != null && this.getFileSize(this.imagePath) > 0xA00000) {
            b.b(TAG, "checkArgs fail, image content is too large");
            return false;
        }
        return true;
    }

    private int getFileSize(String object) {
        if (object == null || ((String)object).length() == 0) {
            return 0;
        }
        if (!((File)(object = new File((String)object))).exists()) {
            return 0;
        }
        return (int)((File)object).length();
    }
}

