/*
 * Decompiled with CFR 0.152.
 */
package m.framework.network;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import m.framework.network.HTTPPart;
import m.framework.utils.Data;

public class ByteArrayPart
extends HTTPPart {
    private byte[] buffer;

    public ByteArrayPart append(byte[] array) throws Throwable {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (this.buffer != null && this.buffer.length > 0) {
            baos.write(this.buffer);
        }
        baos.write(array);
        baos.flush();
        this.buffer = baos.toByteArray();
        baos.close();
        return this;
    }

    @Override
    protected InputStream getInputStream() throws Throwable {
        if (this.buffer == null || this.buffer.length <= 0) {
            return new ByteArrayInputStream(new byte[0]);
        }
        return new ByteArrayInputStream(this.buffer);
    }

    public String toString() {
        return Data.byteToHex(this.buffer);
    }

    @Override
    protected long length() throws Throwable {
        return this.buffer == null ? 0 : this.buffer.length;
    }
}

