/*
 * Decompiled with CFR 0.152.
 */
package m.framework.ui.widget.pulltorefresh;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;

public class GroupListView
extends ListView {
    public GroupListView(Context context) {
        super(context);
    }

    public GroupListView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public GroupListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setAdapter(final GroupListAdapter adapter) {
        BaseAdapter innerAdapter = new BaseAdapter(){

            public View getView(int position, View convertView, ViewGroup parent) {
                int[] indexPair = this.getItemIndex(position);
                int groupIndex = indexPair[0];
                int itemIndex = indexPair[1];
                ItemHolder holder = null;
                if (convertView == null) {
                    holder = new ItemHolder();
                    holder.llItem = new LinearLayout(parent.getContext());
                    holder.llItem.setOrientation(1);
                    holder.llItem.setTag((Object)holder);
                    if (groupIndex > -1) {
                        if (itemIndex == -1) {
                            holder.title = adapter.getGroupTitleView(groupIndex, holder.title, (ViewGroup)holder.llItem);
                            holder.llItem.addView(holder.title);
                        } else if (itemIndex > -1) {
                            holder.child = adapter.getChildView(groupIndex, itemIndex, holder.child, (ViewGroup)holder.llItem);
                            holder.llItem.addView(holder.child);
                        }
                    }
                    convertView = holder.llItem;
                } else {
                    holder = (ItemHolder)convertView.getTag();
                    if (groupIndex > -1) {
                        if (itemIndex == -1) {
                            holder.title = adapter.getGroupTitleView(groupIndex, holder.title, (ViewGroup)holder.llItem);
                            if (holder.child != null) {
                                holder.llItem.removeView(holder.child);
                            }
                        } else if (itemIndex > -1) {
                            holder.child = adapter.getChildView(groupIndex, itemIndex, holder.child, (ViewGroup)holder.llItem);
                            if (holder.title != null) {
                                holder.llItem.removeView(holder.title);
                            }
                        }
                    }
                }
                return convertView;
            }

            public long getItemId(int position) {
                return position;
            }

            public Object getItem(int position) {
                int[] indexPair = this.getItemIndex(position);
                int groupIndex = indexPair[0];
                int itemIndex = indexPair[1];
                if (groupIndex > -1) {
                    if (itemIndex == -1) {
                        return adapter.getGroupTitle(itemIndex);
                    }
                    if (itemIndex > -1) {
                        return adapter.getChild(groupIndex, itemIndex);
                    }
                }
                return null;
            }

            private int[] getItemIndex(int position) {
                int[] indexPair = new int[]{-1, -2};
                int count = 0;
                int size = adapter.getGroupCount();
                int gi = 0;
                while (gi < size) {
                    int groupSize = adapter.getChildrenCount(gi) + 1;
                    if (count + groupSize > position) {
                        indexPair[0] = gi;
                        indexPair[1] = position - count - 1;
                        break;
                    }
                    count += groupSize;
                    ++gi;
                }
                return indexPair;
            }

            public int getCount() {
                int count = 0;
                int i = 0;
                int size = adapter.getGroupCount();
                while (i < size) {
                    count += adapter.getChildrenCount(i) + 1;
                    ++i;
                }
                return count;
            }
        };
        adapter.setInnerAdapter(innerAdapter);
        super.setAdapter((ListAdapter)innerAdapter);
    }

    public static abstract class GroupListAdapter {
        private BaseAdapter adapter;

        private void setInnerAdapter(BaseAdapter adapter) {
            this.adapter = adapter;
        }

        public abstract int getGroupCount();

        public abstract String getGroupTitle(int var1);

        public abstract int getChildrenCount(int var1);

        public abstract Object getChild(int var1, int var2);

        public abstract View getGroupTitleView(int var1, View var2, ViewGroup var3);

        public abstract View getChildView(int var1, int var2, View var3, ViewGroup var4);

        public void notifyDataSetChanged() {
            this.adapter.notifyDataSetChanged();
        }
    }

    private static class ItemHolder {
        public LinearLayout llItem;
        public View title;
        public View child;

        private ItemHolder() {
        }
    }
}

