/*
 * Decompiled with CFR 0.152.
 */
package m.framework.utils;

public class HEX {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String toHex(byte[] data) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < data.length) {
            buffer.append(String.format("%02x", data[i]));
            ++i;
        }
        return buffer.toString();
    }

    public static byte[] toByte(String hexData) {
        if (hexData == null) {
            return null;
        }
        int len = hexData.length();
        if (len % 2 == 1) {
            return null;
        }
        int dataLength = len / 2;
        byte[] result = new byte[dataLength];
        int i = 0;
        while (i < dataLength) {
            result[i] = (byte)Integer.parseInt(hexData.substring(i * 2, i * 2 + 2), 16);
            ++i;
        }
        return result;
    }

    public static String encodeHexString(byte[] data) {
        char[] charArray = HEX.encodeHex(data);
        return new String(charArray);
    }

    public static byte[] decodeHexString(String hexData) {
        return HEX.decodeHex(hexData.toCharArray());
    }

    public static byte[] decodeHex(char[] data) {
        int len = data.length;
        if ((len & 1) != 0) {
            throw new RuntimeException("Odd number of characters.");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = HEX.toDigit(data[j], j) << 4;
            f |= HEX.toDigit(data[++j], j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    protected static int toDigit(char ch, int index) {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new RuntimeException("Illegal hexadecimal charcter " + ch + " at index " + index);
        }
        return digit;
    }

    public static char[] encodeHex(byte[] data) {
        int l = data.length;
        char[] out = new char[l << 1];
        int i = 0;
        int j = 0;
        while (i < l) {
            out[j++] = DIGITS[(0xF0 & data[i]) >>> 4];
            out[j++] = DIGITS[0xF & data[i]];
            ++i;
        }
        return out;
    }

    public byte[] decode(byte[] array) {
        return HEX.decodeHex(new String(array).toCharArray());
    }

    public byte[] decode(Object object) {
        try {
            char[] charArray = object instanceof String ? ((String)object).toCharArray() : (char[])object;
            return HEX.decodeHex(charArray);
        }
        catch (ClassCastException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public byte[] encode(byte[] array) {
        return new String(HEX.encodeHex(array)).getBytes();
    }

    public char[] encode(Object object) {
        try {
            byte[] byteArray = object instanceof String ? ((String)object).getBytes() : (byte[])object;
            return HEX.encodeHex(byteArray);
        }
        catch (ClassCastException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

