/*
 * Decompiled with CFR 0.152.
 */
package m.framework.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.text.TextUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.Locale;
import m.framework.utils.DeviceHelper;

public class Utils {
    private static float density;

    public static int dipToPx(Context context, int dip) {
        if (density <= 0.0f) {
            density = context.getResources().getDisplayMetrics().density;
        }
        return (int)((float)dip * density + 0.5f);
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.trim().length() <= 0 || "null".equals(str.trim().toLowerCase(Locale.getDefault()));
    }

    public static Bitmap getBitmap(String path) throws Throwable {
        return Utils.getBitmap(path, 1);
    }

    public static Bitmap getBitmap(InputStream is) {
        return Utils.getBitmap(is, 1);
    }

    public static Bitmap getBitmap(String path, int inSampleSize) throws Throwable {
        return Utils.getBitmap(new File(path), inSampleSize);
    }

    public static Bitmap getBitmap(File file, int inSampleSize) throws Throwable {
        FileInputStream fis = new FileInputStream(file);
        Bitmap bm = Utils.getBitmap(fis, inSampleSize);
        fis.close();
        return bm;
    }

    private static Bitmap getBitmap(InputStream is, int inSampleSize) {
        BitmapFactory.Options opt = new BitmapFactory.Options();
        opt.inPreferredConfig = Bitmap.Config.RGB_565;
        opt.inPurgeable = true;
        opt.inInputShareable = true;
        opt.inSampleSize = inSampleSize;
        return BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)opt);
    }

    public static String getFileMime(String path) {
        String mime = URLConnection.getFileNameMap().getContentTypeFor(path);
        if (mime == null || mime.length() <= 0) {
            String lowerCaseFile = path.toLowerCase(Locale.getDefault());
            if (lowerCaseFile.endsWith("jpg") || lowerCaseFile.endsWith("jepg")) {
                mime = "image/jpeg";
            } else if (lowerCaseFile.endsWith("png")) {
                mime = "image/png";
            } else if (lowerCaseFile.endsWith("gif")) {
                mime = "image/gif";
            } else {
                try {
                    FileInputStream fis = new FileInputStream(path);
                    mime = URLConnection.guessContentTypeFromStream(fis);
                    fis.close();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                if (mime == null || mime.length() <= 0) {
                    mime = "application/octet-stream";
                }
            }
        }
        return mime;
    }

    public static String getCachePath(Context context, String category) {
        File file;
        String appDir = String.valueOf(context.getFilesDir().getAbsolutePath()) + "/mFramework/cache/";
        DeviceHelper helper = new DeviceHelper(context);
        if (helper.getSdcardState()) {
            appDir = String.valueOf(helper.getSdcardPath()) + "/mFramework/" + helper.getPackageName() + "/cache/";
        }
        if (!TextUtils.isEmpty((CharSequence)category)) {
            appDir = String.valueOf(appDir) + category + "/";
        }
        if (!(file = new File(appDir)).exists()) {
            file.mkdir();
        }
        return appDir;
    }

    public static int getScreenWidth(Context context) {
        return context.getResources().getDisplayMetrics().widthPixels;
    }

    public static int getScreenHeight(Context context) {
        return context.getResources().getDisplayMetrics().heightPixels;
    }
}

