/*
 * Decompiled with CFR 0.152.
 */
package com.lidroid.xutils.bitmap.core;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.lidroid.xutils.bitmap.core.BitmapSize;
import com.lidroid.xutils.util.LogUtils;
import java.io.FileDescriptor;

public class BitmapDecoder {
    private static final Object lock = new Object();

    private BitmapDecoder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap decodeSampledBitmapFromResource(Resources res, int resId, BitmapSize maxSize, Bitmap.Config config) {
        Object object = lock;
        synchronized (object) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            options.inPurgeable = true;
            options.inInputShareable = true;
            BitmapFactory.decodeResource((Resources)res, (int)resId, (BitmapFactory.Options)options);
            options.inSampleSize = BitmapDecoder.calculateInSampleSize(options, maxSize.getWidth(), maxSize.getHeight());
            options.inJustDecodeBounds = false;
            if (config != null) {
                options.inPreferredConfig = config;
            }
            try {
                return BitmapFactory.decodeResource((Resources)res, (int)resId, (BitmapFactory.Options)options);
            }
            catch (Throwable e) {
                LogUtils.e(e.getMessage(), e);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap decodeSampledBitmapFromFile(String filename, BitmapSize maxSize, Bitmap.Config config) {
        Object object = lock;
        synchronized (object) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            options.inPurgeable = true;
            options.inInputShareable = true;
            BitmapFactory.decodeFile((String)filename, (BitmapFactory.Options)options);
            options.inSampleSize = BitmapDecoder.calculateInSampleSize(options, maxSize.getWidth(), maxSize.getHeight());
            options.inJustDecodeBounds = false;
            if (config != null) {
                options.inPreferredConfig = config;
            }
            try {
                return BitmapFactory.decodeFile((String)filename, (BitmapFactory.Options)options);
            }
            catch (Throwable e) {
                LogUtils.e(e.getMessage(), e);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap decodeSampledBitmapFromDescriptor(FileDescriptor fileDescriptor, BitmapSize maxSize, Bitmap.Config config) {
        Object object = lock;
        synchronized (object) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            options.inPurgeable = true;
            options.inInputShareable = true;
            BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor, null, (BitmapFactory.Options)options);
            options.inSampleSize = BitmapDecoder.calculateInSampleSize(options, maxSize.getWidth(), maxSize.getHeight());
            options.inJustDecodeBounds = false;
            if (config != null) {
                options.inPreferredConfig = config;
            }
            try {
                return BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor, null, (BitmapFactory.Options)options);
            }
            catch (Throwable e) {
                LogUtils.e(e.getMessage(), e);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap decodeSampledBitmapFromByteArray(byte[] data, BitmapSize maxSize, Bitmap.Config config) {
        Object object = lock;
        synchronized (object) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            options.inPurgeable = true;
            options.inInputShareable = true;
            BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)options);
            options.inSampleSize = BitmapDecoder.calculateInSampleSize(options, maxSize.getWidth(), maxSize.getHeight());
            options.inJustDecodeBounds = false;
            if (config != null) {
                options.inPreferredConfig = config;
            }
            try {
                return BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)options);
            }
            catch (Throwable e) {
                LogUtils.e(e.getMessage(), e);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap decodeResource(Resources res, int resId) {
        Object object = lock;
        synchronized (object) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inPurgeable = true;
            options.inInputShareable = true;
            try {
                return BitmapFactory.decodeResource((Resources)res, (int)resId, (BitmapFactory.Options)options);
            }
            catch (Throwable e) {
                LogUtils.e(e.getMessage(), e);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap decodeFile(String filename) {
        Object object = lock;
        synchronized (object) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inPurgeable = true;
            options.inInputShareable = true;
            try {
                return BitmapFactory.decodeFile((String)filename, (BitmapFactory.Options)options);
            }
            catch (Throwable e) {
                LogUtils.e(e.getMessage(), e);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap decodeFileDescriptor(FileDescriptor fileDescriptor) {
        Object object = lock;
        synchronized (object) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inPurgeable = true;
            options.inInputShareable = true;
            try {
                return BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor, null, (BitmapFactory.Options)options);
            }
            catch (Throwable e) {
                LogUtils.e(e.getMessage(), e);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap decodeByteArray(byte[] data) {
        Object object = lock;
        synchronized (object) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inPurgeable = true;
            options.inInputShareable = true;
            try {
                return BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)options);
            }
            catch (Throwable e) {
                LogUtils.e(e.getMessage(), e);
                return null;
            }
        }
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int maxWidth, int maxHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (width > maxWidth || height > maxHeight) {
            inSampleSize = width > height ? Math.round((float)height / (float)maxHeight) : Math.round((float)width / (float)maxWidth);
            float totalPixels = width * height;
            float maxTotalPixels = maxWidth * maxHeight * 2;
            while (totalPixels / (float)(inSampleSize * inSampleSize) > maxTotalPixels) {
                ++inSampleSize;
            }
        }
        return inSampleSize;
    }
}

