/*
 * Decompiled with CFR 0.152.
 */
package cn.sharesdk.framework;

import android.content.Context;
import android.content.SharedPreferences;
import cn.sharesdk.framework.utils.d;
import cn.sharesdk.framework.utils.e;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class PlatformDb {
    private static final String DB_NAME = "cn_sharesdk_weibodb";
    private SharedPreferences db;
    private String platformNname;
    private int platformVersion;

    public PlatformDb(Context context, String string, int n2) {
        String string2 = "cn_sharesdk_weibodb_" + string + "_" + n2;
        this.db = context.getSharedPreferences(string2, 0);
        this.platformNname = string;
        this.platformVersion = n2;
    }

    public void put(String string, String string2) {
        SharedPreferences.Editor editor = this.db.edit();
        editor.putString(string, string2);
        editor.commit();
    }

    public String get(String string) {
        return this.db.getString(string, "");
    }

    public String getToken() {
        return this.db.getString("token", "");
    }

    public void putToken(String string) {
        SharedPreferences.Editor editor = this.db.edit();
        editor.putString("token", string);
        editor.commit();
    }

    public String getTokenSecret() {
        return this.db.getString("secret", "");
    }

    public void putTokenSecret(String string) {
        SharedPreferences.Editor editor = this.db.edit();
        editor.putString("secret", string);
        editor.commit();
    }

    public long getExpiresIn() {
        long l2 = 0L;
        try {
            l2 = this.db.getLong("expiresIn", 0L);
        }
        catch (Throwable throwable) {
            try {
                l2 = this.db.getInt("expiresIn", 0);
            }
            catch (Throwable throwable2) {
                l2 = 0L;
            }
        }
        return l2;
    }

    public void putExpiresIn(long l2) {
        SharedPreferences.Editor editor = this.db.edit();
        editor.putLong("expiresIn", l2);
        editor.putLong("expiresTime", System.currentTimeMillis());
        editor.commit();
    }

    public long getExpiresTime() {
        long l2 = this.db.getLong("expiresTime", 0L);
        long l3 = this.getExpiresIn();
        return l2 + l3 * 1000L;
    }

    public int getPlatformVersion() {
        return this.platformVersion;
    }

    public String getPlatformNname() {
        return this.platformNname;
    }

    public void putUserId(String string) {
        SharedPreferences.Editor editor = this.db.edit();
        editor.putString("weibo", string);
        editor.commit();
    }

    public String getUserId() {
        return this.db.getString("weibo", "");
    }

    public String getUserName() {
        return this.db.getString("nickname", "");
    }

    public String getUserIcon() {
        return this.db.getString("icon", "");
    }

    public void removeAccount() {
        ArrayList arrayList = new ArrayList();
        for (Map.Entry object : this.db.getAll().entrySet()) {
            arrayList.add(object.getKey());
        }
        SharedPreferences.Editor editor = this.db.edit();
        for (String string : arrayList) {
            editor.remove(string);
        }
        editor.commit();
    }

    public String exportData() {
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.putAll(this.db.getAll());
            return new d().a(hashMap);
        }
        catch (Throwable throwable) {
            e.b(throwable);
            return null;
        }
    }

    public void importData(String string) {
        try {
            HashMap<String, Object> hashMap = new d().a(string);
            if (hashMap != null) {
                SharedPreferences.Editor editor = this.db.edit();
                for (Map.Entry<String, Object> entry : hashMap.entrySet()) {
                    Object object = entry.getValue();
                    if (object instanceof Boolean) {
                        editor.putBoolean(entry.getKey(), ((Boolean)object).booleanValue());
                        continue;
                    }
                    if (object instanceof Float) {
                        editor.putFloat(entry.getKey(), ((Float)object).floatValue());
                        continue;
                    }
                    if (object instanceof Integer) {
                        editor.putInt(entry.getKey(), ((Integer)object).intValue());
                        continue;
                    }
                    if (object instanceof Long) {
                        editor.putLong(entry.getKey(), ((Long)object).longValue());
                        continue;
                    }
                    editor.putString(entry.getKey(), String.valueOf(object));
                }
                editor.commit();
            }
        }
        catch (Throwable throwable) {
            e.b(throwable);
        }
    }

    public boolean isValid() {
        String string = this.getToken();
        if (string == null || string.length() <= 0) {
            return false;
        }
        if (this.getExpiresIn() == 0L) {
            return true;
        }
        return this.getExpiresTime() > System.currentTimeMillis();
    }

    public String getUserGender() {
        String string = this.db.getString("gender", "2");
        if ("0".equals(string)) {
            return "m";
        }
        if ("1".equals(string)) {
            return "f";
        }
        return null;
    }
}

