/*
 * Decompiled with CFR 0.152.
 */
package cn.sharesdk.framework.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.text.TextUtils;
import android.view.View;
import cn.sharesdk.framework.network.i;
import cn.sharesdk.framework.utils.R;
import cn.sharesdk.framework.utils.e;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class BitmapHelper {
    public static Bitmap getBitmap(String string, int n2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return BitmapHelper.getBitmap(new File(string), n2);
    }

    public static Bitmap getBitmap(File file, int n2) {
        if (file == null || !file.exists()) {
            return null;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        Bitmap bitmap = BitmapHelper.getBitmap(fileInputStream, n2);
        fileInputStream.close();
        return bitmap;
    }

    public static Bitmap getBitmap(InputStream inputStream, int n2) {
        if (inputStream == null) {
            return null;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inPreferredConfig = Bitmap.Config.RGB_565;
        options.inPurgeable = true;
        options.inInputShareable = true;
        options.inSampleSize = n2;
        return BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
    }

    public static Bitmap getBitmap(String string) {
        return BitmapHelper.getBitmap(string, 1);
    }

    public static Bitmap getBitmap(Context context, String string) {
        String string2 = BitmapHelper.downloadBitmap(context, string);
        return BitmapHelper.getBitmap(string2);
    }

    public static String downloadBitmap(Context context, String string) {
        i i2 = new i();
        return i2.a(context, string, "images", true);
    }

    public static String saveViewToImage(View view) {
        if (view == null) {
            return null;
        }
        int n2 = view.getWidth();
        int n3 = view.getHeight();
        if (n2 <= 0 || n3 <= 0) {
            return null;
        }
        return BitmapHelper.saveViewToImage(view, n2, n3);
    }

    public static String saveViewToImage(View view, int n2, int n3) {
        Bitmap bitmap = BitmapHelper.captureView(view, n2, n3);
        if (bitmap == null || bitmap.isRecycled()) {
            return null;
        }
        String string = R.getCachePath(view.getContext(), "screenshot");
        File file = new File(string, String.valueOf(System.currentTimeMillis()) + ".jpg");
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fileOutputStream);
        fileOutputStream.flush();
        fileOutputStream.close();
        return file.getAbsolutePath();
    }

    public static Bitmap captureView(View view, int n2, int n3) {
        Bitmap bitmap = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        view.draw(new Canvas(bitmap));
        return bitmap;
    }

    public static Bitmap blur(Bitmap bitmap, int n2, int n3) {
        int n4 = bitmap.getWidth();
        int n5 = bitmap.getHeight();
        int n6 = (int)((float)n2 / (float)n3 + 0.5f);
        int n7 = (int)((float)n4 / (float)n3 + 0.5f);
        int n8 = (int)((float)n5 / (float)n3 + 0.5f);
        Bitmap bitmap2 = Bitmap.createBitmap((int)n7, (int)n8, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap2);
        canvas.scale(1.0f / (float)n3, 1.0f / (float)n3);
        Paint paint = new Paint();
        paint.setFlags(2);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, paint);
        BitmapHelper.a(bitmap2, n6, true);
        return bitmap2;
    }

    private static Bitmap a(Bitmap bitmap, int n2, boolean bl) {
        int n3;
        int n4;
        int n5;
        int n6;
        int[] nArray;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        Bitmap bitmap2 = bl ? bitmap : bitmap.copy(bitmap.getConfig(), true);
        if (n2 < 1) {
            return null;
        }
        int n19 = bitmap2.getWidth();
        int n20 = bitmap2.getHeight();
        int[] nArray2 = new int[n19 * n20];
        bitmap2.getPixels(nArray2, 0, n19, 0, 0, n19, n20);
        int n21 = n19 - 1;
        int n22 = n20 - 1;
        int n23 = n19 * n20;
        int n24 = n2 + n2 + 1;
        int[] nArray3 = new int[n23];
        int[] nArray4 = new int[n23];
        int[] nArray5 = new int[n23];
        int[] nArray6 = new int[Math.max(n19, n20)];
        int n25 = n24 + 1 >> 1;
        n25 *= n25;
        int[] nArray7 = new int[256 * n25];
        for (n18 = 0; n18 < 256 * n25; ++n18) {
            nArray7[n18] = n18 / n25;
        }
        int n26 = 0;
        int n27 = 0;
        int[][] nArray8 = new int[n24][3];
        int n28 = n2 + 1;
        for (n17 = 0; n17 < n20; ++n17) {
            n16 = 0;
            n15 = 0;
            n14 = 0;
            n13 = 0;
            n12 = 0;
            n11 = 0;
            n10 = 0;
            n9 = 0;
            n8 = 0;
            for (n18 = -n2; n18 <= n2; ++n18) {
                n7 = nArray2[n26 + Math.min(n21, Math.max(n18, 0))];
                nArray = nArray8[n18 + n2];
                nArray[0] = (n7 & 0xFF0000) >> 16;
                nArray[1] = (n7 & 0xFF00) >> 8;
                nArray[2] = n7 & 0xFF;
                n6 = n28 - Math.abs(n18);
                n14 += nArray[0] * n6;
                n15 += nArray[1] * n6;
                n16 += nArray[2] * n6;
                if (n18 > 0) {
                    n8 += nArray[0];
                    n9 += nArray[1];
                    n10 += nArray[2];
                    continue;
                }
                n11 += nArray[0];
                n12 += nArray[1];
                n13 += nArray[2];
            }
            n5 = n2;
            for (n4 = 0; n4 < n19; ++n4) {
                nArray3[n26] = nArray7[n14];
                nArray4[n26] = nArray7[n15];
                nArray5[n26] = nArray7[n16];
                n14 -= n11;
                n15 -= n12;
                n16 -= n13;
                n3 = n5 - n2 + n24;
                nArray = nArray8[n3 % n24];
                n11 -= nArray[0];
                n12 -= nArray[1];
                n13 -= nArray[2];
                if (n17 == 0) {
                    nArray6[n4] = Math.min(n4 + n2 + 1, n21);
                }
                n7 = nArray2[n27 + nArray6[n4]];
                nArray[0] = (n7 & 0xFF0000) >> 16;
                nArray[1] = (n7 & 0xFF00) >> 8;
                nArray[2] = n7 & 0xFF;
                n14 += (n8 += nArray[0]);
                n15 += (n9 += nArray[1]);
                n16 += (n10 += nArray[2]);
                n5 = (n5 + 1) % n24;
                nArray = nArray8[n5 % n24];
                n11 += nArray[0];
                n12 += nArray[1];
                n13 += nArray[2];
                n8 -= nArray[0];
                n9 -= nArray[1];
                n10 -= nArray[2];
                ++n26;
            }
            n27 += n19;
        }
        for (n4 = 0; n4 < n19; ++n4) {
            n16 = 0;
            n15 = 0;
            n14 = 0;
            n13 = 0;
            n12 = 0;
            n11 = 0;
            n10 = 0;
            n9 = 0;
            n8 = 0;
            int n29 = -n2 * n19;
            for (n18 = -n2; n18 <= n2; ++n18) {
                n26 = Math.max(0, n29) + n4;
                nArray = nArray8[n18 + n2];
                nArray[0] = nArray3[n26];
                nArray[1] = nArray4[n26];
                nArray[2] = nArray5[n26];
                n6 = n28 - Math.abs(n18);
                n14 += nArray3[n26] * n6;
                n15 += nArray4[n26] * n6;
                n16 += nArray5[n26] * n6;
                if (n18 > 0) {
                    n8 += nArray[0];
                    n9 += nArray[1];
                    n10 += nArray[2];
                } else {
                    n11 += nArray[0];
                    n12 += nArray[1];
                    n13 += nArray[2];
                }
                if (n18 >= n22) continue;
                n29 += n19;
            }
            n26 = n4;
            n5 = n2;
            for (n17 = 0; n17 < n20; ++n17) {
                nArray2[n26] = 0xFF000000 & nArray2[n26] | nArray7[n14] << 16 | nArray7[n15] << 8 | nArray7[n16];
                n14 -= n11;
                n15 -= n12;
                n16 -= n13;
                n3 = n5 - n2 + n24;
                nArray = nArray8[n3 % n24];
                n11 -= nArray[0];
                n12 -= nArray[1];
                n13 -= nArray[2];
                if (n4 == 0) {
                    nArray6[n17] = Math.min(n17 + n28, n22) * n19;
                }
                n7 = n4 + nArray6[n17];
                nArray[0] = nArray3[n7];
                nArray[1] = nArray4[n7];
                nArray[2] = nArray5[n7];
                n14 += (n8 += nArray[0]);
                n15 += (n9 += nArray[1]);
                n16 += (n10 += nArray[2]);
                n5 = (n5 + 1) % n24;
                nArray = nArray8[n5];
                n11 += nArray[0];
                n12 += nArray[1];
                n13 += nArray[2];
                n8 -= nArray[0];
                n9 -= nArray[1];
                n10 -= nArray[2];
                n26 += n19;
            }
        }
        bitmap2.setPixels(nArray2, 0, n19, 0, 0, n19, n20);
        return bitmap2;
    }

    public static Bitmap roundBitmap(Bitmap bitmap, int n2, int n3, float f2, float f3, float f4, float f5) {
        int n4 = bitmap.getWidth();
        int n5 = bitmap.getHeight();
        Rect rect = new Rect(0, 0, n4, n5);
        Bitmap bitmap2 = n4 != n2 || n5 != n3 ? Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888) : Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap2);
        int n6 = -12434878;
        Paint paint = new Paint();
        Rect rect2 = new Rect(0, 0, n2, n3);
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(n6);
        float[] fArray = new float[]{f2, f2, f3, f3, f4, f4, f5, f5};
        RectF rectF = new RectF(0.0f, 0.0f, 0.0f, 0.0f);
        RoundRectShape roundRectShape = new RoundRectShape(fArray, rectF, fArray);
        ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)roundRectShape);
        shapeDrawable.setBounds(rect2);
        shapeDrawable.draw(canvas);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, rect, rect2, paint);
        return bitmap2;
    }

    public static int[] fixRect(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[2];
        float f2 = (float)nArray[0] / (float)nArray[1];
        float f3 = (float)nArray2[0] / (float)nArray2[1];
        if (f2 > f3) {
            nArray3[0] = nArray2[0];
            nArray3[1] = (int)((float)nArray[1] * (float)nArray2[0] / (float)nArray[0] + 0.5f);
        } else {
            nArray3[1] = nArray2[1];
            nArray3[0] = (int)((float)nArray[0] * (float)nArray2[1] / (float)nArray[1] + 0.5f);
        }
        return nArray3;
    }

    public static int[] fixRect_2(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[2];
        float f2 = (float)nArray[0] / (float)nArray[1];
        float f3 = (float)nArray2[0] / (float)nArray2[1];
        if (f2 > f3) {
            nArray3[1] = nArray2[1];
            nArray3[0] = (int)((float)nArray[0] * (float)nArray2[1] / (float)nArray[1] + 0.5f);
        } else {
            nArray3[0] = nArray2[0];
            nArray3[1] = (int)((float)nArray[1] * (float)nArray2[0] / (float)nArray[0] + 0.5f);
        }
        return nArray3;
    }

    public static String saveBitmap(Context context, Bitmap bitmap, Bitmap.CompressFormat compressFormat, int n2) {
        String string = R.getCachePath(context, "images");
        String string2 = ".jpg";
        if (compressFormat == Bitmap.CompressFormat.PNG) {
            string2 = ".png";
        }
        File file = new File(string, String.valueOf(System.currentTimeMillis()) + string2);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        bitmap.compress(compressFormat, n2, (OutputStream)fileOutputStream);
        fileOutputStream.flush();
        fileOutputStream.close();
        return file.getAbsolutePath();
    }

    public static String saveBitmap(Context context, Bitmap bitmap) {
        return BitmapHelper.saveBitmap(context, bitmap, Bitmap.CompressFormat.JPEG, 80);
    }

    public static Bitmap.CompressFormat getBmpFormat(byte[] byArray) {
        String string = BitmapHelper.a(byArray);
        Bitmap.CompressFormat compressFormat = Bitmap.CompressFormat.JPEG;
        if (string != null && (string.endsWith("png") || string.endsWith("gif"))) {
            compressFormat = Bitmap.CompressFormat.PNG;
        }
        return compressFormat;
    }

    public static Bitmap.CompressFormat getBmpFormat(String string) {
        String string2;
        String string3 = string.toLowerCase();
        Bitmap.CompressFormat compressFormat = string3.endsWith("png") || string3.endsWith("gif") ? Bitmap.CompressFormat.PNG : (string3.endsWith("jpg") || string3.endsWith("jpeg") || string3.endsWith("bmp") || string3.endsWith("tif") ? Bitmap.CompressFormat.JPEG : ((string2 = BitmapHelper.a(string)).endsWith("png") || string2.endsWith("gif") ? Bitmap.CompressFormat.PNG : Bitmap.CompressFormat.JPEG));
        return compressFormat;
    }

    private static String a(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            byte[] byArray = new byte[8];
            fileInputStream.read(byArray);
            fileInputStream.close();
            return BitmapHelper.a(byArray);
        }
        catch (Exception exception) {
            e.b(exception);
            return null;
        }
    }

    private static String a(byte[] byArray) {
        byte[] byArray2 = new byte[]{-1, -40, -1, -32};
        byte[] byArray3 = new byte[]{-1, -40, -1, -31};
        if (BitmapHelper.a(byArray, byArray2) || BitmapHelper.a(byArray, byArray3)) {
            return "jpg";
        }
        byte[] byArray4 = new byte[]{-119, 80, 78, 71};
        if (BitmapHelper.a(byArray, byArray4)) {
            return "png";
        }
        byte[] byArray5 = "GIF".getBytes();
        if (BitmapHelper.a(byArray, byArray5)) {
            return "gif";
        }
        byte[] byArray6 = "BM".getBytes();
        if (BitmapHelper.a(byArray, byArray6)) {
            return "bmp";
        }
        byte[] byArray7 = new byte[]{73, 73, 42};
        byte[] byArray8 = new byte[]{77, 77, 42};
        if (BitmapHelper.a(byArray, byArray7) || BitmapHelper.a(byArray, byArray8)) {
            return "tif";
        }
        return null;
    }

    private static boolean a(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length < byArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < byArray2.length; ++i2) {
            if (byArray[i2] == byArray2[i2]) continue;
            return false;
        }
        return true;
    }

    public static Bitmap cropBitmap(Bitmap bitmap, int n2, int n3, int n4, int n5) {
        int n6 = bitmap.getWidth() - n2 - n4;
        int n7 = bitmap.getHeight() - n3 - n5;
        if (n6 == bitmap.getWidth() && n7 == bitmap.getHeight()) {
            return bitmap;
        }
        Bitmap bitmap2 = Bitmap.createBitmap((int)n6, (int)n7, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap2);
        Paint paint = new Paint();
        canvas.drawBitmap(bitmap, (float)(-n2), (float)(-n3), paint);
        return bitmap2;
    }

    public static boolean isBlackBitmap(Bitmap bitmap) {
        if (bitmap == null || bitmap.isRecycled()) {
            return true;
        }
        int[] nArray = new int[bitmap.getWidth() * bitmap.getHeight()];
        bitmap.getPixels(nArray, 0, bitmap.getWidth(), 0, 0, bitmap.getWidth(), bitmap.getHeight());
        int n2 = 0;
        boolean bl = false;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            n2 = nArray[i2] & 0xFFFFFF;
            if (n2 == 0) continue;
            bl = true;
            break;
        }
        return !bl;
    }

    public static int mixAlpha(int n2, int n3) {
        int n4 = n2 >>> 24;
        int n5 = (0xFF0000 & n2) >>> 16;
        int n6 = (0xFF00 & n2) >>> 8;
        int n7 = 0xFF & n2;
        int n8 = (0xFF0000 & n3) >>> 16;
        int n9 = (0xFF00 & n3) >>> 8;
        int n10 = 0xFF & n3;
        return 0xFF000000 | n4 * n5 + (256 - n4) * n8 / 256 << 16 | n4 * n6 + (256 - n4) * n9 / 256 << 8 | n4 * n7 + (256 - n4) * n10 / 256;
    }
}

