/*
 * Decompiled with CFR 0.152.
 */
package cn.sharesdk.framework.utils;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Point;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import cn.sharesdk.framework.network.f;
import cn.sharesdk.framework.utils.a;
import cn.sharesdk.framework.utils.b;
import cn.sharesdk.framework.utils.e;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class R {
    private static String a;
    private static float b;

    public static int dipToPx(Context context, int n2) {
        if (b <= 0.0f) {
            b = context.getResources().getDisplayMetrics().density;
        }
        return (int)((float)n2 * b + 0.5f);
    }

    public static int pxToDip(Context context, int n2) {
        if (b <= 0.0f) {
            b = context.getResources().getDisplayMetrics().density;
        }
        return (int)((float)n2 / b + 0.5f);
    }

    public static int[] getScreenSize(Context context) {
        WindowManager windowManager;
        try {
            windowManager = (WindowManager)context.getSystemService("window");
        }
        catch (Throwable throwable) {
            e.c(throwable);
            windowManager = null;
        }
        if (windowManager == null) {
            return new int[]{0, 0};
        }
        Display display = windowManager.getDefaultDisplay();
        if (Build.VERSION.SDK_INT < 13) {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            display.getMetrics(displayMetrics);
            return new int[]{displayMetrics.widthPixels, displayMetrics.heightPixels};
        }
        try {
            Point point = new Point();
            Method method = display.getClass().getMethod("getRealSize", Point.class);
            method.setAccessible(true);
            method.invoke((Object)display, point);
            return new int[]{point.x, point.y};
        }
        catch (Throwable throwable) {
            e.b(throwable);
            return new int[]{0, 0};
        }
    }

    public static int getScreenWidth(Context context) {
        return R.getScreenSize(context)[0];
    }

    public static int getScreenHeight(Context context) {
        return R.getScreenSize(context)[1];
    }

    public static int getResId(Context context, String string, String string2) {
        int n2 = 0;
        if (context == null || TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
            return n2;
        }
        String string3 = context.getPackageName();
        if (TextUtils.isEmpty((CharSequence)string3)) {
            return n2;
        }
        try {
            Field field;
            Class<?> clazz = Class.forName(string3 + ".R$" + string);
            if (clazz != null && ((field = clazz.getField(string2)) != null || (field = clazz.getField(string2.toLowerCase())) != null)) {
                field.setAccessible(true);
                n2 = (Integer)field.get(null);
            }
        }
        catch (Throwable throwable) {
            e.b(throwable);
            n2 = 0;
        }
        if (n2 <= 0 && (n2 = context.getResources().getIdentifier(string2, string, string3)) <= 0) {
            n2 = context.getResources().getIdentifier(string2.toLowerCase(), string, string3);
        }
        if (n2 <= 0) {
            System.err.println("failed to parse " + string + " resource \"" + string2 + "\"");
        }
        return n2;
    }

    public static int getBitmapRes(Context context, String string) {
        return R.getResId(context, "drawable", string);
    }

    public static int getStringRes(Context context, String string) {
        return R.getResId(context, "string", string);
    }

    public static int getStringArrayRes(Context context, String string) {
        return R.getResId(context, "array", string);
    }

    public static int getLayoutRes(Context context, String string) {
        return R.getResId(context, "layout", string);
    }

    public static int getStyleRes(Context context, String string) {
        return R.getResId(context, "style", string);
    }

    public static int getIdRes(Context context, String string) {
        return R.getResId(context, "id", string);
    }

    public static int getColorRes(Context context, String string) {
        return R.getResId(context, "color", string);
    }

    public static int getRawRes(Context context, String string) {
        return R.getResId(context, "raw", string);
    }

    public static int getPluralsRes(Context context, String string) {
        return R.getResId(context, "plurals", string);
    }

    public static void setCacheRoot(String string) {
        a = string;
    }

    public static String getCachePath(Context context, String string) {
        File file;
        String string2 = a;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string2 = "ShareSDK";
        }
        String string3 = context.getFilesDir().getAbsolutePath() + "/" + string2 + "/cache/";
        b b2 = cn.sharesdk.framework.utils.b.a(context);
        if (b2.w()) {
            string3 = b2.x() + "/" + string2 + "/" + b2.q() + "/cache/";
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            string3 = string3 + string + "/";
        }
        if (!(file = new File(string3)).exists()) {
            file.mkdirs();
        }
        return string3;
    }

    public static String getImageCachePath(Context context) {
        return R.getCachePath(context, "images");
    }

    public static void clearCache(Context context) {
        String string = R.getCachePath(context, null);
        File file = new File(string);
        R.deleteFileAndFolder(file);
    }

    public static void deleteFileAndFolder(File file) {
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
            return;
        }
        String[] stringArray = file.list();
        if (stringArray == null || stringArray.length <= 0) {
            file.delete();
            return;
        }
        for (String string : stringArray) {
            File file2 = new File(file, string);
            if (file2.isDirectory()) {
                R.deleteFileAndFolder(file2);
                continue;
            }
            file2.delete();
        }
        file.delete();
    }

    public static String toWordText(String string, int n2) {
        char[] cArray = string.toCharArray();
        int n3 = n2 * 2;
        StringBuilder stringBuilder = new StringBuilder();
        for (char c2 : cArray) {
            if ((n3 -= c2 < '\u0100' ? 1 : 2) < 0) {
                return stringBuilder.toString();
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static int getTextLengthInWord(String string) {
        char[] cArray = string == null ? new char[]{} : string.toCharArray();
        int n2 = 0;
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            n2 += cArray[i2] < '\u0100' ? 1 : 2;
        }
        return n2;
    }

    public static long strToDate(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = simpleDateFormat.parse(string, parsePosition);
        return date.getTime();
    }

    public static long dateStrToLong(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = simpleDateFormat.parse(string, parsePosition);
        return date.getTime();
    }

    public static Date longToDate(long l2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l2);
        return calendar.getTime();
    }

    public static String longToTime(long l2, int n2) {
        String string = "yyyy-MM-dd kk:mm:ss";
        switch (n2) {
            case 12: {
                string = "yyyy-MM-dd kk:mm";
                break;
            }
            case 10: {
                string = "yyyy-MM-dd kk";
                break;
            }
            case 5: {
                string = "yyyy-MM-dd";
                break;
            }
            case 2: {
                string = "yyyy-MM";
                break;
            }
            case 1: {
                string = "yyyy";
            }
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        return simpleDateFormat.format(l2);
    }

    public static long dateToLong(String string) {
        try {
            Date date = new Date(string);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            return calendar.getTimeInMillis();
        }
        catch (Throwable throwable) {
            e.b(throwable);
            return 0L;
        }
    }

    public static int[] covertTimeInYears(long l2) {
        long l3 = System.currentTimeMillis() - l2;
        if (l3 <= 0L) {
            return new int[]{0, 0};
        }
        if ((l3 /= 1000L) < 60L) {
            return new int[]{(int)l3, 0};
        }
        if ((l3 /= 60L) < 60L) {
            return new int[]{(int)l3, 1};
        }
        if ((l3 /= 60L) < 24L) {
            return new int[]{(int)l3, 2};
        }
        if ((l3 /= 24L) < 30L) {
            return new int[]{(int)l3, 3};
        }
        if ((l3 /= 30L) < 12L) {
            return new int[]{(int)l3, 4};
        }
        return new int[]{(int)(l3 /= 12L), 5};
    }

    public static Uri pathToContentUri(Context context, String string) {
        Cursor cursor = context.getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, new String[]{"_id"}, "_data=? ", new String[]{string}, null);
        if (cursor != null && cursor.moveToFirst()) {
            int n2 = cursor.getInt(cursor.getColumnIndex("_id"));
            Uri uri = Uri.parse((String)"content://media/external/images/media");
            return Uri.withAppendedPath((Uri)uri, (String)("" + n2));
        }
        File file = new File(string);
        if (file.exists()) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("_data", string);
            Uri uri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
            return context.getContentResolver().insert(uri, contentValues);
        }
        return null;
    }

    public static String contentUriToPath(Context context, Uri uri) {
        if (uri == null) {
            return null;
        }
        if (new File(uri.getPath()).exists()) {
            return uri.getPath();
        }
        String string = null;
        try {
            Cursor cursor = null;
            if (Build.VERSION.SDK_INT >= 19) {
                Class<?> clazz = Class.forName("android.provider.DocumentsContract");
                Method method = clazz.getMethod("isDocumentUri", Context.class, Uri.class);
                method.setAccessible(true);
                if (Boolean.TRUE.equals(method.invoke(null, context, uri))) {
                    Method method2 = clazz.getMethod("getDocumentId", Uri.class);
                    method2.setAccessible(true);
                    String string2 = String.valueOf(method2.invoke(null, uri));
                    String string3 = string2.split(":")[1];
                    String[] stringArray = new String[]{"_data"};
                    String string4 = "_id=?";
                    String[] stringArray2 = new String[]{string3};
                    cursor = context.getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, stringArray, string4, stringArray2, null);
                }
            }
            if (cursor == null) {
                cursor = context.getContentResolver().query(uri, null, null, null, null);
            }
            if (cursor != null) {
                if (cursor.moveToFirst()) {
                    string = cursor.getString(cursor.getColumnIndex("_data"));
                }
                cursor.close();
            }
        }
        catch (Throwable throwable) {
            e.b(throwable);
            string = null;
        }
        return string;
    }

    public static String encodeUrl(Bundle bundle) {
        if (bundle == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (String string : bundle.keySet()) {
            Object object = bundle.get(string);
            if (object == null) {
                object = "";
            }
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append("&");
            }
            stringBuilder.append(cn.sharesdk.framework.utils.a.d(string) + "=" + cn.sharesdk.framework.utils.a.d(String.valueOf(object)));
        }
        return stringBuilder.toString();
    }

    public static String encodeUrl(ArrayList<f<String>> arrayList) {
        if (arrayList == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (f<String> f2 : arrayList) {
            if (n2 > 0) {
                stringBuilder.append('&');
            }
            String string = f2.a;
            String string2 = (String)f2.b;
            if (string == null) continue;
            if (string2 == null) {
                string2 = "";
            }
            stringBuilder.append(cn.sharesdk.framework.utils.a.d(string) + "=" + cn.sharesdk.framework.utils.a.d(string2));
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static Bundle urlToBundle(String string) {
        int n2 = string.indexOf("://");
        string = n2 >= 0 ? "http://" + string.substring(n2 + 1) : "http://" + string;
        try {
            URL uRL = new URL(string);
            Bundle bundle = R.decodeUrl(uRL.getQuery());
            bundle.putAll(R.decodeUrl(uRL.getRef()));
            return bundle;
        }
        catch (Throwable throwable) {
            e.b(throwable);
            return new Bundle();
        }
    }

    public static Bundle decodeUrl(String string) {
        Bundle bundle = new Bundle();
        if (string != null) {
            String[] stringArray;
            for (String string2 : stringArray = string.split("&")) {
                String[] stringArray2 = string2.split("=");
                if (stringArray2.length < 2 || stringArray2[1] == null) {
                    bundle.putString(URLDecoder.decode(stringArray2[0]), "");
                    continue;
                }
                bundle.putString(URLDecoder.decode(stringArray2[0]), URLDecoder.decode(stringArray2[1]));
            }
        }
        return bundle;
    }

    public static int parseInt(String string) {
        return R.parseInt(string, 10);
    }

    public static int parseInt(String string, int n2) {
        boolean bl;
        if (n2 < 2 || n2 > 36) {
            throw new Throwable("Invalid radix: " + n2);
        }
        if (string == null) {
            throw R.a(string);
        }
        int n3 = string.length();
        int n4 = 0;
        if (n3 == 0) {
            throw R.a(string);
        }
        boolean bl2 = bl = string.charAt(n4) == '-';
        if (bl && ++n4 == n3) {
            throw R.a(string);
        }
        return R.a(string, n4, n2, bl);
    }

    private static int a(String string, int n2, int n3, boolean bl) {
        int n4 = Integer.MIN_VALUE / n3;
        int n5 = 0;
        int n6 = string.length();
        while (n2 < n6) {
            int n7;
            if ((n7 = R.a(string.charAt(n2++), n3)) == -1) {
                throw R.a(string);
            }
            if (n4 > n5) {
                throw R.a(string);
            }
            int n8 = n5 * n3 - n7;
            if (n8 > n5) {
                throw R.a(string);
            }
            n5 = n8;
        }
        if (!bl && (n5 = -n5) < 0) {
            throw R.a(string);
        }
        return n5;
    }

    private static int a(int n2, int n3) {
        if (n3 < 2 || n3 > 36) {
            return -1;
        }
        int n4 = -1;
        if (48 <= n2 && n2 <= 57) {
            n4 = n2 - 48;
        } else if (97 <= n2 && n2 <= 122) {
            n4 = 10 + (n2 - 97);
        } else if (65 <= n2 && n2 <= 90) {
            n4 = 10 + (n2 - 65);
        }
        return n4 < n3 ? n4 : -1;
    }

    private static Throwable a(String string) {
        throw new Throwable("Invalid int: \"" + string + "\"");
    }

    public static long parseLong(String string) {
        return R.parseLong(string, 10);
    }

    public static long parseLong(String string, int n2) {
        boolean bl;
        if (n2 < 2 || n2 > 36) {
            throw new Throwable("Invalid radix: " + n2);
        }
        if (string == null) {
            throw R.b(string);
        }
        int n3 = string.length();
        int n4 = 0;
        if (n3 == 0) {
            throw R.b(string);
        }
        boolean bl2 = bl = string.charAt(n4) == '-';
        if (bl && ++n4 == n3) {
            throw R.b(string);
        }
        return R.b(string, n4, n2, bl);
    }

    private static long b(String string, int n2, int n3, boolean bl) {
        long l2 = Long.MIN_VALUE / (long)n3;
        long l3 = 0L;
        long l4 = string.length();
        while ((long)n2 < l4) {
            int n4;
            if ((n4 = R.a(string.charAt(n2++), n3)) == -1) {
                throw R.b(string);
            }
            if (l2 > l3) {
                throw R.b(string);
            }
            long l5 = l3 * (long)n3 - (long)n4;
            if (l5 > l3) {
                throw R.b(string);
            }
            l3 = l5;
        }
        if (!bl && (l3 = -l3) < 0L) {
            throw R.b(string);
        }
        return l3;
    }

    private static Throwable b(String string) {
        throw new Throwable("Invalid long: \"" + string + "\"");
    }

    public static boolean copyFile(String string, String string2) {
        if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        if (!new File(string).exists()) {
            return false;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            R.copyFile(fileInputStream, fileOutputStream);
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    public static void copyFile(FileInputStream fileInputStream, FileOutputStream fileOutputStream) {
        byte[] byArray = new byte[65536];
        int n2 = fileInputStream.read(byArray);
        while (n2 > 0) {
            fileOutputStream.write(byArray, 0, n2);
            n2 = fileInputStream.read(byArray);
        }
        fileInputStream.close();
        fileOutputStream.close();
    }

    public static boolean saveObjectToFile(String string, Object object) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            File file = null;
            try {
                file = new File(string);
                if (file.exists()) {
                    file.delete();
                }
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                file.createNewFile();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                file = null;
            }
            if (file != null) {
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(fileOutputStream);
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(gZIPOutputStream);
                    objectOutputStream.writeObject(object);
                    objectOutputStream.flush();
                    objectOutputStream.close();
                    return true;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
        return false;
    }

    public static Object readObjectFromFile(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            File file = null;
            try {
                file = new File(string);
                if (!file.exists()) {
                    file = null;
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                file = null;
            }
            if (file != null) {
                try {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    GZIPInputStream gZIPInputStream = new GZIPInputStream(fileInputStream);
                    ObjectInputStream objectInputStream = new ObjectInputStream(gZIPInputStream);
                    Object object = objectInputStream.readObject();
                    objectInputStream.close();
                    return object;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
        return null;
    }
}

