/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.security.mobile.module.commonutils;

import android.util.Base64;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.util.Map;
import java.util.zip.GZIPOutputStream;

public class CommonUtils {
    public static String getValueFromMap(Map<String, String> object, String string, String string2) {
        if (object == null) {
            return string2;
        }
        if ((object = object.get(string)) == null) {
            return string2;
        }
        return object;
    }

    public static boolean isBlank(String string) {
        int n2;
        if (string == null || (n2 = string.length()) == 0) {
            return true;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isWhitespace(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String string) {
        return !CommonUtils.isBlank(string);
    }

    public static String getNonNullString(String string) {
        if (CommonUtils.isBlank(string)) {
            return "";
        }
        return string;
    }

    public static boolean equals(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2);
    }

    public static boolean isZero(String string) {
        int n2;
        if (string == null || (n2 = string.length()) == 0) {
            return true;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isWhitespace(string.charAt(i2)) || string.charAt(i2) == '0') continue;
            return false;
        }
        return true;
    }

    public static String sha1ByString(String object) {
        try {
            if (CommonUtils.isBlank((String)object)) {
                return null;
            }
            Object object2 = MessageDigest.getInstance("SHA-1");
            ((MessageDigest)object2).update(((String)object).getBytes("UTF-8"));
            object = ((MessageDigest)object2).digest();
            object2 = new StringBuilder();
            for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                ((StringBuilder)object2).append(String.format("%02x", (byte)object[i2]));
            }
            return ((StringBuilder)object2).toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean equalsIgnoreCase(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equalsIgnoreCase(string2);
    }

    public static String textCompress(String object) {
        try {
            byte[] byArray = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(((String)object).length()).array();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(((String)object).length());
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(((String)object).getBytes("UTF-8"));
            gZIPOutputStream.close();
            byteArrayOutputStream.close();
            object = new byte[4 + byteArrayOutputStream.toByteArray().length];
            System.arraycopy(byArray, 0, object, 0, 4);
            System.arraycopy(byteArrayOutputStream.toByteArray(), 0, object, 4, byteArrayOutputStream.toByteArray().length);
            return Base64.encodeToString((byte[])object, (int)8);
        }
        catch (Exception exception) {
            return "";
        }
    }
}

