/*
 * Decompiled with CFR 0.152.
 */
package com.ta.utdid2.aid;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.ta.utdid2.aid.AidStorageController;
import com.ta.utdid2.android.utils.DebugUtils;
import com.ta.utdid2.android.utils.NetworkUtils;
import com.ut.device.AidCallback;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.json.JSONException;
import org.json.JSONObject;

public class AidRequester {
    private static final String TAG = AidRequester.class.getName();
    private static final String AIDSERVER = "http://hydra.alibaba.com/";
    private static final String AIDFUNCNAME = "/get_aid/";
    private static final String NAME_TOKEN = "auth[token]=";
    private static final String NAME_TYPE = "&type=";
    private static final String NAME_ID = "&id=";
    private static final String NAME_AID = "&aid=";
    private static final String NAME_RESUTL_DATA = "data";
    private static final String NAME_RESULT_AID = "aid";
    private static final String NAME_RESULT_ACTION = "action";
    private static final String NAME_RESULT_ISERROR = "isError";
    private static final String NAME_RESULT_STATUS = "status";
    private static final String TYPE_UTDID = "utdid";
    private static final String RSP_ACTION_NEW = "new";
    private static final String RSP_ACTION_CHANGED = "changed";
    private static final String RSP_ACTION_UNCHANGED = "unchanged";
    private static final String RSP_ISERROR_TRUE = "true";
    private static final String RSP_ISERROR_FALSE = "false";
    private static final String RSP_STATUS_OK = "200";
    private static final String RSP_STATUS_INVALID_APP = "404";
    private static final String RSP_STATUS_INVALID_TOKEN = "401";
    private static final int SESSION_TIME_OUT = 1000;
    private static final int WEAK_SESSION_TIME_OUT = 3000;
    private static AidRequester sAidRequester = null;
    private Context mContext;
    private Object mLock = new Object();

    public static synchronized AidRequester getInstance(Context context) {
        if (sAidRequester == null) {
            sAidRequester = new AidRequester(context);
        }
        return sAidRequester;
    }

    public AidRequester(Context context) {
        this.mContext = context;
    }

    public void postRestAsync(String appName, String token, String utdid, String oldAid, AidCallback callback) {
        String url = AidRequester.getPostUrl(appName, token, utdid, oldAid);
        if (DebugUtils.DBG) {
            Log.d((String)TAG, (String)("url:" + url + "; len:" + url.length()));
        }
        HttpPost post = new HttpPost(url);
        PostRestThread prThread = new PostRestThread(post, callback, oldAid, appName, token);
        prThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String postRest(String appName, String token, String utdid, String oldAid) {
        int timeout;
        String aid = "";
        String url = AidRequester.getPostUrl(appName, token, utdid, oldAid);
        int n2 = timeout = NetworkUtils.isConnectedToWeakNetwork(this.mContext) ? 3000 : 1000;
        if (DebugUtils.DBG) {
            Log.d((String)TAG, (String)("url:" + url + "; timeout:" + timeout));
        }
        HttpPost post = new HttpPost(url);
        PostRestThread prThread = new PostRestThread(post);
        prThread.start();
        try {
            Object object = this.mLock;
            synchronized (object) {
                this.mLock.wait(timeout);
            }
        }
        catch (Exception e2) {
            Log.e((String)TAG, (String)e2.toString());
        }
        aid = prThread.getResponseLine();
        if (DebugUtils.DBG) {
            Log.d((String)TAG, (String)("mLine:" + aid));
        }
        aid = AidRequester.getAidFromJsonRsp(aid, oldAid);
        return aid;
    }

    private static String getAidFromJsonRsp(String jsonData, String oldAid) {
        String aid = oldAid;
        if (!TextUtils.isEmpty((CharSequence)jsonData)) {
            String action = "";
            try {
                JSONObject jObject = new JSONObject(jsonData);
                if (jObject.has(NAME_RESUTL_DATA)) {
                    JSONObject data = jObject.getJSONObject(NAME_RESUTL_DATA);
                    if (data.has(NAME_RESULT_ACTION) && data.has(NAME_RESULT_AID) && ((action = data.getString(NAME_RESULT_ACTION)).equalsIgnoreCase(RSP_ACTION_NEW) || action.equalsIgnoreCase(RSP_ACTION_CHANGED))) {
                        aid = data.getString(NAME_RESULT_AID);
                    }
                } else if (jObject.has(NAME_RESULT_ISERROR) && jObject.has(NAME_RESULT_STATUS)) {
                    String isError = jObject.getString(NAME_RESULT_ISERROR);
                    String status = jObject.getString(NAME_RESULT_STATUS);
                    if (isError.equalsIgnoreCase(RSP_ISERROR_TRUE) && (status.equalsIgnoreCase(RSP_STATUS_INVALID_APP) || status.equalsIgnoreCase(RSP_STATUS_INVALID_TOKEN))) {
                        if (DebugUtils.DBG) {
                            Log.d((String)TAG, (String)("remove the AID, status:" + status));
                        }
                        aid = "";
                    }
                }
            }
            catch (JSONException e2) {
                Log.e((String)TAG, (String)e2.toString());
            }
            catch (Exception e3) {
                Log.e((String)TAG, (String)e3.toString());
            }
        }
        return aid;
    }

    private static String getPostUrl(String appName, String token, String utdid, String oldAid) {
        String encodedUtdid;
        StringBuilder sb = new StringBuilder();
        try {
            encodedUtdid = URLEncoder.encode(utdid, "UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            e2.printStackTrace();
            encodedUtdid = utdid;
        }
        return sb.append(AIDSERVER).append(appName).append(AIDFUNCNAME).append("?").append(NAME_TOKEN).append(token).append(NAME_TYPE).append(TYPE_UTDID).append(NAME_ID).append(encodedUtdid).append(NAME_AID).append(oldAid).toString();
    }

    class PostRestThread
    extends Thread {
        HttpPost mPost;
        String mRspLine = "";
        AidCallback mCallback;
        String mOldAid;
        String mAppName;
        String mToken = "";

        public PostRestThread(HttpPost post) {
            this.mPost = post;
        }

        public PostRestThread(HttpPost post, AidCallback callback, String oldAid, String appName, String token) {
            this.mPost = post;
            this.mCallback = callback;
            this.mOldAid = oldAid;
            this.mAppName = appName;
            this.mToken = token;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.mCallback != null) {
                this.mCallback.onAidEventChanged(1000, this.mOldAid);
            }
            DefaultHttpClient client = new DefaultHttpClient();
            HttpResponse response = null;
            try {
                response = client.execute((HttpUriRequest)this.mPost);
            }
            catch (Exception e2) {
                if (this.mCallback != null) {
                    this.mCallback.onAidEventChanged(1002, this.mOldAid);
                }
                Log.e((String)TAG, (String)e2.toString());
            }
            BufferedReader rd = null;
            try {
                if (response != null) {
                    rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), Charset.forName("UTF-8")));
                } else {
                    Log.e((String)TAG, (String)"response is null!");
                }
            }
            catch (Exception e3) {
                if (this.mCallback != null) {
                    this.mCallback.onAidEventChanged(1002, this.mOldAid);
                }
                Log.e((String)TAG, (String)e3.toString());
            }
            String line = "";
            try {
                if (rd != null) {
                    while ((line = rd.readLine()) != null) {
                        if (DebugUtils.DBG) {
                            Log.d((String)TAG, (String)line);
                        }
                        this.mRspLine = line;
                    }
                } else {
                    Log.e((String)TAG, (String)"BufferredReader is null!");
                }
            }
            catch (Exception e4) {
                if (this.mCallback != null) {
                    this.mCallback.onAidEventChanged(1002, this.mOldAid);
                }
                Log.e((String)TAG, (String)e4.toString());
            }
            if (rd != null) {
                try {
                    rd.close();
                    if (DebugUtils.DBG) {
                        Log.d((String)TAG, (String)"close the bufferreader");
                    }
                }
                catch (IOException e5) {
                    Log.e((String)TAG, (String)e5.toString());
                }
            }
            if (this.mCallback == null) {
                Object e5 = AidRequester.this.mLock;
                synchronized (e5) {
                    AidRequester.this.mLock.notifyAll();
                }
            } else {
                String aid = AidRequester.getAidFromJsonRsp(this.mRspLine, this.mOldAid);
                this.mCallback.onAidEventChanged(1001, aid);
                AidStorageController.setAidValueToSP(AidRequester.this.mContext, this.mAppName, aid, this.mToken);
            }
        }

        public String getResponseLine() {
            return this.mRspLine;
        }
    }
}

