/*
 * Decompiled with CFR 0.152.
 */
package com.ta.utdid2.core.persistent;

import android.util.Xml;
import com.ta.utdid2.core.persistent.FastXmlSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

class XmlUtils {
    public static final void writeMapXml(Map val, OutputStream out) throws XmlPullParserException, IOException {
        FastXmlSerializer serializer = new FastXmlSerializer();
        serializer.setOutput(out, "utf-8");
        serializer.startDocument(null, true);
        serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        XmlUtils.writeMapXml(val, null, serializer);
        serializer.endDocument();
    }

    public static final void writeMapXml(Map val, String name, XmlSerializer out) throws XmlPullParserException, IOException {
        if (val == null) {
            out.startTag(null, "null");
            out.endTag(null, "null");
            return;
        }
        Set s2 = val.entrySet();
        Iterator i2 = s2.iterator();
        out.startTag(null, "map");
        if (name != null) {
            out.attribute(null, "name", name);
        }
        while (i2.hasNext()) {
            Map.Entry e2 = i2.next();
            XmlUtils.writeValueXml(e2.getValue(), (String)e2.getKey(), out);
        }
        out.endTag(null, "map");
    }

    public static final void writeListXml(List val, String name, XmlSerializer out) throws XmlPullParserException, IOException {
        if (val == null) {
            out.startTag(null, "null");
            out.endTag(null, "null");
            return;
        }
        out.startTag(null, "list");
        if (name != null) {
            out.attribute(null, "name", name);
        }
        int N = val.size();
        for (int i2 = 0; i2 < N; ++i2) {
            XmlUtils.writeValueXml(val.get(i2), null, out);
        }
        out.endTag(null, "list");
    }

    public static final void writeByteArrayXml(byte[] val, String name, XmlSerializer out) throws XmlPullParserException, IOException {
        if (val == null) {
            out.startTag(null, "null");
            out.endTag(null, "null");
            return;
        }
        out.startTag(null, "byte-array");
        if (name != null) {
            out.attribute(null, "name", name);
        }
        int N = val.length;
        out.attribute(null, "num", Integer.toString(N));
        StringBuilder sb = new StringBuilder(val.length * 2);
        for (int i2 = 0; i2 < N; ++i2) {
            byte b2 = val[i2];
            int h2 = b2 >> 4;
            sb.append(h2 >= 10 ? 97 + h2 - 10 : 48 + h2);
            h2 = b2 & 0xFF;
            sb.append(h2 >= 10 ? 97 + h2 - 10 : 48 + h2);
        }
        out.text(sb.toString());
        out.endTag(null, "byte-array");
    }

    public static final void writeIntArrayXml(int[] val, String name, XmlSerializer out) throws XmlPullParserException, IOException {
        if (val == null) {
            out.startTag(null, "null");
            out.endTag(null, "null");
            return;
        }
        out.startTag(null, "int-array");
        if (name != null) {
            out.attribute(null, "name", name);
        }
        int N = val.length;
        out.attribute(null, "num", Integer.toString(N));
        for (int i2 = 0; i2 < N; ++i2) {
            out.startTag(null, "item");
            out.attribute(null, "value", Integer.toString(val[i2]));
            out.endTag(null, "item");
        }
        out.endTag(null, "int-array");
    }

    public static final void writeValueXml(Object v2, String name, XmlSerializer out) throws XmlPullParserException, IOException {
        String typeStr;
        if (v2 == null) {
            out.startTag(null, "null");
            if (name != null) {
                out.attribute(null, "name", name);
            }
            out.endTag(null, "null");
            return;
        }
        if (v2 instanceof String) {
            out.startTag(null, "string");
            if (name != null) {
                out.attribute(null, "name", name);
            }
            out.text(v2.toString());
            out.endTag(null, "string");
            return;
        }
        if (v2 instanceof Integer) {
            typeStr = "int";
        } else if (v2 instanceof Long) {
            typeStr = "long";
        } else if (v2 instanceof Float) {
            typeStr = "float";
        } else if (v2 instanceof Double) {
            typeStr = "double";
        } else if (v2 instanceof Boolean) {
            typeStr = "boolean";
        } else {
            if (v2 instanceof byte[]) {
                XmlUtils.writeByteArrayXml((byte[])v2, name, out);
                return;
            }
            if (v2 instanceof int[]) {
                XmlUtils.writeIntArrayXml((int[])v2, name, out);
                return;
            }
            if (v2 instanceof Map) {
                XmlUtils.writeMapXml((Map)v2, name, out);
                return;
            }
            if (v2 instanceof List) {
                XmlUtils.writeListXml((List)v2, name, out);
                return;
            }
            if (v2 instanceof CharSequence) {
                out.startTag(null, "string");
                if (name != null) {
                    out.attribute(null, "name", name);
                }
                out.text(v2.toString());
                out.endTag(null, "string");
                return;
            }
            throw new RuntimeException("writeValueXml: unable to write value " + v2);
        }
        out.startTag(null, typeStr);
        if (name != null) {
            out.attribute(null, "name", name);
        }
        out.attribute(null, "value", v2.toString());
        out.endTag(null, typeStr);
    }

    public static final HashMap readMapXml(InputStream in) throws XmlPullParserException, IOException {
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(in, null);
        return (HashMap)XmlUtils.readValueXml(parser, new String[1]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final HashMap readThisMapXml(XmlPullParser parser, String endTag, String[] name) throws XmlPullParserException, IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                Object val = XmlUtils.readThisValueXml(parser, name);
                if (name[0] == null) throw new XmlPullParserException("Map value without name attribute: " + parser.getName());
                map.put(name[0], val);
            } else if (eventType == 3) {
                if (!parser.getName().equals(endTag)) throw new XmlPullParserException("Expected " + endTag + " end tag at: " + parser.getName());
                return map;
            }
            eventType = parser.next();
        } while (eventType != 1);
        throw new XmlPullParserException("Document ended before " + endTag + " end tag");
    }

    public static final ArrayList readThisListXml(XmlPullParser parser, String endTag, String[] name) throws XmlPullParserException, IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                Object val = XmlUtils.readThisValueXml(parser, name);
                list.add(val);
            } else if (eventType == 3) {
                if (parser.getName().equals(endTag)) {
                    return list;
                }
                throw new XmlPullParserException("Expected " + endTag + " end tag at: " + parser.getName());
            }
            eventType = parser.next();
        } while (eventType != 1);
        throw new XmlPullParserException("Document ended before " + endTag + " end tag");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final int[] readThisIntArrayXml(XmlPullParser parser, String endTag, String[] name) throws XmlPullParserException, IOException {
        int num;
        try {
            num = Integer.parseInt(parser.getAttributeValue(null, "num"));
        }
        catch (NullPointerException e2) {
            throw new XmlPullParserException("Need num attribute in byte-array");
        }
        catch (NumberFormatException e3) {
            throw new XmlPullParserException("Not a number in num attribute in byte-array");
        }
        int[] array = new int[num];
        int i2 = 0;
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                if (!parser.getName().equals("item")) throw new XmlPullParserException("Expected item tag at: " + parser.getName());
                try {
                    array[i2] = Integer.parseInt(parser.getAttributeValue(null, "value"));
                }
                catch (NullPointerException e4) {
                    throw new XmlPullParserException("Need value attribute in item");
                }
                catch (NumberFormatException e5) {
                    throw new XmlPullParserException("Not a number in value attribute in item");
                }
            } else if (eventType == 3) {
                if (parser.getName().equals(endTag)) {
                    return array;
                }
                if (!parser.getName().equals("item")) throw new XmlPullParserException("Expected " + endTag + " end tag at: " + parser.getName());
                ++i2;
            }
            eventType = parser.next();
        } while (eventType != 1);
        throw new XmlPullParserException("Document ended before " + endTag + " end tag");
    }

    public static final Object readValueXml(XmlPullParser parser, String[] name) throws XmlPullParserException, IOException {
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                return XmlUtils.readThisValueXml(parser, name);
            }
            if (eventType == 3) {
                throw new XmlPullParserException("Unexpected end tag at: " + parser.getName());
            }
            if (eventType == 4) {
                throw new XmlPullParserException("Unexpected text: " + parser.getText());
            }
            try {
                eventType = parser.next();
            }
            catch (Exception e2) {
                throw new XmlPullParserException("Unexpected call next(): " + parser.getName());
            }
        } while (eventType != 1);
        throw new XmlPullParserException("Unexpected end of document");
    }

    private static final Object readThisValueXml(XmlPullParser parser, String[] name) throws XmlPullParserException, IOException {
        String tagName;
        block25: {
            int eventType;
            Constable res;
            String valueName = parser.getAttributeValue(null, "name");
            tagName = parser.getName();
            if (tagName.equals("null")) {
                res = null;
            } else {
                if (tagName.equals("string")) {
                    block24: {
                        String value = "";
                        while (true) {
                            int eventType2 = parser.next();
                            if (eventType2 == 1) break block24;
                            if (eventType2 == 3) {
                                if (parser.getName().equals("string")) {
                                    name[0] = valueName;
                                    return value;
                                }
                                throw new XmlPullParserException("Unexpected end tag in <string>: " + parser.getName());
                            }
                            if (eventType2 == 4) {
                                value = value + parser.getText();
                                continue;
                            }
                            if (eventType2 == 2) break;
                        }
                        throw new XmlPullParserException("Unexpected start tag in <string>: " + parser.getName());
                    }
                    throw new XmlPullParserException("Unexpected end of document in <string>");
                }
                if (tagName.equals("int")) {
                    res = Integer.parseInt(parser.getAttributeValue(null, "value"));
                } else if (tagName.equals("long")) {
                    res = Long.valueOf(parser.getAttributeValue(null, "value"));
                } else if (tagName.equals("float")) {
                    res = new Float(parser.getAttributeValue(null, "value"));
                } else if (tagName.equals("double")) {
                    res = new Double(parser.getAttributeValue(null, "value"));
                } else if (tagName.equals("boolean")) {
                    res = Boolean.valueOf(parser.getAttributeValue(null, "value"));
                } else {
                    if (tagName.equals("int-array")) {
                        parser.next();
                        int[] res2 = XmlUtils.readThisIntArrayXml(parser, "int-array", name);
                        name[0] = valueName;
                        return res2;
                    }
                    if (tagName.equals("map")) {
                        parser.next();
                        HashMap res3 = XmlUtils.readThisMapXml(parser, "map", name);
                        name[0] = valueName;
                        return res3;
                    }
                    if (tagName.equals("list")) {
                        parser.next();
                        ArrayList res4 = XmlUtils.readThisListXml(parser, "list", name);
                        name[0] = valueName;
                        return res4;
                    }
                    throw new XmlPullParserException("Unknown tag: " + tagName);
                }
            }
            do {
                eventType = parser.next();
                if (eventType == 1) break block25;
                if (eventType == 3) {
                    if (parser.getName().equals(tagName)) {
                        name[0] = valueName;
                        return res;
                    }
                    throw new XmlPullParserException("Unexpected end tag in <" + tagName + ">: " + parser.getName());
                }
                if (eventType == 4) {
                    throw new XmlPullParserException("Unexpected text in <" + tagName + ">: " + parser.getName());
                }
            } while (eventType != 2);
            throw new XmlPullParserException("Unexpected start tag in <" + tagName + ">: " + parser.getName());
        }
        throw new XmlPullParserException("Unexpected end of document in <" + tagName + ">");
    }
}

