/*
 * Decompiled with CFR 0.152.
 */
package cn.jiguang.analytics.page;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import cn.jiguang.analytics.page.PushSA;
import cn.jiguang.ap.d;
import cn.jiguang.api.JCoreManager;
import cn.jiguang.internal.JConstants;

@TargetApi(value=14)
public class ActivityLifecycle
implements Application.ActivityLifecycleCallbacks {
    private static final String TAG = "ActivityLifecycle";
    private static int activityTaskCount = 0;

    public void onActivityCreated(Activity activity, Bundle bundle) {
        d.b(TAG, "onActivityCreated:" + activity.getClass().getCanonicalName());
        try {
            if (JConstants.jAnalyticsAction != null) {
                JConstants.jAnalyticsAction.dispatchStatus((Context)activity, "onCreate");
            }
            return;
        }
        catch (Throwable throwable) {
            d.b(TAG, "onActivityCreated failed");
            return;
        }
    }

    public void onActivityStarted(Activity activity) {
        if (activity != null) {
            d.b(TAG, "onActivityStarted:" + activity.getClass().getCanonicalName());
        }
        try {
            if (activityTaskCount == 0) {
                d.b(TAG, "isForeground");
                if (activity != null) {
                    JCoreManager.onEvent(activity.getApplicationContext(), "JCore", 66, null, null, true);
                }
                if (JConstants.jAnalyticsAction != null) {
                    JConstants.jAnalyticsAction.dispatchStatus((Context)activity, "onStart");
                }
            }
            ++activityTaskCount;
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public void onActivityResumed(Activity activity) {
        try {
            d.d(TAG, "onActivityResumed:" + activity.getClass().getCanonicalName());
            if (JConstants.jAnalyticsAction != null) {
                JConstants.jAnalyticsAction.dispatchResume((Context)activity);
            }
            if (!JConstants.isInstrumentationHookFailed) {
                PushSA.getInstance().onResume((Context)activity);
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public void onActivityPaused(Activity activity) {
        try {
            d.d(TAG, "onActivityPaused:" + activity.getClass().getCanonicalName());
            if (JConstants.jAnalyticsAction != null) {
                JConstants.jAnalyticsAction.dispatchPause((Context)activity);
            }
            if (!JConstants.isInstrumentationHookFailed) {
                PushSA.getInstance().onPause((Context)activity);
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public void onActivityStopped(Activity activity) {
        try {
            d.b(TAG, "onActivityStopped:" + activity.getClass().getCanonicalName());
            if (activityTaskCount > 0) {
                --activityTaskCount;
            }
            if (activityTaskCount == 0) {
                d.b(TAG, "is not Foreground");
                activity = JConstants.getAppContext((Context)activity);
                JCoreManager.onEvent((Context)activity, "JCore", 66, null, null, false);
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public void onActivityDestroyed(Activity activity) {
    }
}

