/*
 * Decompiled with CFR 0.152.
 */
package cn.jiguang.analytics.page;

import android.app.Application;
import android.content.Context;
import android.text.TextUtils;
import cn.jiguang.analytics.page.a;
import cn.jiguang.analytics.page.b;
import cn.jiguang.analytics.page.c;
import cn.jiguang.analytics.page.d;
import cn.jiguang.api.JCoreManager;
import cn.jiguang.aq.k;
import cn.jiguang.f.i;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PushSA {
    private static final String TAG = "PushSA";
    private static final String SESSION_START_MILLIS = "css";
    private static final String SESSION_END_MILLIS = "cse";
    private static final String KEY_SESSION_ID = "session_id";
    public static final String CACHE_PATH = "push_stat_cache.json";
    private static volatile PushSA instance = null;
    public static boolean isOnResumeInvoke = false;
    public static boolean isOnPauseInvoke = false;
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private String cur_activity = null;
    private String cur_session_id = null;
    private long interval = 30L;
    private long latestResumeTime = 0L;
    private long latestPauseTime = 0L;
    private boolean firstResume = true;
    private boolean activitySwitch = false;
    private boolean stat_enable = true;
    private long tempTimelong = 0L;
    public static final String REPORT_ACTIVE_LAUNCH = "active_launch";
    public static final String REPORT_ACTIVE_TERMINATE = "active_terminate";
    private JSONObject flow_cache = null;
    private final Object cur_session_file_lock = new Object();

    private PushSA() {
    }

    public void onFragmentResume(Context context, String string) {
        if (this.activitySwitch) {
            cn.jiguang.ap.d.b(TAG, "JCoreInterface.onResume() must be called after called JCoreInterface.onPause() in last Activity or Fragment");
            return;
        }
        this.activitySwitch = true;
        this.cur_activity = string;
        this.latestResumeTime = System.currentTimeMillis();
        context = context.getApplicationContext();
        try {
            this.executor.execute(new a(this, context));
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public void onFragmentPause(Context context, String string) {
        if (!this.activitySwitch) {
            cn.jiguang.ap.d.b(TAG, "JCoreInterface.onPause() must be called after called JCoreInterface.onResume() in this Activity or Fragment");
            return;
        }
        this.activitySwitch = false;
        if (this.cur_activity != null && this.cur_activity.equals(string)) {
            this.latestPauseTime = System.currentTimeMillis();
            context = context.getApplicationContext();
            try {
                this.executor.execute(new b(this, context));
            }
            catch (Throwable throwable) {
                return;
            }
        } else {
            cn.jiguang.ap.d.i(TAG, "page name didn't match the last one passed by onResume");
        }
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long l2) {
        this.interval = l2;
    }

    public boolean isStatEnable() {
        return this.stat_enable;
    }

    public void setStatEnable(boolean bl) {
        this.stat_enable = bl;
    }

    public void onKillProcess(Context context) {
        block5: {
            try {
                if (this.cur_activity != null && this.activitySwitch) {
                    this.latestPauseTime = System.currentTimeMillis();
                    context = context.getApplicationContext();
                    try {
                        this.executor.execute(new c(this, context));
                        break block5;
                    }
                    catch (Throwable throwable) {}
                }
                return;
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PushSA getInstance() {
        if (instance != null) return instance;
        Class<PushSA> clazz = PushSA.class;
        synchronized (PushSA.class) {
            instance = new PushSA();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void onResume(Context context) {
        if (!this.invokeCheck(context, "onResume")) {
            return;
        }
        isOnResumeInvoke = true;
        try {
            this.activitySwitch = false;
        }
        catch (ClassCastException classCastException) {
        }
        catch (Exception exception) {}
        if (this.activitySwitch) {
            return;
        }
        this.activitySwitch = true;
        this.latestResumeTime = System.currentTimeMillis();
        this.cur_activity = context.getClass().getName();
        try {
            context = context.getApplicationContext();
            this.executor.execute(new d(true, context, this));
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public void onPause(Context context) {
        Exception exception;
        if (!this.invokeCheck(context, "onPause")) {
            return;
        }
        isOnPauseInvoke = true;
        try {
            this.activitySwitch = true;
        }
        catch (ClassCastException classCastException) {
        }
        catch (Exception exception2) {
            exception = exception2;
            exception2.printStackTrace();
        }
        if (!this.activitySwitch) {
            return;
        }
        this.activitySwitch = false;
        if (this.cur_activity != null && this.cur_activity.equals(context.getClass().getName())) {
            this.latestPauseTime = System.currentTimeMillis();
            this.tempTimelong = this.latestResumeTime;
            try {
                exception = context.getApplicationContext();
                this.executor.execute(new d(false, (Context)exception, this));
                return;
            }
            catch (Throwable throwable) {
                return;
            }
        }
        cn.jiguang.ap.d.d(TAG, "the activity pass by onPause didn't match last one passed by onResume");
    }

    private boolean invokeCheck(Context context, String string) {
        if (!this.stat_enable) {
            cn.jiguang.ap.d.d(TAG, "stat function has been disabled");
            return false;
        }
        if (context == null) {
            cn.jiguang.ap.d.d(TAG, "context is null");
            return false;
        }
        if (context instanceof Application) {
            cn.jiguang.ap.d.i(TAG, "Context should be an Activity on this method : " + string);
            return false;
        }
        return true;
    }

    private void wrapDate(JSONObject jSONObject) {
        String string = cn.jiguang.f.c.a();
        String string2 = string.split("_")[0];
        string = string.split("_")[1];
        jSONObject.put("date", (Object)string2);
        jSONObject.put("time", (Object)string);
    }

    private JSONObject createNewSession(Context context, long l2) {
        this.cur_session_id = this.generateSessionID(context, l2);
        cn.jiguang.g.b.a(context, new cn.jiguang.g.a[]{cn.jiguang.g.a.o().a(this.latestResumeTime), cn.jiguang.g.a.r().a(this.cur_session_id)});
        JSONObject jSONObject = new JSONObject();
        try {
            this.wrapDate(jSONObject);
            cn.jiguang.d.a.a(context, jSONObject, REPORT_ACTIVE_LAUNCH);
            jSONObject.put(KEY_SESSION_ID, (Object)this.cur_session_id);
        }
        catch (JSONException jSONException) {
            return null;
        }
        return jSONObject;
    }

    private String generateSessionID(Context object, long l2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!TextUtils.isEmpty((CharSequence)(object = cn.jiguang.ao.a.a(object)))) {
            stringBuilder.append((String)object);
        }
        stringBuilder.append(l2);
        return i.d(stringBuilder.toString());
    }

    private boolean isNewSession(Context context) {
        boolean bl = true;
        if (this.firstResume) {
            this.firstResume = false;
            cn.jiguang.ap.d.b(TAG, "statistics start");
            long l2 = cn.jiguang.g.b.a(context, cn.jiguang.g.a.q());
            cn.jiguang.ap.d.b(TAG, "lastPause:" + l2 + ",latestResumeTime:" + this.latestResumeTime + ",interval:" + this.interval * 1000L + ",a:" + (this.latestResumeTime - l2));
            if (l2 > 0L && this.latestResumeTime - l2 <= this.interval * 1000L) {
                bl = false;
            }
        } else if (this.latestResumeTime - this.latestPauseTime <= this.interval * 1000L) {
            bl = false;
        }
        return bl;
    }

    private JSONObject getFlowCache(Context context) {
        if (this.flow_cache == null) {
            this.flow_cache = cn.jiguang.d.a.a(context, CACHE_PATH);
        }
        return this.flow_cache;
    }

    private void updateFlowCache(JSONObject jSONObject) {
        this.flow_cache = jSONObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendLogRoutine(Context context) {
        if (this.isNewSession(context)) {
            cn.jiguang.ap.d.d(TAG, "new statistics session");
            JSONArray jSONArray = new JSONArray();
            JSONObject jSONObject = this.createNewSession(context, this.latestResumeTime);
            if (jSONObject != null) {
                jSONArray.put((Object)jSONObject);
            }
            Object object = this.cur_session_file_lock;
            synchronized (object) {
                jSONObject = this.getFlowCache(context);
                if (jSONObject != null && jSONObject.length() > 0) {
                    try {
                        cn.jiguang.d.a.a(context, jSONObject, REPORT_ACTIVE_TERMINATE);
                    }
                    catch (Exception exception) {}
                    this.clearCurrentLogFile(context);
                    this.flow_cache = null;
                }
            }
            if (jSONObject != null && jSONObject.length() > 0) {
                jSONArray.put((Object)jSONObject);
            }
            JCoreManager.onEvent(context, "JCore", 14, null, null, jSONArray);
            return;
        }
        this.cur_session_id = cn.jiguang.g.b.b(context, cn.jiguang.g.a.r());
    }

    private void clearCurrentLogFile(Context context) {
        k.a(context, CACHE_PATH, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveLogRoutine(Context context) {
        if (context == null) {
            return;
        }
        Object object = this.cur_session_file_lock;
        synchronized (object) {
            cn.jiguang.g.b.a(context, new cn.jiguang.g.a[]{cn.jiguang.g.a.q().a(this.latestPauseTime), cn.jiguang.g.a.p().a(this.latestPauseTime)});
            JSONObject jSONObject = this.getFlowCache(context);
            if (jSONObject == null) {
                jSONObject = new JSONObject();
            }
            try {
                this.updateFlowInfo(jSONObject, context);
            }
            catch (Exception exception) {}
            this.updateFlowCache(jSONObject);
            this.saveCurrentLog(context, jSONObject);
            return;
        }
    }

    private void saveCurrentLog(Context context, JSONObject jSONObject) {
        k.a(context, CACHE_PATH, jSONObject);
    }

    private void updateFlowInfo(JSONObject jSONObject, Context context) {
        long l2 = cn.jiguang.g.b.a(context, cn.jiguang.g.a.o());
        long l3 = 10L;
        if (l2 <= 0L) {
            long l4 = this.latestPauseTime - this.tempTimelong;
            if (l4 > 0L) {
                l3 = l4 / 1000L;
            }
            cn.jiguang.g.b.a(context, new cn.jiguang.g.a[]{cn.jiguang.g.a.o().a(this.tempTimelong)});
        } else {
            l3 = (this.latestPauseTime - l2) / 1000L;
        }
        jSONObject.put("duration", l3);
        jSONObject.put("itime", System.currentTimeMillis() / 1000L);
        jSONObject.put(KEY_SESSION_ID, (Object)this.cur_session_id);
        this.wrapDate(jSONObject);
    }

    static /* synthetic */ void access$000(PushSA pushSA, Context context) {
        pushSA.sendLogRoutine(context);
    }

    static /* synthetic */ void access$100(PushSA pushSA, Context context) {
        pushSA.saveLogRoutine(context);
    }
}

