/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.android.api;

import android.app.Notification;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Icon;
import android.os.Build;
import android.text.TextUtils;
import android.widget.RemoteViews;
import cn.jpush.android.api.NotificationMessage;
import cn.jpush.android.api.PushNotificationBuilder;
import cn.jpush.android.helper.Logger;
import cn.jpush.android.p.a;
import cn.jpush.android.p.b;
import cn.jpush.android.p.f;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.json.JSONObject;

public class DefaultPushNotificationBuilder
implements PushNotificationBuilder {
    private static final String TAG = "DefaultPushNotificationBuilder";
    protected Context context;
    public static final int NOTI_STYLE_BIG_TEXT = 1;
    public static final int NOTI_STYLE_INBOX = 2;
    public static final int NOTI_STYLE_BIG_PICTURE = 3;
    private NotificationMessage notificationMessage;

    @Override
    public Notification buildNotification(Map<String, String> map) {
        if (this.context == null) {
            Logger.w(TAG, "Can't find valid context when build notification.");
            return null;
        }
        String string = null;
        try {
            string = this.context.getApplicationInfo().loadLabel(this.context.getPackageManager()).toString();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String string2 = "";
        String string3 = "";
        String string4 = "";
        int n = 0;
        String string5 = "";
        String string6 = "";
        int n2 = -1;
        String string7 = "";
        String string8 = "";
        String string9 = "";
        if (map.containsKey("cn.jpush.android.MSG_ID")) {
            string9 = map.get("cn.jpush.android.MSG_ID");
        }
        if (map.containsKey("cn.jpush.android.ALERT")) {
            string2 = map.get("cn.jpush.android.ALERT");
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            Logger.ww(TAG, "No notification content to show. Give up.");
            return null;
        }
        if (map.containsKey("cn.jpush.android.NOTIFICATION_SMALL_ICON")) {
            string7 = map.get("cn.jpush.android.NOTIFICATION_SMALL_ICON");
        }
        if (map.containsKey("cn.jpush.android.NOTIFICATION_LARGE_ICON")) {
            string8 = map.get("cn.jpush.android.NOTIFICATION_LARGE_ICON");
        }
        if (map.containsKey("cn.jpush.android.NOTIFICATION_CONTENT_TITLE")) {
            string = map.get("cn.jpush.android.NOTIFICATION_CONTENT_TITLE");
        }
        if (map.containsKey("cn.jpush.android.BIG_TEXT")) {
            string3 = map.get("cn.jpush.android.BIG_TEXT");
        }
        if (map.containsKey("cn.jpush.android.INBOX")) {
            string4 = map.get("cn.jpush.android.INBOX");
        }
        if (map.containsKey("cn.jpush.android.NOTI_PRIORITY")) {
            n = Integer.parseInt(map.get("cn.jpush.android.NOTI_PRIORITY"));
        }
        if (map.containsKey("cn.jpush.android.NOTI_CATEGORY")) {
            string5 = map.get("cn.jpush.android.NOTI_CATEGORY");
        }
        if (map.containsKey("cn.jpush.android.BIG_PIC_PATH")) {
            string6 = map.get("cn.jpush.android.BIG_PIC_PATH");
        }
        if (map.containsKey("cn.jpush.android.ALERT_TYPE")) {
            n2 = Integer.parseInt(map.get("cn.jpush.android.ALERT_TYPE"));
        }
        if (n2 < -1 || n2 > 7) {
            n2 = -1;
        }
        RemoteViews remoteViews = this.buildContentView(string2, string);
        if (Build.VERSION.SDK_INT >= 11) {
            Notification.Builder builder = new Notification.Builder(this.context);
            builder.setContentTitle((CharSequence)string).setContentText((CharSequence)string2).setTicker((CharSequence)string2);
            int n3 = f.a(this.context);
            if (n3 != 0) {
                Logger.dd(TAG, "setSmallIcon with resId:" + n3);
                builder.setSmallIcon(n3);
            } else {
                Logger.ww(TAG, "not found small icon in your app,will setSmallIcon with android.R.color.transparent ");
                builder.setSmallIcon(17170445);
            }
            Object object = b.c(this.context, string8);
            if (Build.VERSION.SDK_INT >= 23) {
                if (object instanceof Icon) {
                    builder.setLargeIcon((Icon)object);
                }
            } else if (object instanceof Bitmap) {
                builder.setLargeIcon((Bitmap)object);
            }
            if (Build.VERSION.SDK_INT >= 17) {
                builder.setShowWhen(true);
            }
            a.a(this.context, builder, this.notificationMessage != null ? this.notificationMessage.notificationChannelId : "", (CharSequence)"", n, n2, null);
            if (Build.VERSION.SDK_INT >= 16) {
                if (remoteViews == null) {
                    Bitmap bitmap;
                    Notification.BigTextStyle bigTextStyle;
                    if (!TextUtils.isEmpty((CharSequence)string3)) {
                        bigTextStyle = new Notification.BigTextStyle();
                        bigTextStyle.bigText((CharSequence)string3);
                        builder.setStyle((Notification.Style)bigTextStyle);
                    }
                    if (!TextUtils.isEmpty((CharSequence)string4)) {
                        bigTextStyle = new Notification.InboxStyle();
                        try {
                            bitmap = new TreeMap();
                            JSONObject jSONObject = new JSONObject(string4);
                            Iterator iterator = jSONObject.keys();
                            while (iterator.hasNext()) {
                                String string10 = (String)iterator.next();
                                String string11 = jSONObject.optString(string10);
                                bitmap.put(string10, string11);
                            }
                            for (String string11 : bitmap.values()) {
                                bigTextStyle.addLine((CharSequence)string11);
                            }
                            bigTextStyle.setSummaryText((CharSequence)(" + " + jSONObject.length() + " new messages"));
                        }
                        catch (Throwable throwable) {
                            Logger.ee(TAG, "Set inbox style error: " + throwable.getMessage());
                        }
                        builder.setStyle((Notification.Style)bigTextStyle);
                    }
                    if (!TextUtils.isEmpty((CharSequence)string6)) {
                        Logger.i(TAG, "Set notification BPS with picture path:" + string6);
                        try {
                            bigTextStyle = new Notification.BigPictureStyle();
                            bitmap = BitmapFactory.decodeFile((String)string6);
                            bigTextStyle.bigPicture(bitmap);
                            builder.setStyle((Notification.Style)bigTextStyle);
                        }
                        catch (Throwable throwable) {
                            Logger.ww(TAG, "Create big picture style failed.");
                        }
                    }
                }
                if (n != 0) {
                    if (n == 1) {
                        builder.setPriority(1);
                    } else if (n == 2) {
                        builder.setPriority(2);
                    } else if (n == -1) {
                        builder.setPriority(-1);
                    } else if (n == -2) {
                        builder.setPriority(-2);
                    } else {
                        builder.setPriority(0);
                    }
                }
                if (!TextUtils.isEmpty((CharSequence)string5) && Build.VERSION.SDK_INT >= 21) {
                    builder.setCategory(string5);
                }
            }
            if (null != remoteViews) {
                builder.setContent(remoteViews);
            } else {
                Logger.i(TAG, " Use default notification view! ");
            }
            builder.setDefaults(n2);
            return this.getNotification(builder);
        }
        Notification notification = new Notification(f.a(this.context), (CharSequence)string2, System.currentTimeMillis());
        this.resetNotificationParams(notification);
        notification.defaults = n2;
        if (null != remoteViews) {
            notification.contentView = remoteViews;
        } else {
            b.a(notification, this.context, string, string2, null);
        }
        return notification;
    }

    @Override
    public Notification buildNotification(Context context, NotificationMessage notificationMessage) {
        this.context = context;
        this.notificationMessage = notificationMessage;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (notificationMessage != null) {
            Logger.d(TAG, "notificationContent:" + notificationMessage.notificationContent + "\nnotificationTitle" + notificationMessage.notificationTitle + "\nnotificationStyle:" + notificationMessage.notificationStyle + "\nnotificationPriority:" + notificationMessage.notificationPriority + "\nnotificationBigText:" + notificationMessage.notificationBigText + "\nnotificationBigPicPath:" + notificationMessage.notificationBigPicPath + "\nnotificationInbox:" + notificationMessage.notificationInbox + "\nnotificationCategory:" + notificationMessage.notificationCategory + "\nnotificationAlertType:" + notificationMessage.notificationAlertType + "\nnotificationSmallIcon:" + notificationMessage.notificationSmallIcon + "\nnotificationLargeIcon:" + notificationMessage.notificationLargeIcon + "\nextraJson:" + notificationMessage.notificationExtras);
            hashMap.put("cn.jpush.android.MSG_ID", notificationMessage.msgId);
            hashMap.put("cn.jpush.android.ALERT", notificationMessage.notificationContent);
            hashMap.put("cn.jpush.android.ALERT_TYPE", notificationMessage.notificationAlertType + "");
            if (!TextUtils.isEmpty((CharSequence)notificationMessage.notificationTitle)) {
                hashMap.put("cn.jpush.android.NOTIFICATION_CONTENT_TITLE", notificationMessage.notificationTitle);
            }
            if (!TextUtils.isEmpty((CharSequence)notificationMessage.notificationExtras)) {
                hashMap.put("cn.jpush.android.EXTRA", notificationMessage.notificationExtras);
            }
            if (notificationMessage.notificationStyle == 1 && !TextUtils.isEmpty((CharSequence)notificationMessage.notificationBigText)) {
                hashMap.put("cn.jpush.android.BIG_TEXT", notificationMessage.notificationBigText);
            } else if (notificationMessage.notificationStyle == 2 && !TextUtils.isEmpty((CharSequence)notificationMessage.notificationInbox)) {
                hashMap.put("cn.jpush.android.INBOX", notificationMessage.notificationInbox);
            } else if (notificationMessage.notificationStyle == 3 && !TextUtils.isEmpty((CharSequence)notificationMessage.notificationBigPicPath)) {
                hashMap.put("cn.jpush.android.BIG_PIC_PATH", notificationMessage.notificationBigPicPath);
            }
            if (notificationMessage.notificationPriority != 0) {
                hashMap.put("cn.jpush.android.NOTI_PRIORITY", notificationMessage.notificationPriority + "");
            }
            if (!TextUtils.isEmpty((CharSequence)notificationMessage.notificationCategory)) {
                hashMap.put("cn.jpush.android.NOTI_CATEGORY", notificationMessage.notificationCategory);
            }
            if (!TextUtils.isEmpty((CharSequence)notificationMessage.notificationSmallIcon)) {
                hashMap.put("cn.jpush.android.NOTIFICATION_SMALL_ICON", notificationMessage.notificationSmallIcon);
            }
            if (!TextUtils.isEmpty((CharSequence)notificationMessage.notificationLargeIcon)) {
                hashMap.put("cn.jpush.android.NOTIFICATION_LARGE_ICON", notificationMessage.notificationSmallIcon);
            }
        }
        return this.buildNotification(hashMap);
    }

    @Override
    public String getDeveloperArg0() {
        return null;
    }

    RemoteViews buildContentView(String string, String string2) {
        return null;
    }

    void resetNotificationParams(Notification notification) {
    }

    Notification getNotification(Notification.Builder builder) {
        try {
            if (Build.VERSION.SDK_INT >= 16) {
                return builder.build();
            }
            return builder.getNotification();
        }
        catch (Throwable throwable) {
            Logger.ww(TAG, "Build notification error:", throwable);
            return null;
        }
    }

    public String toString() {
        return "";
    }
}

