/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.android.u;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.AppOpsManager;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentProvider;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.ComponentInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Environment;
import android.os.Process;
import android.text.TextUtils;
import android.webkit.WebSettings;
import android.webkit.WebView;
import cn.jpush.android.helper.Logger;
import cn.jpush.android.local.JPushConstants;
import cn.jpush.android.service.JNotifyActivity;
import cn.jpush.android.ui.PopWinActivity;
import cn.jpush.android.ui.PushActivity;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class a {
    private static String a = "";
    private static String b;

    public static boolean a(Context context) {
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            return networkInfo != null && networkInfo.isConnected();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public static ComponentInfo a(Context context, String string, Class<?> clazz) {
        if (context == null || TextUtils.isEmpty((CharSequence)string) || clazz == null) {
            Logger.w("AndroidUtil", "Action - hasComponent, invalide param, context:" + context + ",packageName:" + string + ",cls:" + clazz);
            return null;
        }
        try {
            ServiceInfo[] serviceInfoArray;
            int n = 0;
            if (Service.class.isAssignableFrom(clazz)) {
                n = 4;
            } else if (BroadcastReceiver.class.isAssignableFrom(clazz)) {
                n = 2;
            } else if (Activity.class.isAssignableFrom(clazz)) {
                n = 1;
            } else if (ContentProvider.class.isAssignableFrom(clazz)) {
                n = 8;
            }
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(string, n);
            switch (n) {
                case 4: {
                    serviceInfoArray = packageInfo.services;
                    break;
                }
                case 2: {
                    serviceInfoArray = packageInfo.receivers;
                    break;
                }
                case 1: {
                    serviceInfoArray = packageInfo.activities;
                    break;
                }
                case 8: {
                    serviceInfoArray = packageInfo.providers;
                    break;
                }
                default: {
                    serviceInfoArray = null;
                }
            }
            if (serviceInfoArray == null) {
                return null;
            }
            for (ServiceInfo serviceInfo : serviceInfoArray) {
                try {
                    if (!clazz.isAssignableFrom(Class.forName(serviceInfo.name))) continue;
                    return serviceInfo;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            Logger.ww("AndroidUtil", "hasComponent error:" + throwable.getMessage());
        }
        return null;
    }

    public static String b(Context context) {
        if (!TextUtils.isEmpty((CharSequence)a)) {
            return a;
        }
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 0);
            a = context.getPackageManager().getApplicationLabel(applicationInfo).toString();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return a;
    }

    public static boolean a(String string) {
        String string2;
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        boolean bl = (string = string.trim()).matches(string2 = "^[http|https]+://.*");
        if (!bl) {
            Logger.w("AndroidUtil", "Invalid url - " + string);
        }
        return bl;
    }

    public static boolean a(Context context, String string) {
        boolean bl = false;
        try {
            AppOpsManager appOpsManager;
            int n;
            String string2;
            int n2;
            bl = Build.VERSION.SDK_INT >= 23 ? (context.getApplicationInfo().targetSdkVersion >= 23 ? (n2 = context.checkSelfPermission(string)) == 0 : ((string2 = AppOpsManager.permissionToOp((String)string)) == null ? true : (n = (appOpsManager = (AppOpsManager)context.getSystemService("appops")).noteProxyOpNoThrow(string2, context.getPackageName())) == 0)) : true;
        }
        catch (Throwable throwable) {
            Logger.w("AndroidUtil", "checkPermission error:" + throwable.getMessage());
        }
        return bl;
    }

    public static String c(Context context) {
        block5: {
            if (!TextUtils.isEmpty((CharSequence)b)) {
                return b;
            }
            try {
                context = JPushConstants.getAppContext(context);
                ActivityManager activityManager = null;
                if (context != null) {
                    activityManager = (ActivityManager)context.getSystemService("activity");
                }
                if (activityManager == null) break block5;
                int n = Process.myPid();
                List list = activityManager.getRunningAppProcesses();
                for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                    if (runningAppProcessInfo.pid != n) continue;
                    b = runningAppProcessInfo.processName;
                    break;
                }
            }
            catch (Throwable throwable) {
                Logger.ww("AndroidUtil", "#unexcepted - getCurProcessName failed:" + throwable.getMessage());
            }
        }
        return b;
    }

    public static boolean a() {
        boolean bl = false;
        try {
            bl = Environment.getExternalStorageState().equals("mounted");
        }
        catch (Throwable throwable) {
            Logger.w("AndroidUtil", "isSdcardExist exception: " + throwable);
        }
        if (!bl) {
            Logger.d("AndroidUtil", "SDCard is not mounted");
        }
        return bl;
    }

    public static void d(Context context) {
        try {
            if (Build.VERSION.SDK_INT >= 28) {
                String string = cn.jpush.android.u.a.c(context);
                String string2 = context.getPackageName();
                if (string != null && string2 != null && !string2.equals(string)) {
                    WebView.setDataDirectorySuffix((String)string);
                    Logger.d("AndroidUtil", "setDataDirectorySuffix =" + string);
                }
            }
        }
        catch (Throwable throwable) {
            Logger.e("AndroidUtil", "fixWebViewProcess e:" + throwable);
        }
    }

    public static void a(WebView webView) {
        try {
            if (Build.VERSION.SDK_INT >= 11) {
                webView.removeJavascriptInterface("searchBoxJavaBridge_");
                webView.removeJavascriptInterface("accessibility");
                webView.removeJavascriptInterface("accessibilityTraversal");
            }
            if (Build.VERSION.SDK_INT >= 21) {
                webView.getSettings().setMixedContentMode(0);
            }
        }
        catch (Throwable throwable) {
            Logger.e("AndroidUtil", "fixSecure failed, error:" + throwable);
        }
    }

    public static void a(WebSettings webSettings) {
        webSettings.setUseWideViewPort(true);
        webSettings.setLoadWithOverviewMode(true);
        webSettings.setDomStorageEnabled(true);
        webSettings.setJavaScriptEnabled(true);
        webSettings.setDefaultTextEncodingName("UTF-8");
        webSettings.setSupportZoom(true);
        webSettings.setBuiltInZoomControls(true);
        if (Build.VERSION.SDK_INT >= 11) {
            webSettings.setDisplayZoomControls(false);
        }
        webSettings.setCacheMode(2);
        webSettings.setSaveFormData(false);
        webSettings.setSavePassword(false);
    }

    public static void e(Context context) {
        cn.jpush.android.u.a.b(context, null);
    }

    public static Intent f(Context context) {
        Intent intent = null;
        try {
            PackageManager packageManager = context.getPackageManager();
            String string = context.getApplicationContext().getPackageName();
            if (TextUtils.isEmpty((CharSequence)string)) {
                Logger.ww("AndroidUtil", "The package with the given name cannot be found!");
                return null;
            }
            intent = packageManager.getLaunchIntentForPackage(string);
            if (null == intent) {
                Logger.ww("AndroidUtil", "Can't get launch intent for this package!");
                return null;
            }
            int n = 0x10000000;
            if (Build.VERSION.SDK_INT >= 11) {
                n |= 0x8000;
            }
            intent.addFlags(n);
        }
        catch (Throwable throwable) {
            Logger.w("AndroidUtil", "getLaunchIntent error:" + throwable.getMessage());
        }
        return intent;
    }

    public static void b(Context context, String string) {
        try {
            Intent intent = cn.jpush.android.u.a.f(context);
            if (intent != null) {
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    intent.putExtra("extra", string);
                }
                context.startActivity(intent);
            }
        }
        catch (Throwable throwable) {
            Logger.dd("AndroidUtil", "startMainActivity error:" + throwable.getMessage());
        }
    }

    public static String b(String string) {
        if (null == string || "".equals(string)) {
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(string.getBytes());
            return cn.jpush.android.u.a.a(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public static String a(byte[] byArray) {
        if (byArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(2 * byArray.length);
        for (byte by : byArray) {
            cn.jpush.android.u.a.a(stringBuffer, by);
        }
        return stringBuffer.toString();
    }

    private static void a(StringBuffer stringBuffer, byte by) {
        stringBuffer.append("0123456789ABCDEF".charAt(by >> 4 & 0xF)).append("0123456789ABCDEF".charAt(by & 0xF));
    }

    public static boolean c(Context context, String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(string, 0);
            if (packageInfo != null) {
                return true;
            }
        }
        finally {
            return false;
        }
        {
        }
    }

    public static void a(Context context, Intent intent, String string) {
        if (intent == null) {
            return;
        }
        String string2 = intent.getAction();
        if ("cn.jpush.android.intent.NOTIFICATION_RECEIVED".equals(string2) || "cn.jpush.android.intent.NOTIFICATION_OPENED".equals(string2)) {
            List<String> list = cn.jpush.android.u.a.b(context, intent, string);
            if (list != null && !list.isEmpty()) {
                for (String string3 : list) {
                    try {
                        Intent intent2 = (Intent)intent.clone();
                        intent2.setComponent(new ComponentName(context.getPackageName(), string3));
                        if (TextUtils.isEmpty((CharSequence)string)) {
                            context.sendBroadcast(intent2);
                            continue;
                        }
                        context.sendBroadcast(intent2, string);
                    }
                    catch (Exception exception) {
                        Logger.ww("AndroidUtil", "sendBroadcast failed again:" + exception.getMessage() + ", action:" + intent.getAction());
                    }
                }
            } else {
                Logger.ww("AndroidUtil", "sendBroadcast failed again: receiver not found, action:" + intent.getAction());
            }
        }
    }

    public static List<String> b(Context context, Intent intent, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            List list = context.getPackageManager().queryBroadcastReceivers(intent, 0);
            PackageManager packageManager = context.getPackageManager();
            for (ResolveInfo resolveInfo : list) {
                String string2;
                if (resolveInfo.activityInfo == null || TextUtils.isEmpty((CharSequence)(string2 = resolveInfo.activityInfo.name))) continue;
                boolean bl = true;
                if (!TextUtils.isEmpty((CharSequence)string) && 0 != packageManager.checkPermission(string, resolveInfo.activityInfo.packageName)) {
                    bl = false;
                }
                if (!bl) continue;
                arrayList.add(string2);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return arrayList;
    }

    public static boolean g(Context context) {
        Logger.dd("AndroidUtil", "action:checkValidManifest");
        if (!cn.jpush.android.u.a.a(context, PushActivity.class)) {
            Logger.ee("AndroidUtil", "AndroidManifest.xml missing required activity: " + PushActivity.class.getCanonicalName());
            return false;
        }
        if (!cn.jpush.android.u.a.a(context, PopWinActivity.class)) {
            Logger.ww("AndroidUtil", "AndroidManifest.xml missing activity: " + PopWinActivity.class.getCanonicalName());
            Logger.ww("AndroidUtil", "You will unable to use pop-window rich push type.");
        }
        if (!cn.jpush.android.u.a.d(context, "cn.jpush.android.ui.PushActivity")) {
            Logger.ee("AndroidUtil", "AndroidManifest.xml missing required intent filter for PushActivity: cn.jpush.android.ui.PushActivity");
            return false;
        }
        if (!cn.jpush.android.u.a.a(context, JNotifyActivity.class)) {
            Logger.ee("AndroidUtil", "AndroidManifest.xml missing required activity: " + JNotifyActivity.class.getCanonicalName());
            return false;
        }
        String string = JPushConstants.getMessageReceiverClass(context);
        if (TextUtils.isEmpty((CharSequence)string)) {
            Logger.ee("AndroidUtil", "AndroidManifest.xml missing required receiver: please custom receiver extends JPushMessageReceiver");
            return false;
        }
        return true;
    }

    public static boolean a(Context context, Class<?> clazz) {
        try {
            PackageManager packageManager = context.getPackageManager();
            Intent intent = new Intent(context, clazz);
            List list = packageManager.queryIntentActivities(intent, 0);
            return !list.isEmpty();
        }
        catch (Throwable throwable) {
            Logger.dd("AndroidUtil", "hasActivityResolves error:" + throwable.getMessage());
            return false;
        }
    }

    public static boolean d(Context context, String string) {
        try {
            PackageManager packageManager = context.getPackageManager();
            Intent intent = new Intent(string);
            intent.addCategory(context.getPackageName());
            List list = packageManager.queryIntentActivities(intent, 0);
            if (list.isEmpty()) {
                return false;
            }
        }
        catch (Throwable throwable) {
            Logger.dd("AndroidUtil", "hasActivityIntentFilter error:" + throwable.getMessage());
        }
        return true;
    }

    public static boolean h(Context context) {
        try {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                if (!runningAppProcessInfo.processName.equals(context.getPackageName()) || runningAppProcessInfo.importance != 100) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            Logger.ww("AndroidUtil", "[isAppOnForeground] error:" + throwable.getMessage());
        }
        return false;
    }

    public static int a(String string, String string2) {
        if (string.equals(string2)) {
            return 0;
        }
        try {
            String[] stringArray = string.split("[._]");
            String[] stringArray2 = string2.split("[._]");
            if (stringArray.length > stringArray2.length) {
                stringArray2 = Arrays.copyOf(stringArray2, stringArray.length);
            } else if (stringArray.length < stringArray2.length) {
                stringArray = Arrays.copyOf(stringArray, stringArray2.length);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                long l;
                long l2 = TextUtils.isEmpty((CharSequence)stringArray[i]) ? 0L : Long.parseLong(stringArray[i]);
                long l3 = l2 - (l = TextUtils.isEmpty((CharSequence)stringArray2[i]) ? 0L : Long.parseLong(stringArray2[i]));
                if (l3 > 0L) {
                    return 1;
                }
                if (l3 >= 0L) continue;
                return -1;
            }
            return 0;
        }
        catch (Throwable throwable) {
            return string.compareTo(string2);
        }
    }

    public static String e(Context context, String string) {
        return context.getPackageName() + "." + string;
    }
}

