/*
 * Decompiled with CFR 0.152.
 */
package m.framework.ui.widget.asyncview;

import android.graphics.Bitmap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.WeakHashMap;
import m.framework.network.NetworkHelper;
import m.framework.network.ResponseCallback;
import m.framework.ui.widget.asyncview.BitmapCallback;
import m.framework.utils.Data;
import m.framework.utils.Utils;

public class BitmapProcessor {
    private static final int CAPACITY = 5;
    private static final int MAX_REQ_TIME = 200;
    private static final int MAX_SIZE = 40;
    private static final int OVERFLOW_SIZE = 50;
    private static BitmapProcessor instance;
    private WeakHashMap<String, Bitmap> cacheMap;
    private boolean work;
    private Vector<ImageReq> reqList = new Vector();
    private File cacheDir;
    private WorkerThread[] workerList;
    private Vector<ImageReq> netReqTPS = new Vector();

    public static synchronized void prepare(String cacheDir) {
        if (instance == null) {
            instance = new BitmapProcessor(cacheDir);
        }
    }

    public static void start() {
        if (instance == null) {
            throw new RuntimeException("Call BitmapProcessor.prepare(String) before start");
        }
        BitmapProcessor.instance.work = true;
    }

    public static void stop() {
        if (instance != null) {
            BitmapProcessor.instance.work = false;
            BitmapProcessor.instance.reqList.clear();
            int i = 0;
            while (i < BitmapProcessor.instance.workerList.length) {
                if (BitmapProcessor.instance.workerList[i] != null) {
                    BitmapProcessor.instance.workerList[i].interrupt();
                }
                ++i;
            }
            instance = null;
        }
    }

    public static void process(String url, BitmapCallback callback) {
        if (instance == null) {
            throw new RuntimeException("Call BitmapProcessor.prepare(String) before start");
        }
        if (url == null) {
            return;
        }
        ImageReq req = new ImageReq();
        req.url = url;
        req.callback = callback;
        BitmapProcessor.instance.reqList.add(req);
        if (BitmapProcessor.instance.reqList.size() > 50) {
            while (BitmapProcessor.instance.reqList.size() > 40) {
                BitmapProcessor.instance.reqList.remove(0);
            }
        }
        BitmapProcessor.start();
    }

    public static Bitmap getBitmapFromCache(String url) {
        if (instance == null) {
            throw new RuntimeException("Call BitmapProcessor.prepare(String) before start");
        }
        return BitmapProcessor.instance.cacheMap.get(url);
    }

    private BitmapProcessor(String cacheDir) {
        this.workerList = new WorkerThread[5];
        this.cacheMap = new WeakHashMap();
        this.cacheDir = new File(cacheDir);
        if (!this.cacheDir.exists()) {
            this.cacheDir.mkdirs();
        }
        new ManagerThread(this);
    }

    public static class ImageReq {
        private String url;
        private BitmapCallback callback;
        private WorkerThread worker;
        private long reqTime = System.currentTimeMillis();
        private Bitmap image;

        private void throwComplete(Bitmap bitmap) {
            this.image = bitmap;
            if (this.callback != null) {
                this.callback.onImageGot(this.url, this.image);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("url=").append(this.url);
            sb.append("time=").append(this.reqTime);
            sb.append("worker=").append(this.worker.getName()).append(" (").append(this.worker.getId()).append("");
            return sb.toString();
        }
    }

    private static class ManagerThread
    extends Timer {
        private BitmapProcessor processor;

        public ManagerThread(BitmapProcessor bp) {
            this.processor = bp;
            TimerTask tt = new TimerTask(){
                private int counter;

                @Override
                public void run() {
                    if (ManagerThread.this.processor.work) {
                        --this.counter;
                        if (this.counter <= 0) {
                            this.counter = 100;
                            ManagerThread.this.scan();
                        }
                    }
                }
            };
            this.schedule(tt, 0L, 200L);
        }

        private void scan() {
            if (!this.processor.work) {
                return;
            }
            long curTime = System.currentTimeMillis();
            int i = 0;
            while (i < this.processor.workerList.length) {
                if (this.processor.workerList[i] == null) {
                    ((BitmapProcessor)this.processor).workerList[i] = new WorkerThread(this.processor);
                    this.processor.workerList[i].setName("worker " + i);
                    this.processor.workerList[i].localType = i == 0;
                    this.processor.workerList[i].start();
                } else {
                    long curCost = curTime - this.processor.workerList[i].lastReport;
                    if (curCost > 20000L) {
                        this.processor.workerList[i].interrupt();
                        boolean localType = this.processor.workerList[i].localType;
                        ((BitmapProcessor)this.processor).workerList[i] = new WorkerThread(this.processor);
                        this.processor.workerList[i].setName("worker " + i);
                        this.processor.workerList[i].localType = localType;
                        this.processor.workerList[i].start();
                    }
                }
                ++i;
            }
        }
    }

    private static class PatchInputStream
    extends FilterInputStream {
        InputStream in;

        protected PatchInputStream(InputStream in) {
            super(in);
            this.in = in;
        }

        @Override
        public long skip(long n) throws IOException {
            long m = 0L;
            while (m < n) {
                long _m = this.in.skip(n - m);
                if (_m == 0L) break;
                m += _m;
            }
            return m;
        }
    }

    private static class WorkerThread
    extends Thread {
        private BitmapProcessor processor;
        private long lastReport;
        private boolean localType;
        private ImageReq curReq;

        public WorkerThread(BitmapProcessor bp) {
            this.processor = bp;
            this.lastReport = System.currentTimeMillis();
        }

        @Override
        public void run() {
            while (this.processor.work) {
                try {
                    if (this.localType) {
                        this.doLocalTask();
                        continue;
                    }
                    this.doNetworkTask();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }

        private void doLocalTask() throws Throwable {
            ImageReq req = null;
            int size = this.processor.reqList.size();
            if (size > 0) {
                req = (ImageReq)this.processor.reqList.remove(size - 1);
            }
            if (req != null) {
                Bitmap bm = (Bitmap)this.processor.cacheMap.get(req.url);
                if (bm != null) {
                    this.curReq = req;
                    this.curReq.worker = this;
                    req.throwComplete(bm);
                } else {
                    File file = new File(this.processor.cacheDir, Data.MD5(req.url));
                    if (file.exists()) {
                        this.doTask(req);
                        this.lastReport = System.currentTimeMillis();
                        return;
                    }
                    if (this.processor.netReqTPS.size() > 40) {
                        while (this.processor.reqList.size() > 0) {
                            this.processor.reqList.remove(0);
                        }
                        this.processor.netReqTPS.remove(0);
                    }
                    this.processor.netReqTPS.add(req);
                }
                this.lastReport = System.currentTimeMillis();
            } else {
                this.lastReport = System.currentTimeMillis();
                Thread.sleep(30L);
            }
        }

        private void doNetworkTask() throws Throwable {
            ImageReq req = null;
            int size = this.processor.netReqTPS.size();
            if (size > 0) {
                req = (ImageReq)this.processor.netReqTPS.remove(0);
            }
            if (req == null && (size = this.processor.reqList.size()) > 0) {
                req = (ImageReq)this.processor.reqList.remove(size - 1);
            }
            if (req != null) {
                Bitmap bm = (Bitmap)this.processor.cacheMap.get(req.url);
                if (bm != null) {
                    this.curReq = req;
                    this.curReq.worker = this;
                    req.throwComplete(bm);
                } else {
                    this.doTask(req);
                }
                this.lastReport = System.currentTimeMillis();
            } else {
                this.lastReport = System.currentTimeMillis();
                Thread.sleep(30L);
            }
        }

        private void doTask(final ImageReq req) throws Throwable {
            this.curReq = req;
            this.curReq.worker = this;
            Bitmap bm = null;
            final File file = new File(this.processor.cacheDir, Data.MD5(req.url));
            if (file.exists()) {
                bm = Utils.getBitmap(file.getAbsolutePath());
                if (bm != null) {
                    this.processor.cacheMap.put(req.url, bm);
                    req.throwComplete(bm);
                }
                this.curReq = null;
            } else {
                NetworkHelper helper = new NetworkHelper();
                helper.download(req.url, new ResponseCallback(){

                    @Override
                    public void onResponse(InputStream is) {
                        PatchInputStream pis = new PatchInputStream(is);
                        Bitmap bitmap = Utils.getBitmap(pis);
                        if (bitmap == null || bitmap.isRecycled()) {
                            WorkerThread.this.curReq = null;
                            return;
                        }
                        WorkerThread.this.saveFile(bitmap, file);
                        if (bitmap != null) {
                            WorkerThread.this.processor.cacheMap.put(req.url, bitmap);
                            req.throwComplete(bitmap);
                        }
                        WorkerThread.this.curReq = null;
                    }
                });
            }
            if (bm != null) {
                this.processor.cacheMap.put(req.url, bm);
                req.throwComplete(bm);
            }
            this.curReq = null;
        }

        private void saveFile(Bitmap bitmap, File file) {
            block5: {
                try {
                    if (file.exists()) {
                        file.delete();
                    }
                    if (!file.getParentFile().exists()) {
                        file.getParentFile().mkdirs();
                    }
                    file.createNewFile();
                    Bitmap.CompressFormat type = Bitmap.CompressFormat.JPEG;
                    String mime = Utils.getFileMime(file.getAbsolutePath());
                    if (mime != null && (mime.endsWith("png") || mime.endsWith("gif"))) {
                        type = Bitmap.CompressFormat.PNG;
                    }
                    FileOutputStream fos = new FileOutputStream(file);
                    bitmap.compress(type, 100, (OutputStream)fos);
                    fos.flush();
                    fos.close();
                }
                catch (Throwable t) {
                    if (!file.exists()) break block5;
                    file.delete();
                }
            }
        }

        @Override
        public void interrupt() {
            try {
                super.interrupt();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

