/*
 * Decompiled with CFR 0.152.
 */
package m.framework.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Hashon {
    public HashMap<String, Object> fromJson(String jsonStr) {
        try {
            if (jsonStr.startsWith("[") && jsonStr.endsWith("]")) {
                jsonStr = "{\"fakelist\":" + jsonStr + "}";
            }
            JSONObject json = new JSONObject(jsonStr);
            return this.fromJson(json);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return new HashMap<String, Object>();
        }
    }

    private HashMap<String, Object> fromJson(JSONObject json) throws JSONException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator iKey = json.keys();
        while (iKey.hasNext()) {
            String key = (String)iKey.next();
            Cloneable value = json.opt(key);
            if (JSONObject.NULL.equals(value)) {
                value = null;
            }
            if (value == null) continue;
            if (value instanceof JSONObject) {
                value = this.fromJson((JSONObject)value);
            } else if (value instanceof JSONArray) {
                value = this.fromJson((JSONArray)value);
            }
            map.put(key, value);
        }
        return map;
    }

    private ArrayList<Object> fromJson(JSONArray array) throws JSONException {
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        int size = array.length();
        while (i < size) {
            Cloneable value = array.opt(i);
            if (value instanceof JSONObject) {
                value = this.fromJson((JSONObject)value);
            } else if (value instanceof JSONArray) {
                value = this.fromJson((JSONArray)value);
            }
            list.add(value);
            ++i;
        }
        return list;
    }

    public String fromHashMap(HashMap<String, Object> map) {
        try {
            return this.getJSONObject(map).toString();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return "";
        }
    }

    private JSONObject getJSONObject(HashMap<String, Object> map) throws JSONException {
        JSONObject json = new JSONObject();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof HashMap) {
                value = this.getJSONObject((HashMap)value);
            } else if (value instanceof ArrayList) {
                value = this.getJSONArray((ArrayList)value);
            } else if (this.isBasicArray(value)) {
                value = this.getJSONArray(this.arrayToList(value));
            }
            json.put(entry.getKey(), value);
        }
        return json;
    }

    private boolean isBasicArray(Object value) {
        return value instanceof byte[] || value instanceof short[] || value instanceof int[] || value instanceof long[] || value instanceof float[] || value instanceof double[] || value instanceof char[] || value instanceof boolean[] || value instanceof String[];
    }

    private ArrayList<?> arrayToList(Object value) {
        if (value instanceof byte[]) {
            ArrayList<Byte> list = new ArrayList<Byte>();
            byte[] byArray = (byte[])value;
            int n = byArray.length;
            int n2 = 0;
            while (n2 < n) {
                byte item = byArray[n2];
                list.add(item);
                ++n2;
            }
            return list;
        }
        if (value instanceof short[]) {
            ArrayList<Short> list = new ArrayList<Short>();
            short[] sArray = (short[])value;
            int n = sArray.length;
            int n3 = 0;
            while (n3 < n) {
                short item = sArray[n3];
                list.add(item);
                ++n3;
            }
            return list;
        }
        if (value instanceof int[]) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            int[] nArray = (int[])value;
            int n = nArray.length;
            int n4 = 0;
            while (n4 < n) {
                int item = nArray[n4];
                list.add(item);
                ++n4;
            }
            return list;
        }
        if (value instanceof long[]) {
            ArrayList<Long> list = new ArrayList<Long>();
            long[] lArray = (long[])value;
            int n = lArray.length;
            int n5 = 0;
            while (n5 < n) {
                long item = lArray[n5];
                list.add(item);
                ++n5;
            }
            return list;
        }
        if (value instanceof float[]) {
            ArrayList<Float> list = new ArrayList<Float>();
            float[] fArray = (float[])value;
            int n = fArray.length;
            int n6 = 0;
            while (n6 < n) {
                float item = fArray[n6];
                list.add(Float.valueOf(item));
                ++n6;
            }
            return list;
        }
        if (value instanceof double[]) {
            ArrayList<Double> list = new ArrayList<Double>();
            double[] dArray = (double[])value;
            int n = dArray.length;
            int n7 = 0;
            while (n7 < n) {
                double item = dArray[n7];
                list.add(item);
                ++n7;
            }
            return list;
        }
        if (value instanceof char[]) {
            ArrayList<Character> list = new ArrayList<Character>();
            char[] cArray = (char[])value;
            int n = cArray.length;
            int n8 = 0;
            while (n8 < n) {
                char item = cArray[n8];
                list.add(Character.valueOf(item));
                ++n8;
            }
            return list;
        }
        if (value instanceof boolean[]) {
            ArrayList<Boolean> list = new ArrayList<Boolean>();
            boolean[] blArray = (boolean[])value;
            int n = blArray.length;
            int n9 = 0;
            while (n9 < n) {
                boolean item = blArray[n9];
                list.add(item);
                ++n9;
            }
            return list;
        }
        if (value instanceof String[]) {
            ArrayList<String> list = new ArrayList<String>();
            String[] stringArray = (String[])value;
            int n = stringArray.length;
            int n10 = 0;
            while (n10 < n) {
                String item = stringArray[n10];
                list.add(item);
                ++n10;
            }
            return list;
        }
        return null;
    }

    private JSONArray getJSONArray(ArrayList<Object> list) throws JSONException {
        JSONArray array = new JSONArray();
        for (Object value : list) {
            if (value instanceof HashMap) {
                value = this.getJSONObject((HashMap)value);
            } else if (value instanceof ArrayList) {
                value = this.getJSONArray((ArrayList)value);
            }
            array.put(value);
        }
        return array;
    }

    public String format(String jsonStr) {
        try {
            return this.format("", this.fromJson(jsonStr));
        }
        catch (Throwable t) {
            t.printStackTrace();
            return "";
        }
    }

    private String format(String sepStr, HashMap<String, Object> map) {
        StringBuffer sb = new StringBuffer();
        sb.append("{\n");
        String mySepStr = String.valueOf(sepStr) + "\t";
        int i = 0;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (i > 0) {
                sb.append(",\n");
            }
            sb.append(mySepStr).append('\"').append(entry.getKey()).append("\":");
            Object value = entry.getValue();
            if (value instanceof HashMap) {
                sb.append(this.format(mySepStr, (HashMap)value));
            } else if (value instanceof ArrayList) {
                sb.append(this.format(mySepStr, (ArrayList)value));
            } else if (value instanceof String) {
                sb.append('\"').append(value).append('\"');
            } else {
                sb.append(value);
            }
            ++i;
        }
        sb.append('\n').append(sepStr).append('}');
        return sb.toString();
    }

    private String format(String sepStr, ArrayList<Object> list) {
        StringBuffer sb = new StringBuffer();
        sb.append("[\n");
        String mySepStr = String.valueOf(sepStr) + "\t";
        int i = 0;
        for (Object value : list) {
            if (i > 0) {
                sb.append(",\n");
            }
            sb.append(mySepStr);
            if (value instanceof HashMap) {
                sb.append(this.format(mySepStr, (HashMap)value));
            } else if (value instanceof ArrayList) {
                sb.append(this.format(mySepStr, (ArrayList)value));
            } else if (value instanceof String) {
                sb.append('\"').append(value).append('\"');
            } else {
                sb.append(value);
            }
            ++i;
        }
        sb.append('\n').append(sepStr).append(']');
        return sb.toString();
    }
}

