/*
 * Decompiled with CFR 0.152.
 */
package m.framework.ui.widget.asyncview;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.widget.ImageView;
import java.util.Random;
import m.framework.ui.widget.asyncview.AsyncView;
import m.framework.ui.widget.asyncview.BitmapCallback;
import m.framework.ui.widget.asyncview.BitmapProcessor;
import m.framework.ui.widget.asyncview.OnImageGotListener;
import m.framework.ui.widget.asyncview.SimpleOnImageGotListener;
import m.framework.utils.UIHandler;
import m.framework.utils.Utils;

public class AsyncImageView
extends ImageView
implements AsyncView,
BitmapCallback,
Handler.Callback {
    public static final int DEFAULT_TRANSPARENT = 17170445;
    private static Bitmap DEFAULT_TRANSPARENT_BITMAP;
    private static final int MSG_IMG_GOT = 1;
    private static final Random rnd;
    private static String cacheDir;
    private String url;
    private int defaultRes;
    private OnImageGotListener onImageGotListener;

    static {
        rnd = new Random();
    }

    public AsyncImageView(Context context) {
        super(context);
        this.init(context);
    }

    public AsyncImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public AsyncImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    private void init(Context context) {
        UIHandler.prepare();
        if (TextUtils.isEmpty((CharSequence)cacheDir)) {
            cacheDir = Utils.getCachePath(this.getContext(), "images");
        }
        BitmapProcessor.prepare(cacheDir);
        this.setOnImageGotListener(SimpleOnImageGotListener.INSTANCE);
    }

    public void setOnImageGotListener(OnImageGotListener l) {
        this.onImageGotListener = l;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    public void execute(String url) {
        this.execute(url, 0);
    }

    @Override
    public void execute(String url, int defaultRes) {
        this.url = url;
        this.defaultRes = defaultRes;
        if (Utils.isNullOrEmpty(url)) {
            this.setImageResource(defaultRes);
            return;
        }
        Bitmap bm = BitmapProcessor.getBitmapFromCache(url);
        if (bm != null && !bm.isRecycled()) {
            this.setImageBitmap(bm);
            return;
        }
        if (defaultRes > 0) {
            this.setImageBitmap(this.getDefaultBitmap(defaultRes));
        }
        BitmapProcessor.process(url, this);
    }

    private Bitmap getDefaultBitmap(int defaultRes) {
        switch (defaultRes) {
            case 17170445: {
                if (DEFAULT_TRANSPARENT_BITMAP == null) {
                    DEFAULT_TRANSPARENT_BITMAP = BitmapFactory.decodeResource((Resources)this.getResources(), (int)17170445);
                }
                return DEFAULT_TRANSPARENT_BITMAP;
            }
        }
        return BitmapFactory.decodeResource((Resources)this.getResources(), (int)defaultRes);
    }

    @Override
    public void onImageGot(String url, Bitmap bm) {
        Bitmap shownImage = bm;
        if (this.onImageGotListener != null) {
            shownImage = this.onImageGotListener.onImageGot(this, shownImage, url);
        }
        Message msg = new Message();
        msg.what = 1;
        msg.obj = new Object[]{url, shownImage};
        int delay = rnd.nextInt(300);
        UIHandler.sendMessageDelayed(msg, delay, this);
    }

    public boolean handleMessage(Message msg) {
        if (msg.what == 1) {
            Object url = ((Object[])msg.obj)[0];
            Object bm = ((Object[])msg.obj)[1];
            if (bm != null && url != null && url.equals(this.url)) {
                this.setImageBitmap((Bitmap)bm);
            } else {
                this.setImageResource(this.defaultRes);
            }
        }
        return false;
    }
}

