/*
 * Decompiled with CFR 0.152.
 */
package m.framework.utils;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Proxy;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Base64;
import android.util.DisplayMetrics;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import m.framework.utils.Data;
import org.json.JSONArray;
import org.json.JSONException;

public class DeviceHelper {
    private Context context;
    private static DeviceHelper deviceHelper;

    public DeviceHelper(Context context) {
        this.context = context.getApplicationContext();
    }

    public static DeviceHelper getInstance(Context c) {
        if (deviceHelper == null) {
            deviceHelper = new DeviceHelper(c);
        }
        return deviceHelper;
    }

    public boolean isRooted() {
        return false;
    }

    public String getMacAddress() {
        WifiManager wifi = (WifiManager)this.context.getSystemService("wifi");
        if (wifi == null) {
            return null;
        }
        WifiInfo info = wifi.getConnectionInfo();
        if (info != null) {
            String mac = info.getMacAddress();
            return mac == null ? null : mac;
        }
        return null;
    }

    public String getModel() {
        return Build.MODEL;
    }

    public String getFactory() {
        return Build.MANUFACTURER;
    }

    public String getDeviceId() {
        TelephonyManager phone = (TelephonyManager)this.context.getSystemService("phone");
        if (phone == null) {
            return null;
        }
        String deviceId = phone.getDeviceId();
        String backId = "";
        if (deviceId != null) {
            backId = new String(deviceId);
            backId = backId.replace("0", "");
        }
        if ((deviceId == null || backId.length() <= 0) && Build.VERSION.SDK_INT >= 9) {
            try {
                Class<?> c = Class.forName("android.os.SystemProperties");
                Method get = c.getMethod("get", String.class, String.class);
                deviceId = (String)get.invoke(c, "ro.serialno", "unknown");
            }
            catch (Throwable t) {
                t.printStackTrace();
                deviceId = null;
            }
        }
        return deviceId;
    }

    public String getDeviceData() {
        String data = String.valueOf(this.getModel()) + "|" + this.getOSVersion() + "|" + this.getFactory() + "|" + this.getCarrier() + "|" + this.getScreenSize();
        String deviString = this.getDeviceKey();
        return this.Base64AES(data, deviString.substring(0, 16));
    }

    public String Base64AES(String msg, String key) {
        String result = null;
        try {
            result = Base64.encodeToString((byte[])Data.AES128Encode(key, msg), (int)0);
            if (result.contains("\n")) {
                result = result.replace("\n", "");
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return result;
    }

    public String getOSVersion() {
        return String.valueOf(Build.VERSION.SDK_INT);
    }

    public String getScreenSize() {
        DisplayMetrics dm2 = this.context.getResources().getDisplayMetrics();
        if (this.context.getResources().getConfiguration().orientation == 1) {
            return String.valueOf(dm2.widthPixels) + "x" + dm2.heightPixels;
        }
        return String.valueOf(dm2.heightPixels) + "x" + dm2.widthPixels;
    }

    public String getCarrier() {
        TelephonyManager telephonyManager = (TelephonyManager)this.context.getSystemService("phone");
        String operator = telephonyManager.getSimOperator();
        if (TextUtils.isEmpty((CharSequence)operator)) {
            operator = "-1";
        }
        return operator;
    }

    public String getNetworkType() {
        ConnectivityManager conn = (ConnectivityManager)this.context.getSystemService("connectivity");
        if (conn == null) {
            return null;
        }
        NetworkInfo network = conn.getActiveNetworkInfo();
        if (network == null || !network.isAvailable()) {
            return null;
        }
        int type = network.getType();
        if (1 == type) {
            return "wifi";
        }
        if (type == 0) {
            String proxy = Proxy.getDefaultHost();
            String wap = "";
            if (proxy != null && proxy.length() > 0) {
                wap = " wap";
            }
            return String.valueOf(this.isFastMobileNetwork() ? "3G" : "2G") + wap;
        }
        return null;
    }

    public int getPlatformCode() {
        return 1;
    }

    private boolean isFastMobileNetwork() {
        TelephonyManager phone = (TelephonyManager)this.context.getSystemService("phone");
        if (phone == null) {
            return false;
        }
        switch (phone.getNetworkType()) {
            case 7: {
                return false;
            }
            case 4: {
                return false;
            }
            case 2: {
                return false;
            }
            case 5: {
                return true;
            }
            case 6: {
                return true;
            }
            case 1: {
                return false;
            }
            case 8: {
                return true;
            }
            case 10: {
                return true;
            }
            case 9: {
                return true;
            }
            case 3: {
                return true;
            }
            case 14: {
                return true;
            }
            case 12: {
                return true;
            }
            case 15: {
                return true;
            }
            case 11: {
                return false;
            }
            case 13: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        return false;
    }

    public JSONArray getRunningApp() {
        JSONArray appNmes = new JSONArray();
        ActivityManager am = (ActivityManager)this.context.getSystemService("activity");
        if (am == null) {
            return appNmes;
        }
        List apps = am.getRunningAppProcesses();
        if (apps == null) {
            return appNmes;
        }
        for (ActivityManager.RunningAppProcessInfo app : apps) {
            appNmes.put((Object)app.processName);
        }
        return appNmes;
    }

    public String getRunningAppStr() throws JSONException {
        JSONArray apps = this.getRunningApp();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < apps.length()) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(String.valueOf(apps.get(i)));
            ++i;
        }
        return sb.toString();
    }

    public String getDeviceKey() {
        try {
            String mac = this.getMacAddress();
            String udid = this.getDeviceId();
            String model = this.getModel();
            String data = String.valueOf(mac) + ":" + udid + ":" + model;
            byte[] bytes = Data.SHA1(data);
            return Data.byteToHex(bytes);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public String getPackageName() {
        return this.context.getPackageName();
    }

    public String getAppName() {
        String appName = this.context.getApplicationInfo().name;
        if (appName != null) {
            return appName;
        }
        int appLbl = this.context.getApplicationInfo().labelRes;
        if (appLbl > 0) {
            appName = this.context.getString(appLbl);
        }
        return appName;
    }

    public int getAppVersion() {
        try {
            PackageManager pm = this.context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(this.context.getPackageName(), 0);
            return pi.versionCode;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return 0;
        }
    }

    public String getAppVersionName() {
        try {
            PackageManager pm = this.context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(this.context.getPackageName(), 0);
            return pi.versionName;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return "1.0";
        }
    }

    public ArrayList<HashMap<String, String>> getInstalledApp(boolean includeSystemApp) {
        ArrayList<HashMap<String, String>> apps = new ArrayList<HashMap<String, String>>();
        try {
            PackageManager pm = this.context.getPackageManager();
            List pis = pm.getInstalledPackages(0);
            for (PackageInfo pi : pis) {
                if (!includeSystemApp && this.isSystemApp(pi)) continue;
                HashMap<String, String> app = new HashMap<String, String>();
                app.put("pkg", pi.packageName);
                app.put("name", pi.applicationInfo.loadLabel(pm).toString());
                app.put("version", pi.versionName);
                apps.add(app);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return apps;
    }

    private boolean isSystemApp(PackageInfo pi) {
        boolean isSysUpd;
        boolean isSysApp = (pi.applicationInfo.flags & 1) == 1;
        boolean bl = isSysUpd = (pi.applicationInfo.flags & 0x80) == 1;
        return isSysApp || isSysUpd;
    }

    public String getNetworkOperator() {
        TelephonyManager telephonyManager = (TelephonyManager)this.context.getSystemService("phone");
        String operator = telephonyManager.getNetworkOperator();
        return operator;
    }

    public String getTopTaskPackageName() {
        try {
            ActivityManager am = (ActivityManager)this.context.getSystemService("activity");
            ActivityManager.RunningTaskInfo task = (ActivityManager.RunningTaskInfo)am.getRunningTasks(1).get(0);
            return task.topActivity.getPackageName();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public boolean getSdcardState() {
        return "mounted".equals(Environment.getExternalStorageState());
    }

    public String getSdcardPath() {
        return Environment.getExternalStorageDirectory().getAbsolutePath();
    }
}

