/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.gui;

import com.coremedia.iso.IsoFile;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.TrackBox;
import com.coremedia.iso.boxes.mdat.SampleList;
import com.coremedia.iso.gui.BoxJTree;
import com.coremedia.iso.gui.GenericBoxPane;
import com.coremedia.iso.gui.IsoFileTreeModel;
import com.coremedia.iso.gui.SampleListModel;
import com.coremedia.iso.gui.SampleListRenderer;
import com.coremedia.iso.gui.TrackListModel;
import com.coremedia.iso.gui.TrackListRenderer;
import com.coremedia.iso.gui.hex.JHexEditor;
import com.googlecode.mp4parser.BasicContainer;
import com.googlecode.mp4parser.FileDataSourceImpl;
import com.googlecode.mp4parser.util.ByteBufferByteChannel;
import com.googlecode.mp4parser.util.CastUtils;
import com.googlecode.mp4parser.util.Path;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.LinkedList;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.jdesktop.application.Action;
import org.jdesktop.application.Resource;
import org.jdesktop.application.session.PropertySupport;

public class IsoViewerPanel
extends JPanel
implements PropertySupport {
    private JTree tree;
    private JList trackList;
    private JPanel detailPanel;
    private JSplitPane rawDataSplitPane;
    @Resource
    private String trackViewDetailPaneHeader = "T %s";
    @Resource
    private String tabbedPaneHeaderTrack = "T&S";
    @Resource
    private String tabbedPaneHeaderBox = "BS";
    private Object details;
    private Frame mainFrame;
    private File file;
    JFileChooser fileChooser = new JFileChooser();

    public IsoViewerPanel(Frame mainFrame) {
        this.mainFrame = mainFrame;
        this.setName("IsoViewerPanel");
    }

    public void createLayout() {
        BasicContainer dummy = new BasicContainer();
        this.tree = new BoxJTree();
        this.tree.setModel(new IsoFileTreeModel(dummy));
        this.tree.setLargeModel(true);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                Box node = (Box)e.getPath().getLastPathComponent();
                IsoViewerPanel.this.showDetails(node);
            }
        });
        this.detailPanel = new JPanel();
        this.detailPanel.setLayout(new BorderLayout());
        this.detailPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.rawDataSplitPane = new JSplitPane(0);
        this.rawDataSplitPane.setName("rawDataSplitPane");
        this.rawDataSplitPane.setBorder(null);
        this.rawDataSplitPane.setOneTouchExpandable(true);
        JScrollPane scrollPane = new JScrollPane(this.detailPanel);
        scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.rawDataSplitPane.setTopComponent(scrollPane);
        this.rawDataSplitPane.setBottomComponent(new JHexEditor(ByteBuffer.allocate(0)));
        this.rawDataSplitPane.setResizeWeight(0.8);
        JSplitPane splitPane = new JSplitPane();
        splitPane.setOrientation(1);
        splitPane.setOneTouchExpandable(true);
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setName("tracksOrBoxes");
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        jScrollPane.setName("boxTreeScrollPane");
        jTabbedPane.add(this.tabbedPaneHeaderBox, jScrollPane);
        jTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int index = ((JTabbedPane)e.getSource()).getSelectedIndex();
                if (index == 0) {
                    Object selected;
                    if (IsoViewerPanel.this.tree.getSelectionPath() != null && (selected = IsoViewerPanel.this.tree.getSelectionPath().getLastPathComponent()) != null) {
                        IsoViewerPanel.this.showDetails(selected);
                    }
                } else if (index == 1) {
                    IsoViewerPanel.this.showSamples(IsoViewerPanel.this.trackList.getSelectedValue());
                }
            }
        });
        this.trackList = new JList();
        this.trackList.setCellRenderer(new TrackListRenderer());
        this.trackList.setSelectionMode(0);
        this.trackList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                Object selectedValue = ((JList)e.getSource()).getSelectedValue();
                IsoViewerPanel.this.showSamples(selectedValue);
            }
        });
        jTabbedPane.add(this.tabbedPaneHeaderTrack, this.trackList);
        splitPane.setLeftComponent(jTabbedPane);
        splitPane.setRightComponent(this.rawDataSplitPane);
        splitPane.setResizeWeight(0.6);
        splitPane.setName("treeLeftdataRight");
        this.setLayout(new BorderLayout());
        this.add((Component)splitPane, "Center");
    }

    private void showSamples(Object selectedValue) {
        if (selectedValue != null && selectedValue instanceof TrackBox) {
            TrackBox trackBox = (TrackBox)selectedValue;
            SampleDescriptionBox sampleDescriptionBox = trackBox.getMediaBox().getMediaInformationBox().getSampleTableBox().getSampleDescriptionBox();
            this.showSamples(new SampleListModel(new SampleList(trackBox, new IsoFile[0]), trackBox.getTrackHeaderBox().getTrackId(), sampleDescriptionBox.getSampleEntry(), null));
        }
    }

    private void showSamples(SampleListModel sampleListModel) {
        this.detailPanel.removeAll();
        JPanel detailPane = new JPanel(new BorderLayout());
        JList<Object> jlist = new JList<Object>();
        jlist.setCellRenderer(new SampleListRenderer());
        jlist.setModel(sampleListModel);
        jlist.setLayoutOrientation(0);
        jlist.setSelectionMode(0);
        jlist.setPrototypeCellValue(new SampleListModel.Entry(ByteBuffer.allocate(1000), 0L, null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(jlist);
        detailPane.add((Component)new JLabel(String.format(this.trackViewDetailPaneHeader, sampleListModel.getTrackId())), "First");
        detailPane.add((Component)jScrollPane, "Center");
        jlist.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ByteBuffer sample = ((SampleListModel.Entry)((JList)e.getSource()).getSelectedValue()).sample;
                    IsoViewerPanel.this.rawDataSplitPane.setBottomComponent(new JHexEditor(sample.slice()));
                }
            }
        });
        this.detailPanel.add(detailPane);
        this.detailPanel.revalidate();
    }

    public void open(File f) throws IOException {
        this.file = f;
        IsoFile isoFile = new IsoFile(new FileDataSourceImpl(f));
        long start = System.nanoTime();
        final LinkedList messages = new LinkedList();
        Handler myTemperaryLogHandler = new Handler(){

            public void publish(LogRecord record) {
                messages.add(record);
            }

            public void flush() {
            }

            public void close() throws SecurityException {
            }
        };
        Logger.getLogger("").addHandler(myTemperaryLogHandler);
        Logger.getAnonymousLogger().removeHandler(myTemperaryLogHandler);
        System.err.println("Parsing took " + (double)(System.nanoTime() - start) / 1000000.0 + "ms.");
        this.tree.setLargeModel(true);
        this.tree.setModel(new IsoFileTreeModel(isoFile));
        this.tree.revalidate();
        this.trackList.setModel(new TrackListModel(isoFile));
        if (!messages.isEmpty()) {
            String message = "";
            for (LogRecord logRecord : messages) {
                message = message + logRecord.getMessage() + "\n";
            }
            JOptionPane.showMessageDialog(this, message, "Parser Messages", 2);
        }
        if (this.details instanceof Box) {
            String path = Path.createPath((Box)this.details);
            Box nuDetail = Path.getPath(isoFile, path);
            if (nuDetail != null) {
                this.showDetails(nuDetail);
            } else {
                this.showDetails(isoFile);
            }
        } else {
            this.showDetails(isoFile);
        }
        this.mainFrame.setTitle("Iso Viewer - " + f.getAbsolutePath());
    }

    @Action(name="open-iso-file")
    public void open() {
        int state = this.fileChooser.showOpenDialog(this);
        if (state == 0) {
            try {
                this.open(this.fileChooser.getSelectedFile());
            }
            catch (IOException e) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(baos);
                e.printStackTrace(ps);
                JOptionPane.showMessageDialog(this, new String(baos.toByteArray()), "e.getMessage()", 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showDetails(Object object) {
        this.details = object;
        Cursor oldCursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            ByteBuffer displayMe;
            JPanel detailPane = new JPanel();
            if (object instanceof Box) {
                detailPane = new GenericBoxPane((Box)object);
            }
            this.detailPanel.removeAll();
            this.detailPanel.add((Component)detailPane, "Center");
            this.detailPanel.revalidate();
            if (object instanceof Box && !(object instanceof IsoFile)) {
                displayMe = ByteBuffer.allocate(CastUtils.l2i(((Box)object).getSize()));
                try {
                    ((Box)object).getBox(new ByteBufferByteChannel(displayMe));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else if (object instanceof IsoFile) {
                FileChannel fc = new FileInputStream(this.file).getChannel();
                displayMe = fc.map(FileChannel.MapMode.READ_ONLY, 0L, Math.min(this.file.length(), 0x100000L));
                fc.close();
            } else {
                displayMe = ByteBuffer.allocate(0);
            }
            this.rawDataSplitPane.setBottomComponent(new JHexEditor(displayMe));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.setCursor(oldCursor);
        }
    }

    public Object getSessionState(Component c) {
        return this.file.getAbsolutePath();
    }

    public void setSessionState(Component c, Object state) {
        try {
            this.open(new File(state.toString()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

