/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.tracks;

import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.CompositionTimeToSample;
import com.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.SubSampleInformationBox;
import com.coremedia.iso.boxes.TimeToSampleBox;
import com.googlecode.mp4parser.authoring.AbstractTrack;
import com.googlecode.mp4parser.authoring.Sample;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.TrackMetaData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CroppedTrack
extends AbstractTrack {
    Track origTrack;
    private int fromSample;
    private int toSample;
    private long[] syncSampleArray;

    public CroppedTrack(Track origTrack, long fromSample, long toSample) {
        this.origTrack = origTrack;
        assert (fromSample <= Integer.MAX_VALUE);
        assert (toSample <= Integer.MAX_VALUE);
        this.fromSample = (int)fromSample;
        this.toSample = (int)toSample;
    }

    @Override
    public List<Sample> getSamples() {
        return this.origTrack.getSamples().subList(this.fromSample, this.toSample);
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        return this.origTrack.getSampleDescriptionBox();
    }

    @Override
    public List<TimeToSampleBox.Entry> getDecodingTimeEntries() {
        return CroppedTrack.getDecodingTimeEntries(this.origTrack.getDecodingTimeEntries(), this.fromSample, this.toSample);
    }

    static List<TimeToSampleBox.Entry> getDecodingTimeEntries(List<TimeToSampleBox.Entry> origSamples, long fromSample, long toSample) {
        if (origSamples != null && !origSamples.isEmpty()) {
            TimeToSampleBox.Entry currentEntry;
            long current = 0L;
            ListIterator<TimeToSampleBox.Entry> e = origSamples.listIterator();
            LinkedList<TimeToSampleBox.Entry> nuList = new LinkedList<TimeToSampleBox.Entry>();
            while ((currentEntry = e.next()).getCount() + current <= fromSample) {
                current += currentEntry.getCount();
            }
            if (currentEntry.getCount() + current >= toSample) {
                nuList.add(new TimeToSampleBox.Entry(toSample - fromSample, currentEntry.getDelta()));
                return nuList;
            }
            nuList.add(new TimeToSampleBox.Entry(currentEntry.getCount() + current - fromSample, currentEntry.getDelta()));
            current += currentEntry.getCount();
            while (e.hasNext() && (currentEntry = e.next()).getCount() + current < toSample) {
                nuList.add(currentEntry);
                current += currentEntry.getCount();
            }
            nuList.add(new TimeToSampleBox.Entry(toSample - current, currentEntry.getDelta()));
            return nuList;
        }
        return null;
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        return CroppedTrack.getCompositionTimeEntries(this.origTrack.getCompositionTimeEntries(), this.fromSample, this.toSample);
    }

    static List<CompositionTimeToSample.Entry> getCompositionTimeEntries(List<CompositionTimeToSample.Entry> origSamples, long fromSample, long toSample) {
        if (origSamples != null && !origSamples.isEmpty()) {
            CompositionTimeToSample.Entry currentEntry;
            long current = 0L;
            ListIterator<CompositionTimeToSample.Entry> e = origSamples.listIterator();
            ArrayList<CompositionTimeToSample.Entry> nuList = new ArrayList<CompositionTimeToSample.Entry>();
            while ((long)(currentEntry = e.next()).getCount() + current <= fromSample) {
                current += (long)currentEntry.getCount();
            }
            if ((long)currentEntry.getCount() + current >= toSample) {
                nuList.add(new CompositionTimeToSample.Entry((int)(toSample - fromSample), currentEntry.getOffset()));
                return nuList;
            }
            nuList.add(new CompositionTimeToSample.Entry((int)((long)currentEntry.getCount() + current - fromSample), currentEntry.getOffset()));
            current += (long)currentEntry.getCount();
            while (e.hasNext() && (long)(currentEntry = e.next()).getCount() + current < toSample) {
                nuList.add(currentEntry);
                current += (long)currentEntry.getCount();
            }
            nuList.add(new CompositionTimeToSample.Entry((int)(toSample - current), currentEntry.getOffset()));
            return nuList;
        }
        return null;
    }

    @Override
    public synchronized long[] getSyncSamples() {
        if (this.origTrack.getSyncSamples() != null) {
            long[] origSyncSamples = this.origTrack.getSyncSamples();
            int i = 0;
            int j = origSyncSamples.length;
            while (i < origSyncSamples.length && origSyncSamples[i] < (long)this.fromSample) {
                ++i;
            }
            while (j > 0 && (long)this.toSample < origSyncSamples[j - 1]) {
                --j;
            }
            this.syncSampleArray = Arrays.copyOfRange(this.origTrack.getSyncSamples(), i, j);
            int k = 0;
            while (k < this.syncSampleArray.length) {
                int n = k++;
                this.syncSampleArray[n] = this.syncSampleArray[n] - (long)this.fromSample;
            }
            return this.syncSampleArray;
        }
        return null;
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        if (this.origTrack.getSampleDependencies() != null && !this.origTrack.getSampleDependencies().isEmpty()) {
            return this.origTrack.getSampleDependencies().subList(this.fromSample, this.toSample);
        }
        return null;
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.origTrack.getTrackMetaData();
    }

    @Override
    public String getHandler() {
        return this.origTrack.getHandler();
    }

    @Override
    public Box getMediaHeaderBox() {
        return this.origTrack.getMediaHeaderBox();
    }

    @Override
    public SubSampleInformationBox getSubsampleInformationBox() {
        return this.origTrack.getSubsampleInformationBox();
    }
}

