/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.gui;

import com.coremedia.iso.Hex;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.FullBox;
import com.coremedia.iso.gui.IsoViewerPanel;
import com.coremedia.iso.gui.MultiLineCellRenderer;
import com.coremedia.iso.gui.NonEditableJTextField;
import com.coremedia.iso.gui.transferhelper.StringTransferValue;
import com.coremedia.iso.gui.transferhelper.TransferHelperFactory;
import com.coremedia.iso.gui.transferhelper.TransferValue;
import com.googlecode.mp4parser.AbstractBox;
import com.googlecode.mp4parser.util.Path;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataListener;

public class GenericBoxPane
extends JPanel {
    private Box box;
    GridBagLayout gridBagLayout;
    GridBagConstraints gridBagConstraints;
    static Properties names = new Properties();
    Pattern p = Pattern.compile("(.*)\\((.*?)\\)");
    private static final Collection<String> skipList;

    public GenericBoxPane(Box box) {
        this.box = box;
        this.gridBagLayout = new GridBagLayout();
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.setLayout(this.gridBagLayout);
        this.addHeader();
        this.addProperties();
    }

    private void add(String name, JComponent view) {
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.weightx = 0.01;
        this.gridBagConstraints.fill = 0;
        JLabel nameLabel = new JLabel(name);
        this.gridBagLayout.setConstraints(nameLabel, this.gridBagConstraints);
        this.gridBagConstraints.gridx = 1;
        this.gridBagConstraints.weightx = 1.0;
        this.gridBagConstraints.fill = 2;
        this.gridBagLayout.setConstraints(view, this.gridBagConstraints);
        this.add(nameLabel);
        this.add(view);
        ++this.gridBagConstraints.gridy;
    }

    protected void addHeader() {
        JLabel displayName = new JLabel();
        displayName.setText(FourCcToName.name(this.box.getType(), this.box instanceof AbstractBox ? ((AbstractBox)this.box).getUserType() : null, this.box.getParent() instanceof Box ? ((Box)((Object)this.box.getParent())).getType() : null));
        Font curFont = displayName.getFont();
        this.gridBagConstraints.gridwidth = 2;
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = 0;
        this.gridBagConstraints.anchor = 18;
        displayName.setFont(new Font(curFont.getFontName(), curFont.getStyle(), 20));
        this.gridBagLayout.setConstraints(displayName, this.gridBagConstraints);
        this.add(displayName);
        this.gridBagConstraints.gridwidth = 1;
        ++this.gridBagConstraints.gridy;
        this.add("path", new NonEditableJTextField(Path.createPath(this.box)));
        this.add("type", new NonEditableJTextField(this.box.getType()));
        this.add("size", new NonEditableJTextField(String.valueOf(this.box.getSize())));
        if (this.box instanceof FullBox) {
            FullBox fullBox = (FullBox)this.box;
            this.add("version", new NonEditableJTextField(String.valueOf(fullBox.getVersion())));
            this.add("flags", new NonEditableJTextField(Integer.toHexString(fullBox.getFlags())));
        }
        this.gridBagConstraints.gridwidth = 2;
        this.gridBagLayout.setConstraints(new JSeparator(), this.gridBagConstraints);
        this.gridBagConstraints.gridwidth = 1;
        ++this.gridBagConstraints.gridy;
    }

    protected void addProperties() {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(this.box.getClass());
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            boolean editable = false;
            final LinkedList<TransferValue> editors = new LinkedList<TransferValue>();
            JButton apply = new JButton("Apply changes");
            apply.setEnabled(false);
            apply.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    for (TransferValue editor : editors) {
                        editor.go();
                    }
                    Container c = GenericBoxPane.this.getParent();
                    while (!(c instanceof IsoViewerPanel)) {
                        c = c.getParent();
                    }
                    ((IsoViewerPanel)c).showDetails(GenericBoxPane.this.box);
                }
            });
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
                String name = propertyDescriptor.getName();
                if (skipList.contains(name) || propertyDescriptor.getReadMethod() == null || AbstractBox.class.isAssignableFrom(propertyDescriptor.getReadMethod().getReturnType())) continue;
                final Object value = propertyDescriptor.getReadMethod().invoke((Object)this.box, (Object[])null);
                if (value == null) {
                    this.add(name, new NonEditableJTextField(""));
                    continue;
                }
                if (Number.class.isAssignableFrom(value.getClass())) {
                    if (propertyDescriptor.getWriteMethod() != null) {
                        JFormattedTextField jftf = new JFormattedTextField(NumberFormat.getNumberInstance());
                        jftf.setValue(value);
                        jftf.getDocument().addDocumentListener(new ActivateOnChange(apply));
                        editors.add(TransferHelperFactory.getNumberTransferHelper(value.getClass(), this.box, propertyDescriptor.getWriteMethod(), jftf));
                        this.add(name, jftf);
                        editable = true;
                        continue;
                    }
                    this.add(name, new NonEditableJTextField(value.toString()));
                    continue;
                }
                if (value.getClass().equals(String.class)) {
                    if (propertyDescriptor.getWriteMethod() != null) {
                        JTextField jtf = new JTextField(value.toString());
                        jtf.getDocument().addDocumentListener(new ActivateOnChange(apply));
                        editors.add(new StringTransferValue(jtf, this.box, propertyDescriptor.getWriteMethod()));
                        this.add(name, jtf);
                        editable = true;
                        continue;
                    }
                    this.add(name, new NonEditableJTextField(value.toString()));
                    continue;
                }
                if (value.getClass().equals(Boolean.class)) {
                    if (propertyDescriptor.getWriteMethod() != null) {
                        JCheckBox jCheckBox = new JCheckBox(value.toString(), null, (Boolean)value);
                        this.add(name, jCheckBox);
                        editable = false;
                        continue;
                    }
                    this.add(name, new NonEditableJTextField(value.toString()));
                    continue;
                }
                if (value.getClass().isArray()) {
                    int finalLength;
                    JScrollPane jScrollPane;
                    int length = Array.getLength(value);
                    if (value.getClass().getComponentType().isAssignableFrom(String.class)) {
                        jScrollPane = new JScrollPane();
                        jScrollPane.getVerticalScrollBar().setUnitIncrement(16);
                        JList jl = new JList();
                        jl.setCellRenderer(new MultiLineCellRenderer());
                        finalLength = length;
                        jl.setModel(new ListModel(){

                            public int getSize() {
                                return finalLength;
                            }

                            public Object getElementAt(int index) {
                                return Array.get(value, index);
                            }

                            public void addListDataListener(ListDataListener l) {
                            }

                            public void removeListDataListener(ListDataListener l) {
                            }
                        });
                        jScrollPane.getViewport().add(jl);
                        jScrollPane.setPreferredSize(new Dimension(400, 200));
                        this.add(name + "[" + length + "]", jScrollPane);
                        continue;
                    }
                    if (length < 50) {
                        StringBuilder valueBuffer = new StringBuilder();
                        valueBuffer.append("[");
                        boolean trucated = false;
                        if (length > 1000) {
                            trucated = true;
                            length = 1000;
                        }
                        for (int j = 0; j < length; ++j) {
                            Object item;
                            if (j > 0) {
                                valueBuffer.append(", ");
                            }
                            valueBuffer.append((item = Array.get(value, j)) != null ? item.toString() : "");
                        }
                        if (trucated) {
                            valueBuffer.append(", ...");
                        }
                        valueBuffer.append("]");
                        this.add(name + "[" + length + "]", new NonEditableJTextField(valueBuffer.toString()));
                        continue;
                    }
                    jScrollPane = new JScrollPane();
                    jScrollPane.getVerticalScrollBar().setUnitIncrement(16);
                    JList jl = new JList();
                    finalLength = length;
                    jl.setModel(new ListModel(){

                        public int getSize() {
                            return finalLength;
                        }

                        public Object getElementAt(int index) {
                            return Array.get(value, index);
                        }

                        public void addListDataListener(ListDataListener l) {
                        }

                        public void removeListDataListener(ListDataListener l) {
                        }
                    });
                    jScrollPane.getViewport().add(jl);
                    this.add(name + "[" + length + "]", jScrollPane);
                    continue;
                }
                if (!List.class.isAssignableFrom(value.getClass())) continue;
                JScrollPane jScrollPane = new JScrollPane();
                jScrollPane.getVerticalScrollBar().setUnitIncrement(16);
                JList jl = new JList();
                final int finalLength = ((List)value).size();
                jl.setModel(new ListModel(){

                    public int getSize() {
                        return finalLength;
                    }

                    public Object getElementAt(int index) {
                        return ((List)value).get(index);
                    }

                    public void addListDataListener(ListDataListener l) {
                    }

                    public void removeListDataListener(ListDataListener l) {
                    }
                });
                jScrollPane.getViewport().add(jl);
                this.add(name + "[" + finalLength + "]", jScrollPane);
            }
            if (editable) {
                this.gridBagConstraints.gridx = 1;
                ++this.gridBagConstraints.gridy;
                this.gridBagConstraints.fill = 0;
                this.gridBagConstraints.anchor = 13;
                this.gridBagLayout.setConstraints(apply, this.gridBagConstraints);
                this.add(apply);
            }
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            names.load(GenericBoxPane.class.getResourceAsStream("/names.properties"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        skipList = Arrays.asList("class", "boxes", "deadBytes", "type", "userType", "size", "displayName", "contentSize", "header", "version", "flags", "isoFile", "parent", "data", "omaDrmData", "content", "tracks", "sampleSizeAtIndex", "numOfBytesToFirstChild");
    }

    private static class FourCcToName {
        private FourCcToName() {
        }

        public static String name(String type, byte[] userType, String parent) {
            String name;
            if (userType != null) {
                if (!"uuid".equals(type)) {
                    throw new RuntimeException("we have a userType but no uuid box type. Something's wrong");
                }
                name = names.getProperty(parent + "-uuid[" + Hex.encodeHex(userType).toUpperCase() + "]");
                if (name == null) {
                    name = names.getProperty("uuid[" + Hex.encodeHex(userType).toUpperCase() + "]");
                }
                if (name == null) {
                    name = names.getProperty("uuid");
                }
            } else {
                name = names.getProperty(parent + "-" + type);
                if (name == null && type != null) {
                    name = names.getProperty(type);
                } else if (type == null) {
                    System.err.println("Type null! Parent: " + parent);
                }
            }
            if (name == null) {
                name = names.getProperty("default");
            }
            return name;
        }
    }

    class ActivateOnChange
    implements DocumentListener {
        JComponent toBeActivated;

        ActivateOnChange(JComponent toBeActivated) {
            this.toBeActivated = toBeActivated;
        }

        public void insertUpdate(DocumentEvent e) {
            this.toBeActivated.setEnabled(true);
        }

        public void removeUpdate(DocumentEvent e) {
            this.toBeActivated.setEnabled(true);
        }

        public void changedUpdate(DocumentEvent e) {
            this.toBeActivated.setEnabled(true);
        }
    }
}

