/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.gui;

import com.coremedia.iso.IsoTypeReader;
import com.googlecode.mp4parser.util.CastUtils;
import java.io.IOException;
import java.nio.ByteBuffer;

public class IsoSampleNALUnitReader {
    private final ByteBuffer src;
    private int nalLengthSize = 4;

    public IsoSampleNALUnitReader(ByteBuffer src, int nalLengthSize) throws IOException {
        this.src = src;
        this.nalLengthSize = nalLengthSize;
    }

    public ByteBuffer nextNALUnit() throws IOException {
        if (this.src.remaining() < 5) {
            return null;
        }
        if (this.src.remaining() >= this.nalLengthSize) {
            long nalLength;
            if (this.nalLengthSize == 1) {
                nalLength = IsoTypeReader.readUInt8(this.src);
            } else if (this.nalLengthSize == 2) {
                nalLength = IsoTypeReader.readUInt16(this.src);
            } else if (this.nalLengthSize == 3) {
                nalLength = IsoTypeReader.readUInt24(this.src);
            } else if (this.nalLengthSize == 4) {
                nalLength = IsoTypeReader.readUInt32(this.src);
            } else {
                throw new IOException("Unknown NAL Length isze ");
            }
            if (nalLength == 0L) {
                return null;
            }
            ByteBuffer nal = this.src.slice();
            nal.limit(CastUtils.l2i(nalLength));
            this.src.position(this.src.position() + CastUtils.l2i(nalLength));
            return nal;
        }
        throw new RuntimeException("remaining bytes less than nalLengthSize found in sample. should not be here.");
    }
}

