/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.gui;

import com.coremedia.iso.boxes.h264.AvcConfigurationBox;
import com.coremedia.iso.boxes.sampleentry.AbstractSampleEntry;
import com.coremedia.iso.boxes.sampleentry.VisualSampleEntry;
import com.coremedia.iso.gui.IsoSampleNALUnitReader;
import com.coremedia.iso.gui.SampleListModel;
import java.awt.Component;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampleListRenderer
extends DefaultListCellRenderer {
    private long failedTrackId;
    private boolean bruteforceAvc = true;

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        SampleListModel.Entry sampleListEntry = (SampleListModel.Entry)value;
        value = "Sample " + (index + 1) + "@" + sampleListEntry + " - " + sampleListEntry.sample.remaining() + "bytes";
        AbstractSampleEntry se = sampleListEntry.se;
        if (se != null && se instanceof VisualSampleEntry && !se.getBoxes(AvcConfigurationBox.class).isEmpty()) {
            try {
                int nalLengthSize = se.getBoxes(AvcConfigurationBox.class).get(0).getLengthSizeMinusOne() + 1;
                ArrayList<NalWrapper> nals = this.getNals(sampleListEntry, nalLengthSize);
                value = value + " " + nals;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (sampleListEntry.avcD != null) {
            try {
                int nalLengthSize = sampleListEntry.avcD.lengthSizeMinusOne + 1;
                ArrayList<NalWrapper> nals = this.getNals(sampleListEntry, nalLengthSize);
                value = value + " " + nals;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (this.bruteforceAvc && se == null && sampleListEntry.trackId != this.failedTrackId) {
            try {
                System.out.println("No AVC SampleEntry found, trying to parse sample as AVC with default NAL length of 4bytes.");
                ArrayList<NalWrapper> nals = this.getNals(sampleListEntry, 4);
                value = value + " " + nals;
            }
            catch (Exception e) {
                this.failedTrackId = sampleListEntry.trackId;
                System.err.println("Didn't work. Won't try again with trackId " + this.failedTrackId);
            }
        }
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        return this;
    }

    private ArrayList<NalWrapper> getNals(SampleListModel.Entry sampleListEntry, int nalLengthSize) throws IOException {
        ByteBuffer nal;
        IsoSampleNALUnitReader isoSampleNALUnitReader = new IsoSampleNALUnitReader(sampleListEntry.sample, nalLengthSize);
        ArrayList<NalWrapper> nals = new ArrayList<NalWrapper>();
        while ((nal = isoSampleNALUnitReader.nextNALUnit()) != null) {
            nals.add(new NalWrapper(nal));
        }
        return nals;
    }

    public class NalWrapper {
        ByteBuffer data;
        private int nal_ref_idc;
        private int nal_unit_type;

        public NalWrapper(ByteBuffer data) {
            this.data = data;
            byte type = data.get();
            this.nal_ref_idc = type >> 5 & 3;
            this.nal_unit_type = type & 0x1F;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            switch (this.nal_unit_type) {
                case 1: {
                    sb.append("NonIDR");
                    break;
                }
                case 2: {
                    sb.append("Part.A");
                    break;
                }
                case 3: {
                    sb.append("Part.B");
                    break;
                }
                case 4: {
                    sb.append("Part.C");
                    break;
                }
                case 5: {
                    sb.append("IDR");
                    break;
                }
                case 6: {
                    sb.append("SEI");
                    break;
                }
                case 7: {
                    sb.append("SPS");
                    break;
                }
                case 8: {
                    sb.append("PPS");
                    break;
                }
                case 9: {
                    sb.append("AUD");
                    break;
                }
                case 10: {
                    sb.append("EndOfSeq");
                    break;
                }
                case 11: {
                    sb.append("EndOfStr");
                }
            }
            sb.append("{").append("type:").append(this.nal_unit_type).append(",idc:").append(this.nal_ref_idc).append(",size:").append(this.data.limit());
            sb.append('}');
            return sb.toString();
        }
    }
}

