/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.builder;

import com.coremedia.iso.boxes.TimeToSampleBox;
import com.coremedia.iso.boxes.sampleentry.AudioSampleEntry;
import com.googlecode.mp4parser.authoring.Movie;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.builder.FragmentIntersectionFinder;
import com.googlecode.mp4parser.util.Math;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncSampleIntersectFinderImpl
implements FragmentIntersectionFinder {
    private static Logger LOG = Logger.getLogger(SyncSampleIntersectFinderImpl.class.getName());
    private static Map<CacheTuple, long[]> getTimesCache = new ConcurrentHashMap<CacheTuple, long[]>();
    private static Map<CacheTuple, long[]> getSampleNumbersCache = new ConcurrentHashMap<CacheTuple, long[]>();
    private final int minFragmentDurationSeconds;

    public SyncSampleIntersectFinderImpl() {
        this.minFragmentDurationSeconds = 0;
    }

    public SyncSampleIntersectFinderImpl(int minFragmentDurationSeconds) {
        this.minFragmentDurationSeconds = minFragmentDurationSeconds;
    }

    @Override
    public long[] sampleNumbers(Track track, Movie movie) {
        CacheTuple key = new CacheTuple(track, movie);
        long[] result = getSampleNumbersCache.get(key);
        if (result != null) {
            return result;
        }
        if ("vide".equals(track.getHandler())) {
            if (track.getSyncSamples() != null && track.getSyncSamples().length > 0) {
                List<long[]> times = SyncSampleIntersectFinderImpl.getSyncSamplesTimestamps(movie, track);
                long[] commonIndices = this.getCommonIndices(track.getSyncSamples(), SyncSampleIntersectFinderImpl.getTimes(track, movie), track.getTrackMetaData().getTimescale(), (long[][])times.toArray((T[])new long[times.size()][]));
                getSampleNumbersCache.put(key, commonIndices);
                return commonIndices;
            }
            throw new RuntimeException("Video Tracks need sync samples. Only tracks other than video may have no sync samples.");
        }
        if ("soun".equals(track.getHandler())) {
            Track referenceTrack = null;
            for (Track candidate : movie.getTracks()) {
                if (candidate.getSyncSamples() == null || !"vide".equals(candidate.getHandler()) || candidate.getSyncSamples().length <= 0) continue;
                referenceTrack = candidate;
            }
            if (referenceTrack != null) {
                long[] refSyncSamples = this.sampleNumbers(referenceTrack, movie);
                int refSampleCount = referenceTrack.getSamples().size();
                long[] syncSamples = new long[refSyncSamples.length];
                long minSampleRate = 192000L;
                for (Track testTrack : movie.getTracks()) {
                    AudioSampleEntry ase;
                    if (!"soun".equals(testTrack.getHandler()) || (ase = (AudioSampleEntry)testTrack.getSampleDescriptionBox().getSampleEntry()).getSampleRate() >= minSampleRate) continue;
                    minSampleRate = ase.getSampleRate();
                    long sc = testTrack.getSamples().size();
                    double stretch = (double)sc / (double)refSampleCount;
                    TimeToSampleBox.Entry sttsEntry = testTrack.getDecodingTimeEntries().get(0);
                    long samplesPerFrame = sttsEntry.getDelta();
                    int i = 0;
                    while (i < syncSamples.length) {
                        long start;
                        syncSamples[i] = start = (long)java.lang.Math.ceil(stretch * (double)(refSyncSamples[i] - 1L) * (double)samplesPerFrame);
                        ++i;
                    }
                    break block1;
                }
                AudioSampleEntry ase = (AudioSampleEntry)track.getSampleDescriptionBox().getSampleEntry();
                TimeToSampleBox.Entry sttsEntry = track.getDecodingTimeEntries().get(0);
                long samplesPerFrame = sttsEntry.getDelta();
                double factor = (double)ase.getSampleRate() / (double)minSampleRate;
                if (factor != java.lang.Math.rint(factor)) {
                    throw new RuntimeException("Sample rates must be a multiple of the lowest sample rate to create a correct file!");
                }
                int i = 0;
                while (i < syncSamples.length) {
                    syncSamples[i] = (long)(1.0 + (double)syncSamples[i] * factor / (double)samplesPerFrame);
                    ++i;
                }
                getSampleNumbersCache.put(key, syncSamples);
                return syncSamples;
            }
            throw new RuntimeException("There was absolutely no Track with sync samples. I can't work with that!");
        }
        for (Track candidate : movie.getTracks()) {
            if (candidate.getSyncSamples() == null || candidate.getSyncSamples().length <= 0) continue;
            long[] refSyncSamples = this.sampleNumbers(candidate, movie);
            int refSampleCount = candidate.getSamples().size();
            long[] syncSamples = new long[refSyncSamples.length];
            long sc = track.getSamples().size();
            double stretch = (double)sc / (double)refSampleCount;
            int i = 0;
            while (i < syncSamples.length) {
                long start;
                syncSamples[i] = start = (long)java.lang.Math.ceil(stretch * (double)(refSyncSamples[i] - 1L)) + 1L;
                ++i;
            }
            getSampleNumbersCache.put(key, syncSamples);
            return syncSamples;
        }
        throw new RuntimeException("There was absolutely no Track with sync samples. I can't work with that!");
    }

    public static List<long[]> getSyncSamplesTimestamps(Movie movie, Track track) {
        LinkedList<long[]> times = new LinkedList<long[]>();
        for (Track currentTrack : movie.getTracks()) {
            long[] currentTrackSyncSamples;
            if (!currentTrack.getHandler().equals(track.getHandler()) || (currentTrackSyncSamples = currentTrack.getSyncSamples()) == null || currentTrackSyncSamples.length <= 0) continue;
            long[] currentTrackTimes = SyncSampleIntersectFinderImpl.getTimes(currentTrack, movie);
            times.add(currentTrackTimes);
        }
        return times;
    }

    public long[] getCommonIndices(long[] syncSamples, long[] syncSampleTimes, long timeScale, long[] ... otherTracksTimes) {
        int n;
        Object object;
        LinkedList<Long> nuSyncSamples = new LinkedList<Long>();
        LinkedList<Long> nuSyncSampleTimes = new LinkedList<Long>();
        int i = 0;
        while (i < syncSampleTimes.length) {
            boolean foundInEveryRef = true;
            object = otherTracksTimes;
            n = otherTracksTimes.length;
            int n2 = 0;
            while (n2 < n) {
                long[] times = object[n2];
                foundInEveryRef &= Arrays.binarySearch(times, syncSampleTimes[i]) >= 0;
                ++n2;
            }
            if (foundInEveryRef) {
                nuSyncSamples.add(syncSamples[i]);
                nuSyncSampleTimes.add(syncSampleTimes[i]);
            }
            ++i;
        }
        if ((double)nuSyncSamples.size() < (double)syncSamples.length * 0.25) {
            String log = "";
            log = String.valueOf(log) + String.format("%5d - Common:  [", nuSyncSamples.size());
            Iterator iterator = nuSyncSamples.iterator();
            while (iterator.hasNext()) {
                long l = (Long)iterator.next();
                log = String.valueOf(log) + String.format("%10d,", l);
            }
            log = String.valueOf(log) + "]";
            LOG.warning(log);
            log = "";
            log = String.valueOf(log) + String.format("%5d - In    :  [", syncSamples.length);
            object = syncSamples;
            n = syncSamples.length;
            int n3 = 0;
            while (n3 < n) {
                long[] l = object[n3];
                log = String.valueOf(log) + String.format("%10d,", (long)l);
                ++n3;
            }
            log = String.valueOf(log) + "]";
            LOG.warning(log);
            LOG.warning("There are less than 25% of common sync samples in the given track.");
            throw new RuntimeException("There are less than 25% of common sync samples in the given track.");
        }
        if ((double)nuSyncSamples.size() < (double)syncSamples.length * 0.5) {
            LOG.fine("There are less than 50% of common sync samples in the given track. This is implausible but I'm ok to continue.");
        } else if (nuSyncSamples.size() < syncSamples.length) {
            LOG.finest("Common SyncSample positions vs. this tracks SyncSample positions: " + nuSyncSamples.size() + " vs. " + syncSamples.length);
        }
        LinkedList<Long> finalSampleList = new LinkedList<Long>();
        if (this.minFragmentDurationSeconds > 0) {
            long lastSyncSampleTime = -1L;
            Iterator nuSyncSamplesIterator = nuSyncSamples.iterator();
            Iterator nuSyncSampleTimesIterator = nuSyncSampleTimes.iterator();
            while (nuSyncSamplesIterator.hasNext() && nuSyncSampleTimesIterator.hasNext()) {
                long curSyncSample = (Long)nuSyncSamplesIterator.next();
                long curSyncSampleTime = (Long)nuSyncSampleTimesIterator.next();
                if (lastSyncSampleTime != -1L && (curSyncSampleTime - lastSyncSampleTime) / timeScale < (long)this.minFragmentDurationSeconds) continue;
                finalSampleList.add(curSyncSample);
                lastSyncSampleTime = curSyncSampleTime;
            }
        } else {
            finalSampleList = nuSyncSamples;
        }
        long[] finalSampleArray = new long[finalSampleList.size()];
        int i2 = 0;
        while (i2 < finalSampleArray.length) {
            finalSampleArray[i2] = (Long)finalSampleList.get(i2);
            ++i2;
        }
        return finalSampleArray;
    }

    private static long[] getTimes(Track track, Movie m) {
        CacheTuple key = new CacheTuple(track, m);
        long[] result = getTimesCache.get(key);
        if (result != null) {
            return result;
        }
        long[] syncSamples = track.getSyncSamples();
        long[] syncSampleTimes = new long[syncSamples.length];
        LinkedList<TimeToSampleBox.Entry> timeQueue = new LinkedList<TimeToSampleBox.Entry>(track.getDecodingTimeEntries());
        int currentSample = 1;
        long currentDuration = 0L;
        long currentDelta = 0L;
        int currentSyncSampleIndex = 0;
        long left = 0L;
        long scalingFactor = SyncSampleIntersectFinderImpl.calculateTracktimesScalingFactor(m, track);
        while ((long)currentSample <= syncSamples[syncSamples.length - 1]) {
            if ((long)currentSample++ == syncSamples[currentSyncSampleIndex]) {
                syncSampleTimes[currentSyncSampleIndex++] = currentDuration * scalingFactor;
            }
            if (left-- == 0L) {
                TimeToSampleBox.Entry entry = (TimeToSampleBox.Entry)timeQueue.poll();
                left = entry.getCount() - 1L;
                currentDelta = entry.getDelta();
            }
            currentDuration += currentDelta;
        }
        getTimesCache.put(key, syncSampleTimes);
        return syncSampleTimes;
    }

    private static long calculateTracktimesScalingFactor(Movie m, Track track) {
        long timeScale = 1L;
        for (Track track1 : m.getTracks()) {
            if (!track1.getHandler().equals(track.getHandler()) || track1.getTrackMetaData().getTimescale() == track.getTrackMetaData().getTimescale()) continue;
            timeScale = Math.lcm(timeScale, track1.getTrackMetaData().getTimescale());
        }
        return timeScale;
    }

    public static class CacheTuple {
        Track track;
        Movie movie;

        public CacheTuple(Track track, Movie movie) {
            this.track = track;
            this.movie = movie;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheTuple that = (CacheTuple)o;
            if (this.movie != null ? !this.movie.equals(that.movie) : that.movie != null) {
                return false;
            }
            return !(this.track != null ? !this.track.equals(that.track) : that.track != null);
        }

        public int hashCode() {
            int result = this.track != null ? this.track.hashCode() : 0;
            result = 31 * result + (this.movie != null ? this.movie.hashCode() : 0);
            return result;
        }
    }
}

