/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.samples;

import com.coremedia.iso.boxes.Container;
import com.coremedia.iso.boxes.MovieBox;
import com.coremedia.iso.boxes.SampleSizeBox;
import com.coremedia.iso.boxes.SampleToChunkBox;
import com.coremedia.iso.boxes.TrackBox;
import com.googlecode.mp4parser.authoring.Sample;
import com.googlecode.mp4parser.authoring.SampleImpl;
import com.googlecode.mp4parser.util.CastUtils;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMp4SampleList
extends AbstractList<Sample> {
    Container topLevel;
    TrackBox trackBox = null;

    public DefaultMp4SampleList(long track, Container topLevel) {
        this.topLevel = topLevel;
        MovieBox movieBox = topLevel.getBoxes(MovieBox.class).get(0);
        List<TrackBox> trackBoxes = movieBox.getBoxes(TrackBox.class);
        for (TrackBox tb : trackBoxes) {
            if (tb.getTrackHeaderBox().getTrackId() != track) continue;
            this.trackBox = tb;
        }
        if (this.trackBox == null) {
            throw new RuntimeException("This MP4 does not contain track " + track);
        }
    }

    @Override
    public Sample get(int index) {
        long chunkStart;
        if ((long)index >= this.trackBox.getSampleTableBox().getSampleSizeBox().getSampleCount()) {
            throw new IndexOutOfBoundsException();
        }
        List<SampleToChunkBox.Entry> entries = this.trackBox.getSampleTableBox().getSampleToChunkBox().getEntries();
        Iterator<SampleToChunkBox.Entry> iterator = entries.iterator();
        SampleToChunkBox.Entry next = iterator.next();
        long currentChunkNo = 0L;
        long currentSamplePerChunk = 0L;
        long nextFirstChunk = next.getFirstChunk();
        long nextSamplePerChunk = next.getSamplesPerChunk();
        int currentSampleNo = 1;
        int targetSampleNo = index + 1;
        do {
            if (++currentChunkNo != nextFirstChunk) continue;
            currentSamplePerChunk = nextSamplePerChunk;
            if (iterator.hasNext()) {
                next = iterator.next();
                nextSamplePerChunk = next.getSamplesPerChunk();
                nextFirstChunk = next.getFirstChunk();
                continue;
            }
            nextSamplePerChunk = -1L;
            nextFirstChunk = Long.MAX_VALUE;
        } while ((currentSampleNo = (int)((long)currentSampleNo + currentSamplePerChunk)) <= targetSampleNo);
        currentSampleNo = (int)((long)currentSampleNo - currentSamplePerChunk);
        long offset = chunkStart = this.trackBox.getSampleTableBox().getChunkOffsetBox().getChunkOffsets()[CastUtils.l2i(currentChunkNo - 1L)];
        SampleSizeBox ssb = this.trackBox.getSampleTableBox().getSampleSizeBox();
        while (currentSampleNo < targetSampleNo) {
            offset += ssb.getSampleSizeAtIndex(currentSampleNo++ - 1);
        }
        try {
            return new SampleImpl(this.topLevel.getByteBuffer(offset, ssb.getSampleSizeAtIndex(currentSampleNo - 1)));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public int size() {
        return CastUtils.l2i(this.trackBox.getSampleTableBox().getSampleSizeBox().getSampleCount());
    }
}

