/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.cache.memory;

import com.nostra13.universalimageloader.cache.memory.BaseMemoryCache;
import com.nostra13.universalimageloader.utils.L;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class LimitedMemoryCache<K, V>
extends BaseMemoryCache<K, V> {
    private static final int MAX_NORMAL_CACHE_SIZE_IN_MB = 16;
    private static final int MAX_NORMAL_CACHE_SIZE = 0x1000000;
    private final int sizeLimit;
    private final AtomicInteger cacheSize;
    private final List<V> hardCache = Collections.synchronizedList(new LinkedList());

    public LimitedMemoryCache(int sizeLimit) {
        this.sizeLimit = sizeLimit;
        this.cacheSize = new AtomicInteger();
        if (sizeLimit > 0x1000000) {
            L.w("You set too large memory cache size (more than %1$d Mb)", 16);
        }
    }

    @Override
    public boolean put(K key, V value) {
        boolean putSuccessfully = false;
        int valueSize = this.getSize(value);
        int sizeLimit = this.getSizeLimit();
        int curCacheSize = this.cacheSize.get();
        if (valueSize < sizeLimit) {
            while (curCacheSize + valueSize > sizeLimit) {
                V removedValue = this.removeNext();
                if (!this.hardCache.remove(removedValue)) continue;
                curCacheSize = this.cacheSize.addAndGet(-this.getSize(removedValue));
            }
            this.hardCache.add(value);
            this.cacheSize.addAndGet(valueSize);
            putSuccessfully = true;
        }
        super.put(key, value);
        return putSuccessfully;
    }

    @Override
    public void remove(K key) {
        Object value = super.get(key);
        if (value != null && this.hardCache.remove(value)) {
            this.cacheSize.addAndGet(-this.getSize(value));
        }
        super.remove(key);
    }

    @Override
    public void clear() {
        this.hardCache.clear();
        this.cacheSize.set(0);
        super.clear();
    }

    protected int getSizeLimit() {
        return this.sizeLimit;
    }

    protected abstract int getSize(V var1);

    protected abstract V removeNext();
}

