/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.gui.hex;

import com.coremedia.iso.gui.Iso8859_1;
import com.coremedia.iso.gui.hex.JHexEditor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;

public class JHexEditorASCII
extends JComponent
implements MouseListener,
KeyListener {
    private JHexEditor he;

    public JHexEditorASCII(JHexEditor he) {
        this.he = he;
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.addFocusListener(he);
    }

    public Dimension getPreferredSize() {
        this.debug("getPreferredSize()");
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        this.debug("getMinimumSize()");
        Dimension d = new Dimension();
        FontMetrics fn = this.getFontMetrics(JHexEditor.font);
        int h = fn.getHeight();
        int nl = this.he.getNumberOfVisibleLines();
        d.setSize((fn.stringWidth(" ") + 1) * 16 + this.he.border * 2 + 1, h * nl + this.he.border * 2 + 1);
        return d;
    }

    public void paint(Graphics g) {
        this.debug("paint(" + g + ")");
        this.debug("cursor=" + this.he.cursor + " buff.length=" + this.he.buff.limit());
        Dimension d = this.getMinimumSize();
        g.setColor(Color.white);
        g.fillRect(0, 0, d.width, d.height);
        g.setColor(Color.black);
        g.setFont(JHexEditor.font);
        int ini = this.he.getInicio() * 16;
        long fin = ini + this.he.getNumberOfVisibleLines() * 16;
        if (fin > (long)this.he.buff.limit()) {
            fin = this.he.buff.limit();
        }
        int x = 0;
        int y = 0;
        this.he.buff.position(ini);
        int n = ini;
        while ((long)n < fin) {
            if (n == this.he.cursor) {
                g.setColor(Color.blue);
                if (this.hasFocus()) {
                    this.he.filledCursor(g, x, y, 1);
                } else {
                    this.he.cuadro(g, x, y, 1);
                }
                if (this.hasFocus()) {
                    g.setColor(Color.white);
                } else {
                    g.setColor(Color.black);
                }
            } else {
                g.setColor(Color.black);
            }
            String s = Iso8859_1.convert(new byte[]{this.he.buff.get()});
            this.he.printString(g, s, x++, y);
            if (x == 16) {
                x = 0;
                ++y;
            }
            ++n;
        }
    }

    private void debug(String s) {
        if (this.he.DEBUG) {
            System.out.println("JHexEditorASCII ==> " + s);
        }
    }

    public int calcularPosicionRaton(int x, int y) {
        FontMetrics fn = this.getFontMetrics(JHexEditor.font);
        this.debug("x=" + (x /= fn.stringWidth(" ") + 1) + " ,y=" + (y /= fn.getHeight()));
        return x + (y + this.he.getInicio()) * 16;
    }

    public void mouseClicked(MouseEvent e) {
        this.debug("mouseClicked(" + e + ")");
        this.he.cursor = this.calcularPosicionRaton(e.getX(), e.getY());
        this.requestFocus();
        this.he.repaint();
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        this.debug("keyReleased(" + e + ")");
    }

    public boolean isFocusable() {
        return true;
    }
}

