/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.security.mobile.module.deviceinfo;

import android.bluetooth.BluetoothAdapter;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.graphics.Point;
import android.hardware.Camera;
import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import com.alipay.security.mobile.module.commonutils.CommonUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;

public class DeviceInfo {
    private static DeviceInfo a = new DeviceInfo();

    private DeviceInfo() {
    }

    public static DeviceInfo getInstance() {
        return a;
    }

    public String getIMEI(Context context) {
        String string = null;
        if (context != null) {
            try {
                context = (TelephonyManager)context.getSystemService("phone");
                if (context != null) {
                    string = context.getDeviceId();
                }
            }
            catch (Exception exception) {}
        }
        return string;
    }

    public String getIMSI(Context context) {
        String string = null;
        if (context != null) {
            try {
                context = (TelephonyManager)context.getSystemService("phone");
                if (context != null) {
                    string = context.getSubscriberId();
                }
            }
            catch (Exception exception) {}
        }
        return string;
    }

    public String getOperatorType(Context context) {
        String string = null;
        if (context != null) {
            try {
                context = (TelephonyManager)context.getSystemService("phone");
                if (context != null) {
                    string = context.getSimOperator();
                }
            }
            catch (Exception exception) {}
        }
        return string;
    }

    public String getOperatorName(Context context) {
        String string = null;
        if (context != null) {
            try {
                context = (TelephonyManager)context.getSystemService("phone");
                if (context != null) {
                    string = context.getSimOperatorName();
                }
            }
            catch (Exception exception) {}
        }
        return string;
    }

    public String getPhoneNumber(Context context) {
        String string = "";
        if (context != null) {
            try {
                context = (TelephonyManager)context.getSystemService("phone");
                if (context != null) {
                    string = context.getLine1Number();
                }
            }
            catch (Exception exception) {}
        }
        return string;
    }

    public String getVoiceMailNumber(Context context) {
        String string = null;
        if (context != null) {
            try {
                context = (TelephonyManager)context.getSystemService("phone");
                if (context != null) {
                    string = context.getVoiceMailNumber();
                }
            }
            catch (Exception exception) {}
        }
        return string;
    }

    public String getVoiceMailTag(Context context) {
        String string = null;
        if (context != null) {
            try {
                context = (TelephonyManager)context.getSystemService("phone");
                if (context != null) {
                    string = context.getVoiceMailAlphaTag();
                }
            }
            catch (Exception exception) {}
        }
        return string;
    }

    public String getSensorDigest(Context object) {
        String string = null;
        if (object != null) {
            try {
                object = (SensorManager)object.getSystemService("sensor");
                if (object != null && (object = object.getSensorList(-1)) != null && object.size() > 0) {
                    StringBuilder stringBuilder = new StringBuilder();
                    object = object.iterator();
                    while (object.hasNext()) {
                        Sensor sensor = (Sensor)object.next();
                        stringBuilder.append(sensor.getName());
                        stringBuilder.append(sensor.getVersion());
                        stringBuilder.append(sensor.getVendor());
                    }
                    string = CommonUtils.sha1ByString(stringBuilder.toString());
                }
            }
            catch (Exception exception) {}
        }
        return string;
    }

    public String getScreenResolution(Context context) {
        try {
            context = context.getResources().getDisplayMetrics();
            return Integer.toString(context.widthPixels) + "*" + Integer.toString(context.heightPixels);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getScreenDpi(Context context) {
        try {
            context = context.getResources().getDisplayMetrics();
            return "" + context.densityDpi;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getScreenWidth(Context context) {
        try {
            context = context.getResources().getDisplayMetrics();
            return "" + context.widthPixels;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getScreenHeight(Context context) {
        try {
            context = context.getResources().getDisplayMetrics();
            return "" + context.heightPixels;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getMACAddress(Context context) {
        try {
            return ((WifiManager)context.getSystemService("wifi")).getConnectionInfo().getMacAddress();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getSIMSerial(Context context) {
        String string = "";
        try {
            string = ((TelephonyManager)context.getSystemService("phone")).getSimSerialNumber();
        }
        catch (Exception exception) {}
        return string;
    }

    public String getAndroidID(Context context) {
        try {
            return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getCPUSerial() {
        String string = "0000000000000000";
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            String string2;
            Process process = Runtime.getRuntime().exec("cat /proc/cpuinfo | grep Serial");
            inputStreamReader = new InputStreamReader(process.getInputStream());
            bufferedReader = new LineNumberReader(inputStreamReader);
            for (int i2 = 1; i2 < 100 && (string2 = ((LineNumberReader)bufferedReader).readLine()) != null; ++i2) {
                if (string2.indexOf("Serial") < 0) continue;
                string = string2.substring(string2.indexOf(":") + 1, string2.length()).trim();
                break;
            }
        }
        catch (Exception exception) {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
            if (inputStreamReader == null) return string;
            try {
                inputStreamReader.close();
                return string;
            }
            catch (IOException iOException) {
                return string;
            }
        }
        catch (Throwable throwable) {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
            if (inputStreamReader == null) throw throwable;
            try {
                inputStreamReader.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {}
        try {
            inputStreamReader.close();
            return string;
        }
        catch (IOException iOException) {
            return string;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getCPUHardware() {
        String string = "-1";
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            String string2;
            Process process = Runtime.getRuntime().exec("cat /proc/cpuinfo | grep Hardware");
            inputStreamReader = new InputStreamReader(process.getInputStream());
            bufferedReader = new LineNumberReader(inputStreamReader);
            for (int i2 = 1; i2 < 100 && (string2 = ((LineNumberReader)bufferedReader).readLine()) != null; ++i2) {
                if (string2.indexOf("Hardware") < 0) continue;
                string = string2.substring(string2.indexOf(":") + 1, string2.length()).trim();
                break;
            }
        }
        catch (Exception exception) {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
            if (inputStreamReader == null) return string;
            try {
                inputStreamReader.close();
                return string;
            }
            catch (IOException iOException) {
                return string;
            }
        }
        catch (Throwable throwable) {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
            if (inputStreamReader == null) throw throwable;
            try {
                inputStreamReader.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {}
        try {
            inputStreamReader.close();
            return string;
        }
        catch (IOException iOException) {
            return string;
        }
    }

    public String getCpuCount() {
        try {
            class CpuFilter
            implements FileFilter {
                CpuFilter() {
                }

                @Override
                public boolean accept(File file) {
                    return Pattern.matches("cpu[0-9]+", file.getName());
                }
            }
            return String.valueOf(new File("/sys/devices/system/cpu/").listFiles(new CpuFilter()).length);
        }
        catch (Exception exception) {
            return "1";
        }
    }

    public String getCpuFrequent() {
        String string = DeviceInfo.a();
        if (!CommonUtils.isBlank(string)) {
            return string;
        }
        return DeviceInfo.b();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String a() {
        BufferedReader bufferedReader;
        FileReader fileReader;
        block19: {
            String string = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq";
            fileReader = null;
            bufferedReader = null;
            try {
                fileReader = new FileReader(string);
                bufferedReader = new BufferedReader(fileReader, 8192);
                string = bufferedReader.readLine();
                if (CommonUtils.isBlank(string)) break block19;
                string = string.trim();
            }
            catch (IOException iOException) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException2) {}
                try {
                    fileReader.close();
                    return null;
                }
                catch (IOException iOException3) {
                    return null;
                }
            }
            catch (Throwable throwable) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
                try {
                    fileReader.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
            try {
                fileReader.close();
                return string;
            }
            catch (IOException iOException) {}
            return string;
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {}
        try {
            fileReader.close();
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String b() {
        String[] stringArray = "/proc/cpuinfo";
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        try {
            fileReader = new FileReader((String)stringArray);
            bufferedReader = new BufferedReader(fileReader, 8192);
            String string = null;
            while ((stringArray = bufferedReader.readLine()) != null) {
                if (CommonUtils.isBlank((String)stringArray) || (stringArray = stringArray.split(":")) == null || stringArray.length <= 1 || !stringArray[0].contains("BogoMIPS")) continue;
                string = stringArray[1].trim();
                break;
            }
            stringArray = string;
        }
        catch (IOException iOException) {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException iOException2) {}
            }
            if (bufferedReader == null) return null;
            try {
                bufferedReader.close();
                return null;
            }
            catch (IOException iOException3) {
                return null;
            }
        }
        catch (Throwable throwable) {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException iOException) {}
            }
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            fileReader.close();
        }
        catch (IOException iOException) {}
        try {
            bufferedReader.close();
            return stringArray;
        }
        catch (IOException iOException) {}
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getCpuName() {
        BufferedReader bufferedReader;
        FileReader fileReader;
        block21: {
            Object object;
            fileReader = null;
            bufferedReader = null;
            try {
                fileReader = new FileReader("/proc/cpuinfo");
                bufferedReader = new BufferedReader(fileReader);
                object = bufferedReader.readLine().split(":\\s+", 2);
                if (object == null || ((String[])object).length <= 1) break block21;
                object = object[1];
            }
            catch (IOException iOException) {
                if (fileReader != null) {
                    try {
                        fileReader.close();
                    }
                    catch (IOException iOException2) {}
                }
                if (bufferedReader == null) return null;
                try {
                    bufferedReader.close();
                    return null;
                }
                catch (IOException iOException3) {
                    return null;
                }
            }
            catch (Throwable throwable) {
                if (fileReader != null) {
                    try {
                        fileReader.close();
                    }
                    catch (IOException iOException) {}
                }
                if (bufferedReader == null) throw throwable;
                try {
                    bufferedReader.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                fileReader.close();
            }
            catch (IOException iOException) {}
            try {
                bufferedReader.close();
                return object;
            }
            catch (IOException iOException) {}
            return object;
        }
        try {
            fileReader.close();
        }
        catch (IOException iOException) {}
        try {
            bufferedReader.close();
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getMemorySize() {
        String string = "/proc/meminfo";
        long l2 = 0L;
        BufferedReader bufferedReader = null;
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(string);
            bufferedReader = new BufferedReader(fileReader, 8192);
            string = bufferedReader.readLine();
            if (string != null) {
                l2 = Integer.parseInt(string.split("\\s+")[1]);
            }
        }
        catch (IOException iOException) {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException iOException2) {}
            }
            try {
                if (bufferedReader == null) return String.valueOf(l2);
                bufferedReader.close();
                return String.valueOf(l2);
            }
            catch (IOException iOException3) {
                return String.valueOf(l2);
            }
        }
        catch (Throwable throwable) {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException iOException) {}
            }
            try {
                if (bufferedReader == null) throw throwable;
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            fileReader.close();
        }
        catch (IOException iOException) {}
        try {
            bufferedReader.close();
            return String.valueOf(l2);
        }
        catch (IOException iOException) {
            return String.valueOf(l2);
        }
    }

    public String getTotalInternalMemorySize() {
        long l2 = 0L;
        try {
            File file = Environment.getDataDirectory();
            file = new StatFs(file.getPath());
            long l3 = file.getBlockSize();
            l2 = (long)file.getBlockCount() * l3;
        }
        catch (Exception exception) {}
        return String.valueOf(l2);
    }

    public String getSDCardSize() {
        long l2 = 0L;
        try {
            Object object = Environment.getExternalStorageState();
            if ("mounted".equals(object)) {
                object = Environment.getExternalStorageDirectory();
                object = new StatFs(((File)object).getPath());
                long l3 = object.getBlockSize();
                long l4 = object.getBlockCount();
                l2 = l3 * l4;
            }
        }
        catch (Exception exception) {}
        return String.valueOf(l2);
    }

    public boolean getBluStatus() {
        try {
            BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            if (bluetoothAdapter != null && bluetoothAdapter.isEnabled()) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public String getBluMac() {
        try {
            BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            if (bluetoothAdapter != null && !bluetoothAdapter.isEnabled()) {
                return "";
            }
            return bluetoothAdapter.getAddress();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getNetworkType(Context context) {
        try {
            context = (TelephonyManager)context.getSystemService("phone");
            if (context != null) {
                return String.valueOf(context.getNetworkType());
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public String getBandVer() {
        String string = null;
        try {
            Class<?> clazz = Class.forName("android.os.SystemProperties");
            Object obj = clazz.newInstance();
            string = (String)clazz.getMethod("get", String.class, String.class).invoke(obj, "gsm.version.baseband", "no message");
        }
        catch (Exception exception) {}
        return string;
    }

    public String getWifiBssid(Context context) {
        try {
            context = (WifiManager)context.getSystemService("wifi");
            if (context.isWifiEnabled()) {
                return context.getConnectionInfo().getBSSID();
            }
        }
        catch (Throwable throwable) {}
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getKernelVersion() {
        String string;
        String string2;
        String string3;
        block14: {
            FileInputStream fileInputStream;
            string3 = "";
            BufferedReader bufferedReader = null;
            string2 = "";
            try {
                fileInputStream = new FileInputStream("/proc/version");
            }
            catch (FileNotFoundException fileNotFoundException) {
                return string3;
            }
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream), 8192);
                while ((string = bufferedReader.readLine()) != null) {
                    string2 = string2 + string;
                }
            }
            catch (IOException iOException) {
                try {
                    bufferedReader.close();
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException2) {}
                break block14;
            }
            catch (Throwable throwable) {
                try {
                    bufferedReader.close();
                    ((InputStream)fileInputStream).close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                bufferedReader.close();
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException) {}
        }
        try {
            if (!CommonUtils.isNotBlank(string2)) return string3;
            int n2 = string2.indexOf("version ");
            string = string2.substring(n2 + 8);
            n2 = string.indexOf(" ");
            return string.substring(0, n2);
        }
        catch (Exception exception) {}
        return string3;
    }

    public Map<String, Integer> getAllAppName(Context object) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        try {
            object = object.getPackageManager().getInstalledPackages(0);
            if (object != null && object.size() > 0) {
                object = object.iterator();
                while (object.hasNext()) {
                    PackageInfo packageInfo = (PackageInfo)object.next();
                    hashMap.put(packageInfo.packageName, packageInfo.applicationInfo.uid);
                }
            }
        }
        catch (Throwable throwable) {}
        return hashMap;
    }

    public String getPropPreviewsSizeOfCamera(Context context) {
        DeviceInfo.a(context.getApplicationContext());
        int n2 = -1;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            if (Integer.parseInt(Build.VERSION.SDK) > 8) {
                n2 = Camera.getNumberOfCameras();
            }
        }
        catch (Throwable throwable) {}
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = i2 == 0 ? String.format(Locale.ENGLISH, "%1$d:%2$s", i2, this.a(context, i2)) : String.format(Locale.ENGLISH, "#%1$d:%2$s", i2, this.a(context, i2));
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public String getSerialNumber() {
        String string = "";
        try {
            string = Build.SERIAL;
        }
        catch (Exception exception) {}
        return string;
    }

    private String a(Context context, int n2) {
        String string = "%2$d*%3$d";
        String string2 = "";
        float f2 = DeviceInfo.a(context.getApplicationContext());
        Camera camera = null;
        try {
            Camera.Size size;
            camera = Camera.open((int)n2);
            Object object = camera.getParameters();
            float f3 = f2;
            object = object.getSupportedPreviewSizes();
            DeviceInfo deviceInfo = this;
            Collections.sort(object, deviceInfo.new CameraSizeComparator(0));
            int n3 = 0;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                float f4;
                Camera.Size size2;
                Camera.Size size3 = (Camera.Size)iterator.next();
                if (size3.width >= 600 && (double)Math.abs((float)size2.width / (float)size3.height - (f4 = f3)) <= 0.03) break;
                ++n3;
            }
            if (n3 == object.size()) {
                n3 = object.size() - 1;
            }
            if ((size = (Camera.Size)object.get(n3)) != null) {
                string2 = String.format(Locale.ENGLISH, string, n2, size.width, size.height);
            }
        }
        catch (RuntimeException runtimeException) {
        }
        catch (Exception exception) {
        }
        finally {
            if (camera != null) {
                camera.release();
            }
        }
        return string2;
    }

    private static float a(Context context) {
        context = context.getResources().getDisplayMetrics();
        int n2 = context.widthPixels;
        int n3 = context.heightPixels;
        Point point = new Point(n2, n3);
        float f2 = point.y;
        float f3 = point.x;
        return f2 / f3;
    }

    static class 1 {
    }

    private class CameraSizeComparator
    implements Comparator<Camera.Size> {
        private CameraSizeComparator() {
        }

        @Override
        public int compare(Camera.Size size, Camera.Size size2) {
            if (size.width == size2.width) {
                return 0;
            }
            if (size.width > size2.width) {
                return 1;
            }
            return -1;
        }

        /* synthetic */ CameraSizeComparator(byte by) {
            this();
        }
    }
}

