/*
 * Decompiled with CFR 0.152.
 */
package m.framework.utils;

import android.os.Handler;
import android.os.Message;

public class UIHandler {
    private static Handler handler;

    public static void prepare() {
        if (handler == null) {
            handler = new Handler(new Handler.Callback(){

                public boolean handleMessage(Message msg) {
                    UIHandler.handleMessage(msg);
                    return false;
                }
            });
        }
    }

    private static void handleMessage(Message msg) {
        Object[] objs = (Object[])msg.obj;
        Message inner = (Message)objs[0];
        Handler.Callback callback = (Handler.Callback)objs[1];
        if (callback != null) {
            callback.handleMessage(inner);
        }
    }

    private static Message getShellMessage(Message msg, Handler.Callback callback) {
        Message shell = new Message();
        shell.obj = new Object[]{msg, callback};
        return shell;
    }

    private static Message getShellMessage(int what, Handler.Callback callback) {
        Message msg = new Message();
        msg.what = what;
        return UIHandler.getShellMessage(msg, callback);
    }

    public static boolean sendMessage(Message msg, Handler.Callback callback) {
        return handler.sendMessage(UIHandler.getShellMessage(msg, callback));
    }

    public static boolean sendMessageDelayed(Message msg, long delayMillis, Handler.Callback callback) {
        return handler.sendMessageDelayed(UIHandler.getShellMessage(msg, callback), delayMillis);
    }

    public static boolean sendMessageAtTime(Message msg, long uptimeMillis, Handler.Callback callback) {
        return handler.sendMessageAtTime(UIHandler.getShellMessage(msg, callback), uptimeMillis);
    }

    public static boolean sendMessageAtFrontOfQueue(Message msg, Handler.Callback callback) {
        return handler.sendMessageAtFrontOfQueue(UIHandler.getShellMessage(msg, callback));
    }

    public static boolean sendEmptyMessage(int what, Handler.Callback callback) {
        return handler.sendMessage(UIHandler.getShellMessage(what, callback));
    }

    public static boolean sendEmptyMessageAtTime(int what, long uptimeMillis, Handler.Callback callback) {
        return handler.sendMessageAtTime(UIHandler.getShellMessage(what, callback), uptimeMillis);
    }

    public static boolean sendEmptyMessageDelayed(int what, long delayMillis, Handler.Callback callback) {
        return handler.sendMessageDelayed(UIHandler.getShellMessage(what, callback), delayMillis);
    }
}

