/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.utils;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class IoUtils {
    public static final int DEFAULT_BUFFER_SIZE = 32768;
    public static final int CONTINUE_LOADING_PERCENTAGE = 75;

    private IoUtils() {
    }

    public static boolean copyStream(InputStream is, OutputStream os, CopyListener listener) throws IOException {
        return IoUtils.copyStream(is, os, listener, 32768);
    }

    public static boolean copyStream(InputStream is, OutputStream os, CopyListener listener, int bufferSize) throws IOException {
        int count;
        int current = 0;
        int total = is.available();
        byte[] bytes = new byte[bufferSize];
        if (IoUtils.shouldStopLoading(listener, current, total)) {
            return false;
        }
        while ((count = is.read(bytes, 0, bufferSize)) != -1) {
            os.write(bytes, 0, count);
            if (!IoUtils.shouldStopLoading(listener, current += count, total)) continue;
            return false;
        }
        return true;
    }

    private static boolean shouldStopLoading(CopyListener listener, int current, int total) {
        boolean shouldContinue;
        return listener != null && !(shouldContinue = listener.onBytesCopied(current, total)) && 100 * current / total < 75;
    }

    public static void closeSilently(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static interface CopyListener {
        public boolean onBytesCopied(int var1, int var2);
    }
}

