/*
 * Decompiled with CFR 0.152.
 */
package com.qq.taf.jce;

import com.qq.taf.jce.HexUtil;
import com.qq.taf.jce.JceEncodeException;
import com.qq.taf.jce.JceStruct;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JceOutputStream {
    private ByteBuffer bs;
    protected String sServerEncoding = "GBK";

    public JceOutputStream(ByteBuffer bs) {
        this.bs = bs;
    }

    public JceOutputStream(int capacity) {
        this.bs = ByteBuffer.allocate(capacity);
    }

    public JceOutputStream() {
        this(128);
    }

    public ByteBuffer getByteBuffer() {
        return this.bs;
    }

    public byte[] toByteArray() {
        byte[] newBytes = new byte[this.bs.position()];
        System.arraycopy(this.bs.array(), 0, newBytes, 0, this.bs.position());
        return newBytes;
    }

    public void reserve(int len) {
        if (this.bs.remaining() < len) {
            int n = (this.bs.capacity() + len) * 2;
            ByteBuffer bs2 = ByteBuffer.allocate(n);
            bs2.put(this.bs.array(), 0, this.bs.position());
            this.bs = bs2;
            Object var3_3 = null;
        }
    }

    public void writeHead(byte type, int tag) {
        if (tag < 15) {
            byte b = (byte)(tag << 4 | type);
            this.bs.put(b);
        } else if (tag < 256) {
            byte b = (byte)(0xF0 | type);
            this.bs.put(b);
            this.bs.put((byte)tag);
        } else {
            throw new JceEncodeException("tag is too large: " + tag);
        }
    }

    public void write(boolean b, int tag) {
        byte by = (byte)(b ? 1 : 0);
        this.write(by, tag);
    }

    public void write(byte b, int tag) {
        this.reserve(3);
        if (b == 0) {
            this.writeHead((byte)12, tag);
        } else {
            this.writeHead((byte)0, tag);
            this.bs.put(b);
        }
    }

    public void write(short n, int tag) {
        this.reserve(4);
        if (n >= -128 && n <= 127) {
            this.write((byte)n, tag);
        } else {
            this.writeHead((byte)1, tag);
            this.bs.putShort(n);
        }
    }

    public void write(int n, int tag) {
        this.reserve(6);
        if (n >= Short.MIN_VALUE && n <= Short.MAX_VALUE) {
            this.write((short)n, tag);
        } else {
            this.writeHead((byte)2, tag);
            this.bs.putInt(n);
        }
    }

    public void write(long n, int tag) {
        this.reserve(10);
        if (n >= Integer.MIN_VALUE && n <= Integer.MAX_VALUE) {
            this.write((int)n, tag);
        } else {
            this.writeHead((byte)3, tag);
            this.bs.putLong(n);
        }
    }

    public void write(float n, int tag) {
        this.reserve(6);
        this.writeHead((byte)4, tag);
        this.bs.putFloat(n);
    }

    public void write(double n, int tag) {
        this.reserve(10);
        this.writeHead((byte)5, tag);
        this.bs.putDouble(n);
    }

    public void writeStringByte(String s, int tag) {
        byte[] by = HexUtil.hexStr2Bytes(s);
        this.reserve(10 + by.length);
        if (by.length > 255) {
            this.writeHead((byte)7, tag);
            this.bs.putInt(by.length);
            this.bs.put(by);
        } else {
            this.writeHead((byte)6, tag);
            this.bs.put((byte)by.length);
            this.bs.put(by);
        }
    }

    public void writeByteString(String s, int tag) {
        this.reserve(10 + s.length());
        byte[] by = HexUtil.hexStr2Bytes(s);
        if (by.length > 255) {
            this.writeHead((byte)7, tag);
            this.bs.putInt(by.length);
            this.bs.put(by);
        } else {
            this.writeHead((byte)6, tag);
            this.bs.put((byte)by.length);
            this.bs.put(by);
        }
    }

    public void write(String s, int tag) {
        byte[] by;
        try {
            by = s.getBytes(this.sServerEncoding);
        }
        catch (UnsupportedEncodingException e) {
            by = s.getBytes();
        }
        this.reserve(10 + by.length);
        if (by.length > 255) {
            this.writeHead((byte)7, tag);
            this.bs.putInt(by.length);
            this.bs.put(by);
        } else {
            this.writeHead((byte)6, tag);
            this.bs.put((byte)by.length);
            this.bs.put(by);
        }
    }

    public <K, V> void write(Map<K, V> m, int tag) {
        this.reserve(8);
        this.writeHead((byte)8, tag);
        this.write(m == null ? 0 : m.size(), 0);
        if (m != null) {
            for (Map.Entry<K, V> en : m.entrySet()) {
                this.write(en.getKey(), 0);
                this.write(en.getValue(), 1);
            }
        }
    }

    public void write(boolean[] l, int tag) {
        this.reserve(8);
        this.writeHead((byte)9, tag);
        this.write(l.length, 0);
        for (boolean e : l) {
            this.write(e, 0);
        }
    }

    public void write(byte[] l, int tag) {
        this.reserve(8 + l.length);
        this.writeHead((byte)13, tag);
        this.writeHead((byte)0, 0);
        this.write(l.length, 0);
        this.bs.put(l);
    }

    public void write(short[] l, int tag) {
        this.reserve(8);
        this.writeHead((byte)9, tag);
        this.write(l.length, 0);
        for (short e : l) {
            this.write(e, 0);
        }
    }

    public void write(int[] l, int tag) {
        this.reserve(8);
        this.writeHead((byte)9, tag);
        this.write(l.length, 0);
        for (int e : l) {
            this.write(e, 0);
        }
    }

    public void write(long[] l, int tag) {
        this.reserve(8);
        this.writeHead((byte)9, tag);
        this.write(l.length, 0);
        for (long e : l) {
            this.write(e, 0);
        }
    }

    public void write(float[] l, int tag) {
        this.reserve(8);
        this.writeHead((byte)9, tag);
        this.write(l.length, 0);
        for (float e : l) {
            this.write(e, 0);
        }
    }

    public void write(double[] l, int tag) {
        this.reserve(8);
        this.writeHead((byte)9, tag);
        this.write(l.length, 0);
        for (double e : l) {
            this.write(e, 0);
        }
    }

    public <T> void write(T[] l, int tag) {
        this.writeArray(l, tag);
    }

    private void writeArray(Object[] l, int tag) {
        this.reserve(8);
        this.writeHead((byte)9, tag);
        this.write(l.length, 0);
        for (Object e : l) {
            this.write(e, 0);
        }
    }

    public <T> void write(Collection<T> l, int tag) {
        this.reserve(8);
        this.writeHead((byte)9, tag);
        this.write(l == null ? 0 : l.size(), 0);
        if (l != null) {
            for (T e : l) {
                this.write(e, 0);
            }
        }
    }

    public void write(JceStruct o, int tag) {
        this.reserve(2);
        this.writeHead((byte)10, tag);
        o.writeTo(this);
        this.reserve(2);
        this.writeHead((byte)11, 0);
    }

    public void write(Byte o, int tag) {
        this.write((byte)o, tag);
    }

    public void write(Boolean o, int tag) {
        this.write((boolean)o, tag);
    }

    public void write(Short o, int tag) {
        this.write((short)o, tag);
    }

    public void write(Integer o, int tag) {
        this.write((int)o, tag);
    }

    public void write(Long o, int tag) {
        this.write((long)o, tag);
    }

    public void write(Float o, int tag) {
        this.write(o.floatValue(), tag);
    }

    public void write(Double o, int tag) {
        this.write((double)o, tag);
    }

    public void write(Object o, int tag) {
        if (o instanceof Byte) {
            this.write((byte)((Byte)o), tag);
        } else if (o instanceof Boolean) {
            this.write((boolean)((Boolean)o), tag);
        } else if (o instanceof Short) {
            this.write((short)((Short)o), tag);
        } else if (o instanceof Integer) {
            this.write((int)((Integer)o), tag);
        } else if (o instanceof Long) {
            this.write((long)((Long)o), tag);
        } else if (o instanceof Float) {
            this.write(((Float)o).floatValue(), tag);
        } else if (o instanceof Double) {
            this.write((double)((Double)o), tag);
        } else if (o instanceof String) {
            this.write((String)o, tag);
        } else if (o instanceof Map) {
            this.write((Map)o, tag);
        } else if (o instanceof List) {
            this.write((List)o, tag);
        } else if (o instanceof JceStruct) {
            this.write((JceStruct)o, tag);
        } else if (o instanceof byte[]) {
            this.write((byte[])o, tag);
        } else if (o instanceof boolean[]) {
            this.write((boolean[])o, tag);
        } else if (o instanceof short[]) {
            this.write((short[])o, tag);
        } else if (o instanceof int[]) {
            this.write((int[])o, tag);
        } else if (o instanceof long[]) {
            this.write((long[])o, tag);
        } else if (o instanceof float[]) {
            this.write((float[])o, tag);
        } else if (o instanceof double[]) {
            this.write((double[])o, tag);
        } else if (o.getClass().isArray()) {
            this.writeArray((Object[])o, tag);
        } else if (o instanceof Collection) {
            this.write((Collection)o, tag);
        } else {
            throw new JceEncodeException("write object error: unsupport type. " + o.getClass());
        }
    }

    public int setServerEncoding(String se) {
        this.sServerEncoding = se;
        return 0;
    }

    public static void main(String[] args) {
        JceOutputStream os = new JceOutputStream();
        long n = 1311768467283714885L;
        os.write(n, 0);
        ByteBuffer bs = os.getByteBuffer();
        System.out.println(HexUtil.bytes2HexStr(bs.array()));
        System.out.println(Arrays.toString(os.toByteArray()));
    }
}

