/*
 * Decompiled with CFR 0.152.
 */
package com.lidroid.xutils.bitmap.core;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.media.ExifInterface;
import com.lidroid.xutils.BitmapUtils;
import com.lidroid.xutils.bitmap.BitmapDisplayConfig;
import com.lidroid.xutils.bitmap.BitmapGlobalConfig;
import com.lidroid.xutils.bitmap.core.BitmapDecoder;
import com.lidroid.xutils.bitmap.factory.BitmapFactory;
import com.lidroid.xutils.cache.FileNameGenerator;
import com.lidroid.xutils.cache.LruDiskCache;
import com.lidroid.xutils.cache.LruMemoryCache;
import com.lidroid.xutils.util.IOUtils;
import com.lidroid.xutils.util.LogUtils;
import com.lidroid.xutils.util.OtherUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class BitmapCache {
    private final int DISK_CACHE_INDEX = 0;
    private LruDiskCache mDiskLruCache;
    private LruMemoryCache<MemoryCacheKey, Bitmap> mMemoryCache;
    private final Object mDiskCacheLock = new Object();
    private BitmapGlobalConfig globalConfig;

    public BitmapCache(BitmapGlobalConfig globalConfig) {
        if (globalConfig == null) {
            throw new IllegalArgumentException("globalConfig may not be null");
        }
        this.globalConfig = globalConfig;
    }

    public void initMemoryCache() {
        if (!this.globalConfig.isMemoryCacheEnabled()) {
            return;
        }
        if (this.mMemoryCache != null) {
            try {
                this.clearMemoryCache();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.mMemoryCache = new LruMemoryCache<MemoryCacheKey, Bitmap>(this.globalConfig.getMemoryCacheSize()){

            @Override
            protected int sizeOf(MemoryCacheKey key, Bitmap bitmap) {
                if (bitmap == null) {
                    return 0;
                }
                return bitmap.getRowBytes() * bitmap.getHeight();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDiskCache() {
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            File diskCacheDir;
            if (this.globalConfig.isDiskCacheEnabled() && (this.mDiskLruCache == null || this.mDiskLruCache.isClosed()) && ((diskCacheDir = new File(this.globalConfig.getDiskCachePath())).exists() || diskCacheDir.mkdirs())) {
                long diskCacheSize;
                long availableSpace = OtherUtils.getAvailableSpace(diskCacheDir);
                diskCacheSize = availableSpace > (diskCacheSize = (long)this.globalConfig.getDiskCacheSize()) ? diskCacheSize : availableSpace;
                try {
                    this.mDiskLruCache = LruDiskCache.open(diskCacheDir, 1, 1, diskCacheSize);
                    this.mDiskLruCache.setFileNameGenerator(this.globalConfig.getFileNameGenerator());
                    LogUtils.d("create disk cache success");
                }
                catch (Throwable e) {
                    this.mDiskLruCache = null;
                    LogUtils.e("create disk cache error", e);
                }
            }
        }
    }

    public void setMemoryCacheSize(int maxSize) {
        if (this.mMemoryCache != null) {
            this.mMemoryCache.setMaxSize(maxSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDiskCacheSize(int maxSize) {
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            if (this.mDiskLruCache != null) {
                this.mDiskLruCache.setMaxSize(maxSize);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDiskCacheFileNameGenerator(FileNameGenerator fileNameGenerator) {
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            if (this.mDiskLruCache != null && fileNameGenerator != null) {
                this.mDiskLruCache.setFileNameGenerator(fileNameGenerator);
            }
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Bitmap downloadBitmap(String uri, BitmapDisplayConfig config, BitmapUtils.BitmapLoadTask<?> task) {
        block16: {
            block15: {
                block14: {
                    bitmapMeta = new BitmapMeta();
                    outputStream /* !! */  = null;
                    snapshot = null;
                    bitmap = null;
                    if (!this.globalConfig.isDiskCacheEnabled()) ** GOTO lbl36
                    if (this.mDiskLruCache == null) {
                        this.initDiskCache();
                    }
                    if (this.mDiskLruCache == null) ** GOTO lbl36
                    snapshot = this.mDiskLruCache.get(uri);
                    if (snapshot != null || (editor = this.mDiskLruCache.edit(uri)) == null) ** GOTO lbl26
                    outputStream /* !! */  = editor.newOutputStream(0);
                    bitmapMeta.expiryTimestamp = this.globalConfig.getDownloader().downloadToStream(uri, outputStream /* !! */ , task);
                    if (bitmapMeta.expiryTimestamp >= 0L) break block14;
                    editor.abort();
                    IOUtils.closeQuietly(outputStream /* !! */ );
                    IOUtils.closeQuietly(snapshot);
                    return null;
                }
                editor.setEntryExpiryTimestamp(bitmapMeta.expiryTimestamp);
                editor.commit();
                snapshot = this.mDiskLruCache.get(uri);
lbl26:
                // 2 sources

                if (snapshot != null) {
                    bitmapMeta.inputStream = snapshot.getInputStream(0);
                    bitmap = this.decodeBitmapMeta(bitmapMeta, config);
                    if (bitmap == null) {
                        bitmapMeta.inputStream = null;
                        this.mDiskLruCache.remove(uri);
                    }
                }
                {
                    catch (Throwable e) {
                        LogUtils.e(e.getMessage(), e);
                    }
                }
lbl36:
                // 4 sources

                if (bitmap != null) ** GOTO lbl47
                outputStream /* !! */  = new ByteArrayOutputStream();
                bitmapMeta.expiryTimestamp = this.globalConfig.getDownloader().downloadToStream(uri, outputStream /* !! */ , task);
                if (bitmapMeta.expiryTimestamp >= 0L) break block15;
                IOUtils.closeQuietly(outputStream /* !! */ );
                IOUtils.closeQuietly(snapshot);
                return null;
            }
            try {
                bitmapMeta.data = outputStream /* !! */ .toByteArray();
                bitmap = this.decodeBitmapMeta(bitmapMeta, config);
lbl47:
                // 2 sources

                if (bitmap != null) {
                    bitmap = this.rotateBitmapIfNeeded(uri, config, bitmap);
                    bitmap = this.addBitmapToMemoryCache(uri, config, bitmap, bitmapMeta.expiryTimestamp);
                }
                var10_11 = bitmap;
            }
            catch (Throwable e) {
                try {
                    LogUtils.e(e.getMessage(), e);
                    break block16;
                }
                catch (Throwable var9_12) {
                    throw var9_12;
                }
                finally {
                    IOUtils.closeQuietly(outputStream /* !! */ );
                    IOUtils.closeQuietly(snapshot);
                }
            }
            IOUtils.closeQuietly(outputStream /* !! */ );
            IOUtils.closeQuietly(snapshot);
            return var10_11;
        }
        return null;
    }

    private Bitmap addBitmapToMemoryCache(String uri, BitmapDisplayConfig config, Bitmap bitmap, long expiryTimestamp) throws IOException {
        BitmapFactory bitmapFactory;
        if (config != null && (bitmapFactory = config.getBitmapFactory()) != null) {
            bitmap = bitmapFactory.cloneNew().createBitmap(bitmap);
        }
        if (uri != null && bitmap != null && this.globalConfig.isMemoryCacheEnabled() && this.mMemoryCache != null) {
            MemoryCacheKey key = new MemoryCacheKey(uri, config);
            this.mMemoryCache.put(key, bitmap, expiryTimestamp);
        }
        return bitmap;
    }

    public Bitmap getBitmapFromMemCache(String uri, BitmapDisplayConfig config) {
        if (this.mMemoryCache != null && this.globalConfig.isMemoryCacheEnabled()) {
            MemoryCacheKey key = new MemoryCacheKey(uri, config);
            return this.mMemoryCache.get(key);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getBitmapFileFromDiskCache(String uri) {
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            if (this.mDiskLruCache != null) {
                return this.mDiskLruCache.getCacheFile(uri, 0);
            }
            return null;
        }
    }

    public Bitmap getBitmapFromDiskCache(String uri, BitmapDisplayConfig config) {
        block8: {
            if (uri == null || !this.globalConfig.isDiskCacheEnabled()) {
                return null;
            }
            if (this.mDiskLruCache == null) {
                this.initDiskCache();
            }
            if (this.mDiskLruCache != null) {
                LruDiskCache.Snapshot snapshot;
                block7: {
                    Bitmap bitmap;
                    snapshot = null;
                    try {
                        snapshot = this.mDiskLruCache.get(uri);
                        if (snapshot == null) break block7;
                        Bitmap bitmap2 = null;
                        bitmap2 = config == null || config.isShowOriginal() ? BitmapDecoder.decodeFileDescriptor(snapshot.getInputStream(0).getFD()) : BitmapDecoder.decodeSampledBitmapFromDescriptor(snapshot.getInputStream(0).getFD(), config.getBitmapMaxSize(), config.getBitmapConfig());
                        bitmap2 = this.rotateBitmapIfNeeded(uri, config, bitmap2);
                        bitmap = bitmap2 = this.addBitmapToMemoryCache(uri, config, bitmap2, this.mDiskLruCache.getExpiryTimestamp(uri));
                    }
                    catch (Throwable e) {
                        try {
                            LogUtils.e(e.getMessage(), e);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(snapshot);
                            throw throwable;
                        }
                        IOUtils.closeQuietly(snapshot);
                        break block8;
                    }
                    IOUtils.closeQuietly(snapshot);
                    return bitmap;
                }
                IOUtils.closeQuietly(snapshot);
            }
        }
        return null;
    }

    public void clearCache() {
        this.clearMemoryCache();
        this.clearDiskCache();
    }

    public void clearMemoryCache() {
        if (this.mMemoryCache != null) {
            this.mMemoryCache.evictAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDiskCache() {
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            if (this.mDiskLruCache != null && !this.mDiskLruCache.isClosed()) {
                try {
                    this.mDiskLruCache.delete();
                    this.mDiskLruCache.close();
                }
                catch (Throwable e) {
                    LogUtils.e(e.getMessage(), e);
                }
                this.mDiskLruCache = null;
            }
        }
        this.initDiskCache();
    }

    public void clearCache(String uri) {
        this.clearMemoryCache(uri);
        this.clearDiskCache(uri);
    }

    public void clearMemoryCache(String uri) {
        MemoryCacheKey key = new MemoryCacheKey(uri, null);
        if (this.mMemoryCache != null) {
            while (this.mMemoryCache.containsKey(key)) {
                this.mMemoryCache.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDiskCache(String uri) {
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            if (this.mDiskLruCache != null && !this.mDiskLruCache.isClosed()) {
                try {
                    this.mDiskLruCache.remove(uri);
                }
                catch (Throwable e) {
                    LogUtils.e(e.getMessage(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            if (this.mDiskLruCache != null) {
                try {
                    this.mDiskLruCache.flush();
                }
                catch (Throwable e) {
                    LogUtils.e(e.getMessage(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            if (this.mDiskLruCache != null) {
                try {
                    if (!this.mDiskLruCache.isClosed()) {
                        this.mDiskLruCache.close();
                    }
                }
                catch (Throwable e) {
                    LogUtils.e(e.getMessage(), e);
                }
                this.mDiskLruCache = null;
            }
        }
    }

    private Bitmap decodeBitmapMeta(BitmapMeta bitmapMeta, BitmapDisplayConfig config) throws IOException {
        if (bitmapMeta == null) {
            return null;
        }
        Bitmap bitmap = null;
        if (bitmapMeta.inputStream != null) {
            bitmap = config == null || config.isShowOriginal() ? BitmapDecoder.decodeFileDescriptor(bitmapMeta.inputStream.getFD()) : BitmapDecoder.decodeSampledBitmapFromDescriptor(bitmapMeta.inputStream.getFD(), config.getBitmapMaxSize(), config.getBitmapConfig());
        } else if (bitmapMeta.data != null) {
            bitmap = config == null || config.isShowOriginal() ? BitmapDecoder.decodeByteArray(bitmapMeta.data) : BitmapDecoder.decodeSampledBitmapFromByteArray(bitmapMeta.data, config.getBitmapMaxSize(), config.getBitmapConfig());
        }
        return bitmap;
    }

    private synchronized Bitmap rotateBitmapIfNeeded(String uri, BitmapDisplayConfig config, Bitmap bitmap) {
        File bitmapFile;
        Bitmap result = bitmap;
        if (config != null && config.isAutoRotation() && (bitmapFile = this.getBitmapFileFromDiskCache(uri)) != null && bitmapFile.exists()) {
            ExifInterface exif = null;
            try {
                exif = new ExifInterface(bitmapFile.getPath());
            }
            catch (Throwable e) {
                return result;
            }
            int orientation = exif.getAttributeInt("Orientation", 0);
            int angle = 0;
            switch (orientation) {
                case 6: {
                    angle = 90;
                    break;
                }
                case 3: {
                    angle = 180;
                    break;
                }
                case 8: {
                    angle = 270;
                    break;
                }
                default: {
                    angle = 0;
                }
            }
            if (angle != 0) {
                Matrix m = new Matrix();
                m.postRotate((float)angle);
                result = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)m, (boolean)true);
                bitmap.recycle();
                bitmap = null;
            }
        }
        return result;
    }

    private class BitmapMeta {
        public FileInputStream inputStream;
        public byte[] data;
        public long expiryTimestamp;

        private BitmapMeta() {
        }
    }

    public class MemoryCacheKey {
        private String uri;
        private String subKey;

        private MemoryCacheKey(String uri, BitmapDisplayConfig config) {
            this.uri = uri;
            this.subKey = config == null ? null : config.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MemoryCacheKey)) {
                return false;
            }
            MemoryCacheKey that = (MemoryCacheKey)o;
            if (!this.uri.equals(that.uri)) {
                return false;
            }
            if (this.subKey != null && that.subKey != null) {
                return this.subKey.equals(that.subKey);
            }
            return true;
        }

        public int hashCode() {
            return this.uri.hashCode();
        }
    }
}

