/*
 * Decompiled with CFR 0.152.
 */
package m.framework.network;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.UUID;
import m.framework.network.FilePart;
import m.framework.network.HTTPPart;
import m.framework.network.KVPair;
import m.framework.network.MultiPart;
import m.framework.network.ResponseCallback;
import m.framework.network.SSLSocketFactoryEx;
import m.framework.network.StringPart;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.util.EntityUtils;

public class NetworkHelper {
    public static int connectionTimeout;
    public static int readTimout;

    public String httpGet(String url, ArrayList<KVPair<String>> values, ArrayList<KVPair<String>> headers) throws Throwable {
        String param;
        if (values != null && (param = this.kvPairsToUrl(values)).length() > 0) {
            url = String.valueOf(url) + "?" + param;
        }
        HttpGet get = new HttpGet(url);
        if (headers != null) {
            for (KVPair<String> header : headers) {
                get.setHeader(header.name, (String)header.value);
            }
        }
        BasicHttpParams httpParams = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)connectionTimeout);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)readTimout);
        get.setParams((HttpParams)httpParams);
        Object client = null;
        client = url.startsWith("https://") ? this.getSSLHttpClient() : new DefaultHttpClient();
        HttpResponse response = client.execute((HttpUriRequest)get);
        int status = response.getStatusLine().getStatusCode();
        String resp = null;
        if (status != 200) {
            String error = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
            client.getConnectionManager().shutdown();
            throw new Throwable(error);
        }
        resp = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
        client.getConnectionManager().shutdown();
        return resp;
    }

    public void httpGet(String url, ArrayList<KVPair<String>> values, ArrayList<KVPair<String>> headers, ResponseCallback callback) throws Throwable {
        InputStream is;
        String param;
        if (values != null && (param = this.kvPairsToUrl(values)).length() > 0) {
            url = String.valueOf(url) + "?" + param;
        }
        HttpGet get = new HttpGet(url);
        if (headers != null) {
            for (KVPair<String> header : headers) {
                get.setHeader(header.name, (String)header.value);
            }
        }
        BasicHttpParams httpParams = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)connectionTimeout);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)readTimout);
        get.setParams((HttpParams)httpParams);
        Object client = null;
        client = url.startsWith("https://") ? this.getSSLHttpClient() : new DefaultHttpClient();
        HttpResponse response = client.execute((HttpUriRequest)get);
        int status = response.getStatusLine().getStatusCode();
        if (status == 200) {
            is = response.getEntity().getContent();
            if (callback != null) {
                callback.onResponse(is);
            }
        } else {
            String error = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
            client.getConnectionManager().shutdown();
            throw new Throwable(error);
        }
        is.close();
        client.getConnectionManager().shutdown();
    }

    public void download(String url, File file) throws Throwable {
        FileOutputStream fos;
        InputStream is;
        HttpGet get = new HttpGet(url);
        Object client = null;
        client = url.startsWith("https://") ? this.getSSLHttpClient() : new DefaultHttpClient();
        HttpResponse response = client.execute((HttpUriRequest)get);
        int status = response.getStatusLine().getStatusCode();
        if (status == 200) {
            is = response.getEntity().getContent();
            fos = new FileOutputStream(file);
            byte[] buf = new byte[1024];
            int len = is.read(buf);
            while (len > 0) {
                fos.write(buf, 0, len);
                len = is.read(buf);
            }
        } else {
            String error = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
            client.getConnectionManager().shutdown();
            throw new Throwable(error);
        }
        fos.flush();
        is.close();
        fos.close();
        client.getConnectionManager().shutdown();
    }

    public void download(String url, ResponseCallback callback) throws Throwable {
        InputStream is;
        HttpGet get = new HttpGet(url);
        Object client = null;
        client = url.startsWith("https://") ? this.getSSLHttpClient() : new DefaultHttpClient();
        HttpResponse response = client.execute((HttpUriRequest)get);
        int status = response.getStatusLine().getStatusCode();
        if (status == 200) {
            is = response.getEntity().getContent();
            if (callback != null) {
                callback.onResponse(is);
            }
        } else {
            String error = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
            client.getConnectionManager().shutdown();
            throw new Throwable(error);
        }
        is.close();
        client.getConnectionManager().shutdown();
    }

    public String httpPost(String url, ArrayList<KVPair<String>> values, KVPair<String> file, ArrayList<KVPair<String>> headers) throws Throwable {
        HttpPost post = file != null && file.value != null && new File((String)file.value).exists() ? this.filePost(url, values, file) : this.textPost(url, values);
        if (headers != null) {
            for (KVPair<String> header : headers) {
                post.setHeader(header.name, (String)header.value);
            }
        }
        BasicHttpParams httpParams = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)connectionTimeout);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)readTimout);
        post.setParams((HttpParams)httpParams);
        Object client = null;
        client = url.startsWith("https://") ? this.getSSLHttpClient() : new DefaultHttpClient();
        HttpResponse httpResponse = client.execute((HttpUriRequest)post);
        int status = httpResponse.getStatusLine().getStatusCode();
        String resp = null;
        if (status != 200 && status != 201) {
            String error = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"utf-8");
            client.getConnectionManager().shutdown();
            throw new Throwable(error);
        }
        resp = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"utf-8");
        client.getConnectionManager().shutdown();
        return resp;
    }

    public void httpPost(String url, ArrayList<KVPair<String>> values, KVPair<String> file, ArrayList<KVPair<String>> headers, ResponseCallback callback) throws Throwable {
        InputStream is;
        HttpPost post = file != null && file.value != null && new File((String)file.value).exists() ? this.filePost(url, values, file) : this.textPost(url, values);
        if (headers != null) {
            for (KVPair<String> header : headers) {
                post.setHeader(header.name, (String)header.value);
            }
        }
        BasicHttpParams httpParams = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)connectionTimeout);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)readTimout);
        post.setParams((HttpParams)httpParams);
        Object client = null;
        client = url.startsWith("https://") ? this.getSSLHttpClient() : new DefaultHttpClient();
        HttpResponse httpResponse = client.execute((HttpUriRequest)post);
        int status = httpResponse.getStatusLine().getStatusCode();
        if (status == 200 || status == 201) {
            is = httpResponse.getEntity().getContent();
            if (callback != null) {
                callback.onResponse(is);
            }
        } else {
            String error = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"utf-8");
            client.getConnectionManager().shutdown();
            throw new Throwable(error);
        }
        is.close();
        client.getConnectionManager().shutdown();
    }

    private HttpPost filePost(String url, ArrayList<KVPair<String>> values, KVPair<String> file) throws Throwable {
        HttpPost post = new HttpPost(url);
        String boundary = UUID.randomUUID().toString();
        MultiPart mp = new MultiPart();
        StringPart sp = new StringPart();
        if (values != null) {
            for (KVPair<String> value : values) {
                sp.append("--").append(boundary).append("\r\n");
                sp.append("content-disposition: form-data; name=\"").append(value.name).append("\"\r\n\r\n");
                sp.append((String)value.value).append("\r\n");
            }
        }
        post.setHeader("Content-Type", "multipart/form-data; boundary=" + boundary);
        sp.append("--").append(boundary).append("\r\n");
        File imageFile = new File((String)file.value);
        sp.append("Content-Disposition: form-data; name=\"").append(file.name).append("\"; filename=\"").append(imageFile.getName()).append("\"\r\n");
        String mime = URLConnection.getFileNameMap().getContentTypeFor((String)file.value);
        if (mime == null || mime.length() <= 0) {
            if (((String)file.value).toLowerCase().endsWith("jpg") || ((String)file.value).toLowerCase().endsWith("jepg")) {
                mime = "image/jpeg";
            } else if (((String)file.value).toLowerCase().endsWith("png")) {
                mime = "image/png";
            } else if (((String)file.value).toLowerCase().endsWith("gif")) {
                mime = "image/gif";
            } else {
                FileInputStream fis = new FileInputStream((String)file.value);
                mime = URLConnection.guessContentTypeFromStream(fis);
                fis.close();
                if (mime == null || mime.length() <= 0) {
                    mime = "application/octet-stream";
                }
            }
        }
        sp.append("Content-Type: ").append(mime).append("\r\n\r\n");
        mp.append(sp);
        FilePart fp = new FilePart();
        fp.setFile((String)file.value);
        mp.append(fp);
        sp = new StringPart();
        sp.append("\r\n--").append(boundary).append("--\r\n");
        mp.append(sp);
        post.setEntity((HttpEntity)mp.getInputStreamEntity());
        return post;
    }

    private HttpPost textPost(String url, ArrayList<KVPair<String>> values) throws Throwable {
        HttpPost post = new HttpPost(url);
        if (values != null) {
            StringPart sp = new StringPart();
            sp.append(this.kvPairsToUrl(values));
            InputStreamEntity entity = sp.getInputStreamEntity();
            entity.setContentType("application/x-www-form-urlencoded");
            post.setEntity((HttpEntity)entity);
        }
        return post;
    }

    public void rawPost(String url, ArrayList<KVPair<String>> headers, HTTPPart data, ResponseCallback callback) throws Throwable {
        HttpPost post = new HttpPost(url);
        if (headers != null) {
            for (KVPair<String> header : headers) {
                post.setHeader(header.name, (String)header.value);
            }
        }
        post.setEntity((HttpEntity)data.getInputStreamEntity());
        Object client = null;
        client = url.startsWith("https://") ? this.getSSLHttpClient() : new DefaultHttpClient();
        HttpResponse httpResponse = client.execute((HttpUriRequest)post);
        int status = httpResponse.getStatusLine().getStatusCode();
        if (status == 200) {
            InputStream is = httpResponse.getEntity().getContent();
            if (callback != null) {
                callback.onResponse(is);
            }
            is.close();
            client.getConnectionManager().shutdown();
        }
        String error = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"utf-8");
        client.getConnectionManager().shutdown();
        throw new Throwable(error);
    }

    public String httpPut(String url, ArrayList<KVPair<String>> values, KVPair<String> file, ArrayList<KVPair<String>> headers) throws Throwable {
        String param;
        if (values != null && (param = this.kvPairsToUrl(values)).length() > 0) {
            url = String.valueOf(url) + "?" + param;
        }
        HttpPut put = new HttpPut(url);
        if (headers != null) {
            for (KVPair<String> header : headers) {
                put.setHeader(header.name, (String)header.value);
            }
        }
        FilePart fp = new FilePart();
        fp.setFile((String)file.value);
        InputStreamEntity entity = fp.getInputStreamEntity();
        entity.setContentEncoding("application/octet-stream");
        put.setEntity((HttpEntity)entity);
        BasicHttpParams httpParams = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)connectionTimeout);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)readTimout);
        put.setParams((HttpParams)httpParams);
        Object client = null;
        client = url.startsWith("https://") ? this.getSSLHttpClient() : new DefaultHttpClient();
        HttpResponse httpResponse = client.execute((HttpUriRequest)put);
        int status = httpResponse.getStatusLine().getStatusCode();
        String resp = null;
        if (status != 200 && status != 201) {
            String error = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"utf-8");
            client.getConnectionManager().shutdown();
            throw new Throwable(error);
        }
        resp = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"utf-8");
        client.getConnectionManager().shutdown();
        return resp;
    }

    private String kvPairsToUrl(ArrayList<KVPair<String>> values) throws Throwable {
        StringBuilder sb = new StringBuilder();
        for (KVPair<String> value : values) {
            String encodedValue;
            String encodedName = URLEncoder.encode(value.name, "utf-8");
            String string = encodedValue = value.value != null ? URLEncoder.encode((String)value.value, "utf-8") : "";
            if (sb.length() > 0) {
                sb.append('&');
            }
            sb.append(encodedName).append('=').append(encodedValue);
        }
        return sb.toString();
    }

    private HttpClient getSSLHttpClient() throws Throwable {
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        trustStore.load(null, null);
        SSLSocketFactoryEx sf = new SSLSocketFactoryEx(trustStore);
        sf.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        BasicHttpParams params = new BasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset((HttpParams)params, (String)"UTF-8");
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        registry.register(new Scheme("https", (SocketFactory)sf, 443));
        ThreadSafeClientConnManager ccm = new ThreadSafeClientConnManager((HttpParams)params, registry);
        return new DefaultHttpClient((ClientConnectionManager)ccm, (HttpParams)params);
    }
}

