/*
 * Decompiled with CFR 0.152.
 */
package m.framework.ui.widget.pulltorefresh;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import m.framework.ui.widget.pulltorefresh.PullToRefreshAdatper;

public class PullToRefreshView
extends RelativeLayout {
    private static final long MIN_REF_TIME = 1000L;
    private PullToRefreshAdatper adapter;
    private View headerView;
    private View bodyView;
    private int headerHeight;
    private int top;
    private float downY;
    private boolean requesting;
    private boolean pullingLock;
    private Runnable stopAct;
    private long refreshTime;

    public PullToRefreshView(Context context) {
        super(context);
        this.init();
    }

    public PullToRefreshView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public PullToRefreshView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        this.stopAct = new Runnable(){

            @Override
            public void run() {
                PullToRefreshView.this.reversePulling();
                PullToRefreshView.this.stopRequest();
            }
        };
    }

    public void setAdapter(PullToRefreshAdatper adapter) {
        this.adapter = adapter;
        this.removeAllViews();
        this.bodyView = (View)adapter.getBodyView();
        RelativeLayout.LayoutParams lpBody = new RelativeLayout.LayoutParams(-2, -2);
        lpBody.addRule(9, -1);
        lpBody.addRule(11, -1);
        lpBody.addRule(10, -1);
        this.addView(this.bodyView, (ViewGroup.LayoutParams)lpBody);
        this.headerView = adapter.getHeaderView();
        this.headerView.measure(0, 0);
        this.headerHeight = this.headerView.getMeasuredHeight();
        RelativeLayout.LayoutParams lpHead = new RelativeLayout.LayoutParams(-2, this.headerHeight);
        lpHead.addRule(9, -1);
        lpHead.addRule(11, -1);
        lpHead.addRule(10, -1);
        lpHead.topMargin = -this.headerHeight;
        this.addView(this.headerView, (ViewGroup.LayoutParams)lpHead);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                this.downY = ev.getY();
                break;
            }
            case 2: {
                float curY = ev.getY();
                if (this.requesting || this.canPull()) {
                    this.top = (int)((float)this.top + (curY - this.downY) / 2.0f);
                    if (this.top > 0) {
                        this.scrollTo(0, -this.top);
                        if (!this.requesting && this.adapter != null) {
                            this.adapter.onPullDown(this.top * 100 / this.headerHeight);
                        }
                        ev = this.getCancelEvent(ev);
                    } else {
                        this.top = 0;
                        this.scrollTo(0, 0);
                    }
                }
                this.downY = curY;
                break;
            }
            case 1: 
            case 3: {
                if (!this.requesting) {
                    if (this.top > this.headerHeight) {
                        this.top = this.headerHeight;
                        this.scrollTo(0, -this.top);
                        if (this.adapter != null) {
                            this.adapter.onPullDown(100);
                        }
                        this.performRequest();
                        ev = this.getCancelEvent(ev);
                        break;
                    }
                    if (this.top == 0) break;
                    this.reversePulling();
                    if (this.adapter == null) break;
                    this.adapter.onPullDown(0);
                    break;
                }
                this.top = this.headerHeight;
                this.scrollTo(0, -this.top);
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    private MotionEvent getCancelEvent(MotionEvent ev) {
        return MotionEvent.obtain((long)ev.getDownTime(), (long)ev.getEventTime(), (int)3, (float)ev.getX(), (float)ev.getY(), (int)ev.getMetaState());
    }

    private void performRequest() {
        this.refreshTime = System.currentTimeMillis();
        this.requesting = true;
        if (this.adapter != null) {
            this.adapter.onRequest();
        }
    }

    private void stopRequest() {
        this.requesting = false;
    }

    public void performPulling(boolean request) {
        this.top = this.headerHeight;
        this.scrollTo(0, -this.top);
        if (request) {
            this.performRequest();
        }
    }

    private void reversePulling() {
        this.top = 0;
        this.scrollTo(0, 0);
        if (this.adapter != null) {
            this.adapter.onReversed();
        }
    }

    public void stopPulling() {
        long curTime = System.currentTimeMillis();
        long delta = curTime - this.refreshTime;
        if (delta < 1000L) {
            this.postDelayed(this.stopAct, 1000L - delta);
        } else {
            this.post(this.stopAct);
        }
    }

    public void lockPulling() {
        this.pullingLock = true;
    }

    public void releaseLock() {
        this.pullingLock = false;
    }

    private boolean canPull() {
        return !this.pullingLock && this.adapter.isPullReady();
    }
}

