/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.security.mobile.module.commonutils.crypto;

import com.alipay.security.mobile.module.commonutils.crypto.ByteUtil;
import com.alipay.security.mobile.module.commonutils.crypto.CryptoUtil;
import com.alipay.security.mobile.module.commonutils.crypto.Hex;

public final class HotpExUtil {
    public static final byte[] salt1 = Hex.decode("7B726A5DDD72CBF8D1700FB6EB278AFD7559C40A3761E5A71614D0AC9461ED8EE9F6AAEB443CD648");
    public static final byte[] salt2 = Hex.decode("C9582A82777392CAA65AD7F5228150E3F966C09D6A00288B5C6E0CFB441E111B713B4E0822A8C830");
    public static final int MAX_CODE_LEN = 8;
    public static final int HOTPEX_HASH_LEN = 20;

    private HotpExUtil() {
    }

    public static byte[] process(byte[] byArray) {
        byte[] byArray2 = new byte[20];
        if (!ByteUtil.initWithByte(byArray2, (byte)0, 0, 20)) {
            throw new IllegalStateException("failed to init hash1.");
        }
        byte[] byArray3 = new byte[20];
        if (!ByteUtil.initWithByte(byArray3, (byte)0, 0, 20)) {
            throw new IllegalStateException("failed to init hash2.");
        }
        byte[] byArray4 = CryptoUtil.digestWithHmacSha1(byArray, salt1);
        System.arraycopy(byArray4, 0, byArray2, 0, byArray4.length);
        byArray = CryptoUtil.digestWithHmacSha1(byArray, salt2);
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        byArray = new byte[8];
        int n2 = byArray2[19] & 0xF;
        byArray[3] = (byte)(byArray2[n2] & 0x7F);
        byArray[2] = (byte)(byArray2[n2 + 1] & 0xFF);
        byArray[1] = (byte)(byArray2[n2 + 2] & 0xFF);
        byArray[0] = (byte)(byArray2[n2 + 3] & 0xFF);
        n2 = byArray3[19] & 0xF;
        byArray[4] = (byte)(byArray3[n2] & 0x7F);
        byArray[5] = (byte)(byArray3[n2 + 1] & 0xFF);
        byArray[6] = (byte)(byArray3[n2 + 2] & 0xFF);
        byArray[7] = (byte)(byArray3[n2 + 3] & 0xFF);
        return byArray;
    }

    public static byte[] process(byte[] byArray, int n2) {
        if ((byArray = HotpExUtil.process(byArray)) == null) {
            return null;
        }
        if (n2 <= 0) {
            return null;
        }
        if (n2 >= 8) {
            return byArray;
        }
        byte[] byArray2 = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray2[i2] = byArray[i2];
        }
        return byArray2;
    }
}

