/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.security.mobile.module.deviceinfo;

import android.content.ContentResolver;
import android.content.Context;
import android.net.ConnectivityManager;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import com.alipay.security.mobile.module.commonutils.CommonUtils;
import java.io.File;

public class EnvironmentInfo {
    private static EnvironmentInfo a = new EnvironmentInfo();

    private EnvironmentInfo() {
    }

    public static EnvironmentInfo getInstance() {
        return a;
    }

    public String getOSName() {
        return "android";
    }

    public boolean isRooted() {
        String[] stringArray = new String[]{"/system/bin/", "/system/xbin/", "/system/sbin/", "/sbin/", "/vendor/bin/"};
        try {
            for (int i2 = 0; i2 < 5; ++i2) {
                if (!new File(stringArray[i2] + "su").exists()) continue;
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public boolean isEmulator(Context context) {
        try {
            if (Build.HARDWARE.contains("goldfish") || Build.PRODUCT.contains("sdk") || Build.FINGERPRINT.contains("generic")) {
                return true;
            }
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            if (telephonyManager != null && CommonUtils.isZero(telephonyManager.getDeviceId())) {
                return true;
            }
            return CommonUtils.isBlank(Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id"));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getProductBoard() {
        return Build.BOARD;
    }

    public String getProductBrand() {
        return Build.BRAND;
    }

    public String getProductDevice() {
        return Build.DEVICE;
    }

    public String getBuildDisplayId() {
        return Build.DISPLAY;
    }

    public String getBuildVersionIncremental() {
        return Build.VERSION.INCREMENTAL;
    }

    public String getProductManufacturer() {
        return Build.MANUFACTURER;
    }

    public String getProductModel() {
        return Build.MODEL;
    }

    public String getProductName() {
        return Build.PRODUCT;
    }

    public String getBuildVersionRelease() {
        return Build.VERSION.RELEASE;
    }

    public String getBuildVersionSDK() {
        return Build.VERSION.SDK;
    }

    public String getBuildTags() {
        return Build.TAGS;
    }

    public String getKernelQemu() {
        return EnvironmentInfo.a("ro.kernel.qemu", "0");
    }

    public String getNetworkConnectionType(Context context) {
        try {
            context = (ConnectivityManager)context.getSystemService("connectivity");
            if (context.getActiveNetworkInfo().isConnected()) {
                if (CommonUtils.equalsIgnoreCase(context.getActiveNetworkInfo().getTypeName(), "WIFI")) {
                    return "WIFI";
                }
                return context.getActiveNetworkInfo().getExtraInfo();
            }
        }
        catch (Exception exception) {}
        return "";
    }

    public String getGsmSimState() {
        return EnvironmentInfo.a("gsm.sim.state", "");
    }

    public String getGsmSimState2() {
        return EnvironmentInfo.a("gsm.sim.state.2", "");
    }

    public String getWifiInterface() {
        return EnvironmentInfo.a("wifi.interface", "");
    }

    public String getUsbState() {
        return EnvironmentInfo.a("sys.usb.state", "");
    }

    private static String a(String string, String string2) {
        try {
            return (String)Class.forName("android.os.SystemProperties").getMethod("get", String.class, String.class).invoke(null, string, string2);
        }
        catch (Exception exception) {
            return string2;
        }
    }
}

