/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.adaptivestreaming;

import com.coremedia.iso.boxes.OriginalFormatBox;
import com.coremedia.iso.boxes.TimeToSampleBox;
import com.coremedia.iso.boxes.sampleentry.AbstractSampleEntry;
import com.googlecode.mp4parser.authoring.Movie;
import com.googlecode.mp4parser.authoring.Sample;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.adaptivestreaming.ManifestWriter;
import com.googlecode.mp4parser.authoring.builder.FragmentIntersectionFinder;
import com.googlecode.mp4parser.util.CastUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Logger;

public abstract class AbstractManifestWriter
implements ManifestWriter {
    private static final Logger LOG = Logger.getLogger(AbstractManifestWriter.class.getName());
    private FragmentIntersectionFinder intersectionFinder;
    protected long[] audioFragmentsDurations;
    protected long[] videoFragmentsDurations;

    protected AbstractManifestWriter(FragmentIntersectionFinder intersectionFinder) {
        this.intersectionFinder = intersectionFinder;
    }

    public long[] calculateFragmentDurations(Track track, Movie movie) {
        long[] startSamples = this.intersectionFinder.sampleNumbers(track, movie);
        long[] durations = new long[startSamples.length];
        int currentFragment = 0;
        int currentSample = 1;
        for (TimeToSampleBox.Entry entry : track.getDecodingTimeEntries()) {
            int max = currentSample + CastUtils.l2i(entry.getCount());
            while (currentSample < max) {
                if (currentFragment == startSamples.length - 1 || (long)currentSample == startSamples[currentFragment + 1]) {
                    // empty if block
                }
                int n = ++currentFragment;
                durations[n] = durations[n] + entry.getDelta();
                ++currentSample;
            }
        }
        return durations;
    }

    public long getBitrate(Track track) {
        long bitrate = 0L;
        for (Sample sample : track.getSamples()) {
            bitrate += sample.remaining();
        }
        bitrate *= 8L;
        bitrate = (long)((double)bitrate / ((double)AbstractManifestWriter.getDuration(track) / (double)track.getTrackMetaData().getTimescale()));
        return bitrate;
    }

    protected static long getDuration(Track track) {
        long duration = 0L;
        for (TimeToSampleBox.Entry entry : track.getDecodingTimeEntries()) {
            duration += entry.getCount() * entry.getDelta();
        }
        return duration;
    }

    protected long[] checkFragmentsAlign(long[] referenceTimes, long[] checkTimes) throws IOException {
        if (referenceTimes == null || referenceTimes.length == 0) {
            return checkTimes;
        }
        long[] referenceTimesMinusLast = new long[referenceTimes.length - 1];
        System.arraycopy(referenceTimes, 0, referenceTimesMinusLast, 0, referenceTimes.length - 1);
        long[] checkTimesMinusLast = new long[checkTimes.length - 1];
        System.arraycopy(checkTimes, 0, checkTimesMinusLast, 0, checkTimes.length - 1);
        if (!Arrays.equals(checkTimesMinusLast, referenceTimesMinusLast)) {
            long l;
            String log = "";
            log = String.valueOf(log) + referenceTimes.length;
            log = String.valueOf(log) + "Reference     :  [";
            long[] lArray = referenceTimes;
            int n = referenceTimes.length;
            int n2 = 0;
            while (n2 < n) {
                l = lArray[n2];
                log = String.valueOf(log) + String.format("%10d,", l);
                ++n2;
            }
            log = String.valueOf(log) + "]";
            LOG.warning(log);
            log = "";
            log = String.valueOf(log) + checkTimes.length;
            log = String.valueOf(log) + "Current       :  [";
            lArray = checkTimes;
            n = checkTimes.length;
            n2 = 0;
            while (n2 < n) {
                l = lArray[n2];
                log = String.valueOf(log) + String.format("%10d,", l);
                ++n2;
            }
            log = String.valueOf(log) + "]";
            LOG.warning(log);
            throw new IOException("Track does not have the same fragment borders as its predecessor.");
        }
        return checkTimes;
    }

    protected String getFormat(AbstractSampleEntry se) {
        String type = se.getType();
        if (type.equals("encv") || type.equals("enca") || type.equals("encv")) {
            OriginalFormatBox frma = se.getBoxes(OriginalFormatBox.class, true).get(0);
            type = frma.getDataFormat();
        }
        return type;
    }
}

