/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.builder;

import com.coremedia.iso.boxes.TimeToSampleBox;
import com.googlecode.mp4parser.authoring.Movie;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.builder.FragmentIntersectionFinder;
import java.util.Arrays;
import java.util.List;

public class TwoSecondIntersectionFinder
implements FragmentIntersectionFinder {
    private int fragmentLength = 2;

    public TwoSecondIntersectionFinder() {
    }

    public TwoSecondIntersectionFinder(int fragmentLength) {
        this.fragmentLength = fragmentLength;
    }

    protected long getDuration(Track track) {
        long duration = 0L;
        for (TimeToSampleBox.Entry entry : track.getDecodingTimeEntries()) {
            duration += entry.getCount() * entry.getDelta();
        }
        return duration;
    }

    public long[] sampleNumbers(Track track, Movie movie) {
        int i;
        List<TimeToSampleBox.Entry> entries = track.getDecodingTimeEntries();
        double trackLength = 0.0;
        for (Track thisTrack : movie.getTracks()) {
            double thisTracksLength = this.getDuration(thisTrack) / thisTrack.getTrackMetaData().getTimescale();
            if (!(trackLength < thisTracksLength)) continue;
            trackLength = thisTracksLength;
        }
        int fragmentCount = (int)Math.ceil(trackLength / (double)this.fragmentLength) - 1;
        if (fragmentCount < 1) {
            fragmentCount = 1;
        }
        long[] fragments = new long[fragmentCount];
        Arrays.fill(fragments, -1L);
        fragments[0] = 1L;
        long time = 0L;
        int samples = 0;
        block1: for (TimeToSampleBox.Entry entry : entries) {
            i = 0;
            while ((long)i < entry.getCount()) {
                int currentFragment = (int)(time / track.getTrackMetaData().getTimescale() / (long)this.fragmentLength) + 1;
                if (currentFragment >= fragments.length) continue block1;
                fragments[currentFragment] = samples++ + 1;
                time += entry.getDelta();
                ++i;
            }
        }
        long last = samples + 1;
        i = fragments.length - 1;
        while (i >= 0) {
            if (fragments[i] == -1L) {
                fragments[i] = last;
            }
            last = fragments[i];
            --i;
        }
        return fragments;
    }
}

