/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.tracks;

import com.coremedia.iso.boxes.AbstractMediaHeaderBox;
import com.coremedia.iso.boxes.CompositionTimeToSample;
import com.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.SubSampleInformationBox;
import com.coremedia.iso.boxes.TimeToSampleBox;
import com.coremedia.iso.boxes.VideoMediaHeaderBox;
import com.coremedia.iso.boxes.h264.AvcConfigurationBox;
import com.coremedia.iso.boxes.sampleentry.VisualSampleEntry;
import com.googlecode.mp4parser.DataSource;
import com.googlecode.mp4parser.authoring.AbstractTrack;
import com.googlecode.mp4parser.authoring.Sample;
import com.googlecode.mp4parser.authoring.SampleImpl;
import com.googlecode.mp4parser.authoring.TrackMetaData;
import com.googlecode.mp4parser.h264.model.PictureParameterSet;
import com.googlecode.mp4parser.h264.model.SeqParameterSet;
import com.googlecode.mp4parser.h264.read.CAVLCReader;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class H264TrackImpl
extends AbstractTrack {
    private static final Logger LOG = Logger.getLogger(H264TrackImpl.class.getName());
    TrackMetaData trackMetaData = new TrackMetaData();
    SampleDescriptionBox sampleDescriptionBox;
    private ReaderWrapper reader;
    private List<Sample> samples;
    boolean readSamples = false;
    List<TimeToSampleBox.Entry> stts;
    List<CompositionTimeToSample.Entry> ctts;
    List<SampleDependencyTypeBox.Entry> sdtp;
    List<Integer> stss;
    SeqParameterSet seqParameterSet = null;
    PictureParameterSet pictureParameterSet = null;
    LinkedList<byte[]> seqParameterSetList = new LinkedList();
    LinkedList<byte[]> pictureParameterSetList = new LinkedList();
    private int width;
    private int height;
    private long timescale;
    private int frametick;
    private int currentScSize;
    private int prevScSize;
    private SEIMessage seiMessage;
    int frameNrInGop = 0;
    private boolean determineFrameRate = true;
    private String lang = "eng";

    public H264TrackImpl(DataSource fc, String lang, long timescale, int frametick) throws IOException {
        this.lang = lang;
        this.timescale = timescale;
        this.frametick = frametick;
        if (timescale > 0L && frametick > 0) {
            this.determineFrameRate = false;
        }
        this.parse(fc);
    }

    public H264TrackImpl(DataSource fc, String lang) throws IOException {
        this.lang = lang;
        this.parse(fc);
    }

    public H264TrackImpl(DataSource fc) throws IOException {
        this.parse(fc);
    }

    private void parse(DataSource inputChannel) throws IOException {
        this.reader = new ReaderWrapper(inputChannel);
        this.stts = new LinkedList<TimeToSampleBox.Entry>();
        this.ctts = new LinkedList<CompositionTimeToSample.Entry>();
        this.sdtp = new LinkedList<SampleDependencyTypeBox.Entry>();
        this.stss = new LinkedList<Integer>();
        this.samples = new LinkedList<Sample>();
        if (!this.readSamples()) {
            throw new IOException();
        }
        if (!this.readVariables()) {
            throw new IOException();
        }
        this.sampleDescriptionBox = new SampleDescriptionBox();
        VisualSampleEntry visualSampleEntry = new VisualSampleEntry("avc1");
        visualSampleEntry.setDataReferenceIndex(1);
        visualSampleEntry.setDepth(24);
        visualSampleEntry.setFrameCount(1);
        visualSampleEntry.setHorizresolution(72.0);
        visualSampleEntry.setVertresolution(72.0);
        visualSampleEntry.setWidth(this.width);
        visualSampleEntry.setHeight(this.height);
        visualSampleEntry.setCompressorname("AVC Coding");
        AvcConfigurationBox avcConfigurationBox = new AvcConfigurationBox();
        avcConfigurationBox.setSequenceParameterSets(this.seqParameterSetList);
        avcConfigurationBox.setPictureParameterSets(this.pictureParameterSetList);
        avcConfigurationBox.setAvcLevelIndication(this.seqParameterSet.level_idc);
        avcConfigurationBox.setAvcProfileIndication(this.seqParameterSet.profile_idc);
        avcConfigurationBox.setBitDepthLumaMinus8(this.seqParameterSet.bit_depth_luma_minus8);
        avcConfigurationBox.setBitDepthChromaMinus8(this.seqParameterSet.bit_depth_chroma_minus8);
        avcConfigurationBox.setChromaFormat(this.seqParameterSet.chroma_format_idc.getId());
        avcConfigurationBox.setConfigurationVersion(1);
        avcConfigurationBox.setLengthSizeMinusOne(3);
        avcConfigurationBox.setProfileCompatibility(this.seqParameterSetList.get(0)[1]);
        visualSampleEntry.addBox(avcConfigurationBox);
        this.sampleDescriptionBox.addBox(visualSampleEntry);
        this.trackMetaData.setCreationTime(new Date());
        this.trackMetaData.setModificationTime(new Date());
        this.trackMetaData.setLanguage(this.lang);
        this.trackMetaData.setTimescale(this.timescale);
        this.trackMetaData.setWidth(this.width);
        this.trackMetaData.setHeight(this.height);
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        return this.sampleDescriptionBox;
    }

    @Override
    public List<TimeToSampleBox.Entry> getDecodingTimeEntries() {
        return this.stts;
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        return this.ctts;
    }

    @Override
    public long[] getSyncSamples() {
        long[] returns = new long[this.stss.size()];
        int i = 0;
        while (i < this.stss.size()) {
            returns[i] = this.stss.get(i).intValue();
            ++i;
        }
        return returns;
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        return this.sdtp;
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.trackMetaData;
    }

    @Override
    public String getHandler() {
        return "vide";
    }

    @Override
    public List<Sample> getSamples() {
        return this.samples;
    }

    @Override
    public AbstractMediaHeaderBox getMediaHeaderBox() {
        return new VideoMediaHeaderBox();
    }

    @Override
    public SubSampleInformationBox getSubsampleInformationBox() {
        return null;
    }

    private boolean readVariables() {
        this.width = (this.seqParameterSet.pic_width_in_mbs_minus1 + 1) * 16;
        int mult = 2;
        if (this.seqParameterSet.frame_mbs_only_flag) {
            mult = 1;
        }
        this.height = 16 * (this.seqParameterSet.pic_height_in_map_units_minus1 + 1) * mult;
        if (this.seqParameterSet.frame_cropping_flag) {
            int chromaArrayType = 0;
            if (!this.seqParameterSet.residual_color_transform_flag) {
                chromaArrayType = this.seqParameterSet.chroma_format_idc.getId();
            }
            int cropUnitX = 1;
            int cropUnitY = mult;
            if (chromaArrayType != 0) {
                cropUnitX = this.seqParameterSet.chroma_format_idc.getSubWidth();
                cropUnitY = this.seqParameterSet.chroma_format_idc.getSubHeight() * mult;
            }
            this.width -= cropUnitX * (this.seqParameterSet.frame_crop_left_offset + this.seqParameterSet.frame_crop_right_offset);
            this.height -= cropUnitY * (this.seqParameterSet.frame_crop_top_offset + this.seqParameterSet.frame_crop_bottom_offset);
        }
        return true;
    }

    private boolean findNextStartcode() throws IOException {
        byte[] test = new byte[]{-1, -1, -1, -1};
        while (this.reader.hasRemaining()) {
            test[0] = test[1];
            test[1] = test[2];
            test[2] = test[3];
            test[3] = (byte)this.reader.get();
            if (test[0] == 0 && test[1] == 0 && test[2] == 0 && test[3] == 1) {
                this.prevScSize = this.currentScSize;
                this.currentScSize = 4;
                return true;
            }
            if (test[0] != 0 || test[1] != 0 || test[2] != 1) continue;
            this.prevScSize = this.currentScSize;
            this.currentScSize = 3;
            return true;
        }
        if (test[0] == -1 && test[1] == -1 && test[2] == -1 && test[3] == -1) {
            return false;
        }
        this.prevScSize = 0;
        this.currentScSize = 0;
        return true;
    }

    protected Sample createSample(List<? extends ByteBuffer> buffers) {
        byte[] sizeInfo = new byte[buffers.size() * 4];
        ByteBuffer sizeBuf = ByteBuffer.wrap(sizeInfo);
        for (ByteBuffer byteBuffer : buffers) {
            sizeBuf.putInt(byteBuffer.remaining());
        }
        ByteBuffer[] byteBufferArray = new ByteBuffer[buffers.size() * 2];
        int i = 0;
        while (i < buffers.size()) {
            byteBufferArray[2 * i] = ByteBuffer.wrap(sizeInfo, i * 4, 4);
            byteBufferArray[2 * i + 1] = buffers.get(i);
            ++i;
        }
        return new SampleImpl(byteBufferArray);
    }

    private boolean readSamples() throws IOException {
        if (this.readSamples) {
            return true;
        }
        this.readSamples = true;
        this.findNextStartcode();
        this.reader.mark();
        long pos = this.reader.getPos();
        ArrayList<ByteBuffer> buffered = new ArrayList<ByteBuffer>();
        int frameNr = 0;
        while (this.findNextStartcode()) {
            long newpos = this.reader.getPos();
            int size = (int)(newpos - pos - (long)this.prevScSize);
            this.reader.reset();
            ByteBuffer data = this.reader.map(size);
            byte type = data.get(data.position());
            int nal_ref_idc = type >> 5 & 3;
            int nal_unit_type = type & 0x1F;
            NALActions action = this.handleNALUnit(nal_ref_idc, nal_unit_type, data);
            switch (action) {
                case IGNORE: {
                    break;
                }
                case BUFFER: {
                    buffered.add(data);
                    break;
                }
                case STORE: {
                    int stdpValue = 22;
                    ++frameNr;
                    buffered.add(data);
                    boolean IdrPicFlag = false;
                    if (nal_unit_type == 5) {
                        stdpValue += 16;
                        IdrPicFlag = true;
                    }
                    InputStream bs = this.cleanBuffer(new ByteBufferBackedInputStream((ByteBuffer)buffered.get(buffered.size() - 1)));
                    SliceHeader sh = new SliceHeader(bs, this.seqParameterSet, this.pictureParameterSet, IdrPicFlag);
                    if (sh.slice_type == SliceHeader.SliceType.B) {
                        stdpValue += 4;
                    }
                    Sample bb = this.createSample(buffered);
                    buffered = new ArrayList();
                    this.samples.add(bb);
                    this.stts.add(new TimeToSampleBox.Entry(1L, this.frametick));
                    if (nal_unit_type == 5) {
                        this.stss.add(frameNr);
                    }
                    if (this.seiMessage == null || this.seiMessage.n_frames == 0) {
                        this.frameNrInGop = 0;
                    }
                    int offset = 0;
                    if (this.seiMessage != null && this.seiMessage.clock_timestamp_flag) {
                        offset = this.seiMessage.n_frames - this.frameNrInGop;
                    } else if (this.seiMessage != null && this.seiMessage.removal_delay_flag) {
                        offset = this.seiMessage.dpb_removal_delay / 2;
                    }
                    this.ctts.add(new CompositionTimeToSample.Entry(1, offset * this.frametick));
                    this.sdtp.add(new SampleDependencyTypeBox.Entry(stdpValue));
                    ++this.frameNrInGop;
                    break;
                }
                case END: {
                    return true;
                }
            }
            pos = newpos;
            this.reader.seek(this.currentScSize);
            this.reader.mark();
        }
        return true;
    }

    protected InputStream cleanBuffer(byte[] data) {
        ByteArrayInputStream is = new ByteArrayInputStream(data);
        return this.cleanBuffer(is);
    }

    protected InputStream cleanBuffer(InputStream is) {
        return new CleanInputStream(is);
    }

    static byte[] toArray(ByteBuffer buf) {
        buf = buf.duplicate();
        byte[] b = new byte[buf.remaining()];
        buf.get(b, 0, b.length);
        return b;
    }

    private NALActions handleNALUnit(int nal_ref_idc, int nal_unit_type, ByteBuffer data) throws IOException {
        NALActions action;
        switch (nal_unit_type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                action = NALActions.STORE;
                break;
            }
            case 6: {
                this.seiMessage = new SEIMessage(this.cleanBuffer(new ByteBufferBackedInputStream(data)), this.seqParameterSet);
                action = NALActions.BUFFER;
                break;
            }
            case 9: {
                int type = data.get(data.position() + 1) >> 5;
                LOG.fine("Access unit delimiter type: " + type);
                action = NALActions.BUFFER;
                break;
            }
            case 7: {
                if (this.seqParameterSet == null) {
                    InputStream is = this.cleanBuffer(new ByteBufferBackedInputStream(data));
                    is.read();
                    this.seqParameterSet = SeqParameterSet.read(is);
                    this.seqParameterSetList.add(H264TrackImpl.toArray(data));
                    this.configureFramerate();
                }
                action = NALActions.IGNORE;
                break;
            }
            case 8: {
                if (this.pictureParameterSet == null) {
                    ByteBufferBackedInputStream is = new ByteBufferBackedInputStream(data);
                    ((InputStream)is).read();
                    this.pictureParameterSet = PictureParameterSet.read(is);
                    this.pictureParameterSetList.add(H264TrackImpl.toArray(data));
                }
                action = NALActions.IGNORE;
                break;
            }
            case 10: 
            case 11: {
                action = NALActions.END;
                break;
            }
            default: {
                System.err.println("Unknown NAL unit type: " + nal_unit_type);
                action = NALActions.IGNORE;
            }
        }
        return action;
    }

    private void configureFramerate() {
        if (this.determineFrameRate) {
            if (this.seqParameterSet.vuiParams != null) {
                this.timescale = this.seqParameterSet.vuiParams.time_scale >> 1;
                this.frametick = this.seqParameterSet.vuiParams.num_units_in_tick;
                if (this.timescale == 0L || this.frametick == 0) {
                    System.err.println("Warning: vuiParams contain invalid values: time_scale: " + this.timescale + " and frame_tick: " + this.frametick + ". Setting frame rate to 25fps");
                    this.timescale = 90000L;
                    this.frametick = 3600;
                }
            } else {
                System.err.println("Warning: Can't determine frame rate. Guessing 25 fps");
                this.timescale = 90000L;
                this.frametick = 3600;
            }
        }
    }

    public void printAccessUnitDelimiter(byte[] data) {
        LOG.fine("Access unit delimiter: " + (data[1] >> 5));
    }

    public class ByteBufferBackedInputStream
    extends InputStream {
        private final ByteBuffer buf;

        public ByteBufferBackedInputStream(ByteBuffer buf) {
            this.buf = buf.duplicate();
        }

        public int read() throws IOException {
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            return this.buf.get() & 0xFF;
        }

        public int read(byte[] bytes, int off, int len) throws IOException {
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            len = Math.min(len, this.buf.remaining());
            this.buf.get(bytes, off, len);
            return len;
        }
    }

    protected class CleanInputStream
    extends FilterInputStream {
        int prevprev;
        int prev;

        CleanInputStream(InputStream in) {
            super(in);
            this.prevprev = -1;
            this.prev = -1;
        }

        public boolean markSupported() {
            return false;
        }

        public int read() throws IOException {
            int c = super.read();
            if (c == 3 && this.prevprev == 0 && this.prev == 0) {
                this.prevprev = -1;
                this.prev = -1;
                c = super.read();
            }
            this.prevprev = this.prev;
            this.prev = c;
            return c;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int c = this.read();
            if (c == -1) {
                return -1;
            }
            b[off] = (byte)c;
            int i = 1;
            try {
                while (i < len) {
                    c = this.read();
                    if (c != -1) {
                        b[off + i] = (byte)c;
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {}
            return i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NALActions {
        IGNORE,
        BUFFER,
        STORE,
        END;

    }

    private class ReaderWrapper {
        final ByteBuffer buffer;

        private ReaderWrapper(DataSource fc) throws IOException {
            this.buffer = fc.map(fc.position(), fc.size() - fc.position());
        }

        boolean hasRemaining() {
            return this.buffer.hasRemaining();
        }

        int get() throws IOException {
            return this.buffer.get();
        }

        ByteBuffer map(int size) throws IOException {
            ByteBuffer buf = this.buffer.duplicate();
            buf.position(this.buffer.position());
            buf.limit(buf.position() + size);
            this.buffer.position(this.buffer.position() + size);
            return buf;
        }

        void seek(int dist) throws IOException {
            this.buffer.position(this.buffer.position() + dist);
        }

        public long getPos() throws IOException {
            return this.buffer.position();
        }

        public void mark() throws IOException {
            this.buffer.mark();
        }

        public void reset() throws IOException {
            this.buffer.reset();
        }
    }

    public class SEIMessage {
        int payloadType = 0;
        int payloadSize = 0;
        boolean removal_delay_flag;
        int cpb_removal_delay;
        int dpb_removal_delay;
        boolean clock_timestamp_flag;
        int pic_struct;
        int ct_type;
        int nuit_field_based_flag;
        int counting_type;
        int full_timestamp_flag;
        int discontinuity_flag;
        int cnt_dropped_flag;
        int n_frames;
        int seconds_value;
        int minutes_value;
        int hours_value;
        int time_offset_length;
        int time_offset;
        SeqParameterSet sps;

        public SEIMessage(InputStream is, SeqParameterSet sps) throws IOException {
            this.sps = sps;
            is.read();
            int datasize = is.available();
            int read = 0;
            while (read < datasize) {
                this.payloadType = 0;
                this.payloadSize = 0;
                int last_payload_type_bytes = is.read();
                ++read;
                while (last_payload_type_bytes == 255) {
                    this.payloadType += last_payload_type_bytes;
                    last_payload_type_bytes = is.read();
                    ++read;
                }
                this.payloadType += last_payload_type_bytes;
                int last_payload_size_bytes = is.read();
                ++read;
                while (last_payload_size_bytes == 255) {
                    this.payloadSize += last_payload_size_bytes;
                    last_payload_size_bytes = is.read();
                    ++read;
                }
                this.payloadSize += last_payload_size_bytes;
                if (datasize - read >= this.payloadSize) {
                    if (this.payloadType == 1) {
                        if (sps.vuiParams != null && (sps.vuiParams.nalHRDParams != null || sps.vuiParams.vclHRDParams != null || sps.vuiParams.pic_struct_present_flag)) {
                            byte[] data = new byte[this.payloadSize];
                            is.read(data);
                            read += this.payloadSize;
                            CAVLCReader reader = new CAVLCReader(new ByteArrayInputStream(data));
                            if (sps.vuiParams.nalHRDParams != null || sps.vuiParams.vclHRDParams != null) {
                                this.removal_delay_flag = true;
                                this.cpb_removal_delay = reader.readU(sps.vuiParams.nalHRDParams.cpb_removal_delay_length_minus1 + 1, "SEI: cpb_removal_delay");
                                this.dpb_removal_delay = reader.readU(sps.vuiParams.nalHRDParams.dpb_output_delay_length_minus1 + 1, "SEI: dpb_removal_delay");
                            } else {
                                this.removal_delay_flag = false;
                            }
                            if (sps.vuiParams.pic_struct_present_flag) {
                                int numClockTS;
                                this.pic_struct = reader.readU(4, "SEI: pic_struct");
                                switch (this.pic_struct) {
                                    default: {
                                        numClockTS = 1;
                                        break;
                                    }
                                    case 3: 
                                    case 4: 
                                    case 7: {
                                        numClockTS = 2;
                                        break;
                                    }
                                    case 5: 
                                    case 6: 
                                    case 8: {
                                        numClockTS = 3;
                                    }
                                }
                                int i = 0;
                                while (i < numClockTS) {
                                    this.clock_timestamp_flag = reader.readBool("pic_timing SEI: clock_timestamp_flag[" + i + "]");
                                    if (this.clock_timestamp_flag) {
                                        this.ct_type = reader.readU(2, "pic_timing SEI: ct_type");
                                        this.nuit_field_based_flag = reader.readU(1, "pic_timing SEI: nuit_field_based_flag");
                                        this.counting_type = reader.readU(5, "pic_timing SEI: counting_type");
                                        this.full_timestamp_flag = reader.readU(1, "pic_timing SEI: full_timestamp_flag");
                                        this.discontinuity_flag = reader.readU(1, "pic_timing SEI: discontinuity_flag");
                                        this.cnt_dropped_flag = reader.readU(1, "pic_timing SEI: cnt_dropped_flag");
                                        this.n_frames = reader.readU(8, "pic_timing SEI: n_frames");
                                        if (this.full_timestamp_flag == 1) {
                                            this.seconds_value = reader.readU(6, "pic_timing SEI: seconds_value");
                                            this.minutes_value = reader.readU(6, "pic_timing SEI: minutes_value");
                                            this.hours_value = reader.readU(5, "pic_timing SEI: hours_value");
                                        } else if (reader.readBool("pic_timing SEI: seconds_flag")) {
                                            this.seconds_value = reader.readU(6, "pic_timing SEI: seconds_value");
                                            if (reader.readBool("pic_timing SEI: minutes_flag")) {
                                                this.minutes_value = reader.readU(6, "pic_timing SEI: minutes_value");
                                                if (reader.readBool("pic_timing SEI: hours_flag")) {
                                                    this.hours_value = reader.readU(5, "pic_timing SEI: hours_value");
                                                }
                                            }
                                        }
                                        this.time_offset_length = sps.vuiParams.nalHRDParams != null ? sps.vuiParams.nalHRDParams.time_offset_length : (sps.vuiParams.vclHRDParams != null ? sps.vuiParams.vclHRDParams.time_offset_length : 24);
                                        this.time_offset = reader.readU(24, "pic_timing SEI: time_offset");
                                    }
                                    ++i;
                                }
                            }
                        } else {
                            int i = 0;
                            while (i < this.payloadSize) {
                                is.read();
                                ++read;
                                ++i;
                            }
                        }
                    } else {
                        int i = 0;
                        while (i < this.payloadSize) {
                            is.read();
                            ++read;
                            ++i;
                        }
                    }
                } else {
                    read = datasize;
                }
                LOG.fine(this.toString());
            }
        }

        public String toString() {
            String out = "SEIMessage{payloadType=" + this.payloadType + ", payloadSize=" + this.payloadSize;
            if (this.payloadType == 1) {
                if (this.sps.vuiParams.nalHRDParams != null || this.sps.vuiParams.vclHRDParams != null) {
                    out = String.valueOf(out) + ", cpb_removal_delay=" + this.cpb_removal_delay + ", dpb_removal_delay=" + this.dpb_removal_delay;
                }
                if (this.sps.vuiParams.pic_struct_present_flag) {
                    out = String.valueOf(out) + ", pic_struct=" + this.pic_struct;
                    if (this.clock_timestamp_flag) {
                        out = String.valueOf(out) + ", ct_type=" + this.ct_type + ", nuit_field_based_flag=" + this.nuit_field_based_flag + ", counting_type=" + this.counting_type + ", full_timestamp_flag=" + this.full_timestamp_flag + ", discontinuity_flag=" + this.discontinuity_flag + ", cnt_dropped_flag=" + this.cnt_dropped_flag + ", n_frames=" + this.n_frames + ", seconds_value=" + this.seconds_value + ", minutes_value=" + this.minutes_value + ", hours_value=" + this.hours_value + ", time_offset_length=" + this.time_offset_length + ", time_offset=" + this.time_offset;
                    }
                }
            }
            out = String.valueOf(out) + '}';
            return out;
        }
    }

    public static class SliceHeader {
        public int first_mb_in_slice;
        public SliceType slice_type;
        public int pic_parameter_set_id;
        public int colour_plane_id;
        public int frame_num;
        public boolean field_pic_flag = false;
        public boolean bottom_field_flag = false;
        public int idr_pic_id;
        public int pic_order_cnt_lsb;
        public int delta_pic_order_cnt_bottom;

        public SliceHeader(InputStream is, SeqParameterSet sps, PictureParameterSet pps, boolean IdrPicFlag) throws IOException {
            is.read();
            CAVLCReader reader = new CAVLCReader(is);
            this.first_mb_in_slice = reader.readUE("SliceHeader: first_mb_in_slice");
            switch (reader.readUE("SliceHeader: slice_type")) {
                case 0: 
                case 5: {
                    this.slice_type = SliceType.P;
                    break;
                }
                case 1: 
                case 6: {
                    this.slice_type = SliceType.B;
                    break;
                }
                case 2: 
                case 7: {
                    this.slice_type = SliceType.I;
                    break;
                }
                case 3: 
                case 8: {
                    this.slice_type = SliceType.SP;
                    break;
                }
                case 4: 
                case 9: {
                    this.slice_type = SliceType.SI;
                }
            }
            this.pic_parameter_set_id = reader.readUE("SliceHeader: pic_parameter_set_id");
            if (sps.residual_color_transform_flag) {
                this.colour_plane_id = reader.readU(2, "SliceHeader: colour_plane_id");
            }
            this.frame_num = reader.readU(sps.log2_max_frame_num_minus4 + 4, "SliceHeader: frame_num");
            if (!sps.frame_mbs_only_flag) {
                this.field_pic_flag = reader.readBool("SliceHeader: field_pic_flag");
                if (this.field_pic_flag) {
                    this.bottom_field_flag = reader.readBool("SliceHeader: bottom_field_flag");
                }
            }
            if (IdrPicFlag) {
                this.idr_pic_id = reader.readUE("SliceHeader: idr_pic_id");
                if (sps.pic_order_cnt_type == 0) {
                    this.pic_order_cnt_lsb = reader.readU(sps.log2_max_pic_order_cnt_lsb_minus4 + 4, "SliceHeader: pic_order_cnt_lsb");
                    if (pps.pic_order_present_flag && !this.field_pic_flag) {
                        this.delta_pic_order_cnt_bottom = reader.readSE("SliceHeader: delta_pic_order_cnt_bottom");
                    }
                }
            }
        }

        public String toString() {
            return "SliceHeader{first_mb_in_slice=" + this.first_mb_in_slice + ", slice_type=" + (Object)((Object)this.slice_type) + ", pic_parameter_set_id=" + this.pic_parameter_set_id + ", colour_plane_id=" + this.colour_plane_id + ", frame_num=" + this.frame_num + ", field_pic_flag=" + this.field_pic_flag + ", bottom_field_flag=" + this.bottom_field_flag + ", idr_pic_id=" + this.idr_pic_id + ", pic_order_cnt_lsb=" + this.pic_order_cnt_lsb + ", delta_pic_order_cnt_bottom=" + this.delta_pic_order_cnt_bottom + '}';
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum SliceType {
            P,
            B,
            I,
            SP,
            SI;

        }
    }
}

