/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes;

import com.coremedia.iso.Hex;
import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.TrackHeaderBox;
import com.coremedia.iso.boxes.fragment.TrackFragmentHeaderBox;
import com.googlecode.mp4parser.AbstractFullBox;
import com.googlecode.mp4parser.RequiresParseDetailAspect;
import com.googlecode.mp4parser.annotations.DoNotParseDetail;
import com.googlecode.mp4parser.boxes.AbstractTrackEncryptionBox;
import com.googlecode.mp4parser.util.Path;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSampleEncryptionBox
extends AbstractFullBox {
    int algorithmId = -1;
    int ivSize = -1;
    byte[] kid = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    List<Entry> entries = new LinkedList<Entry>();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;

    protected AbstractSampleEncryptionBox(String type) {
        super(type);
    }

    public int getOffsetToFirstIV() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_0, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        int offset = this.getSize() > 0x100000000L ? 16 : 8;
        offset += this.isOverrideTrackEncryptionBoxParameters() ? 20 : 0;
        return offset += 4;
    }

    @Override
    public void _parseDetails(ByteBuffer content) {
        this.parseVersionAndFlags(content);
        int useThisIvSize = -1;
        if ((this.getFlags() & 1) > 0) {
            this.algorithmId = IsoTypeReader.readUInt24(content);
            useThisIvSize = this.ivSize = IsoTypeReader.readUInt8(content);
            this.kid = new byte[16];
            content.get(this.kid);
        } else {
            List<Box> tkhds = Path.getPaths(this, "/moov[0]/trak/tkhd");
            for (Box tkhd : tkhds) {
                if (((TrackHeaderBox)tkhd).getTrackId() != this.getParent().getBoxes(TrackFragmentHeaderBox.class).get(0).getTrackId()) continue;
                AbstractTrackEncryptionBox tenc = (AbstractTrackEncryptionBox)Path.getPath(tkhd, "../mdia[0]/minf[0]/stbl[0]/stsd[0]/enc.[0]/sinf[0]/schi[0]/tenc[0]");
                if (tenc == null) {
                    tenc = (AbstractTrackEncryptionBox)Path.getPath(tkhd, "../mdia[0]/minf[0]/stbl[0]/stsd[0]/enc.[0]/sinf[0]/schi[0]/uuid[0]");
                }
                useThisIvSize = tenc.getDefaultIvSize();
            }
        }
        long numOfEntries = IsoTypeReader.readUInt32(content);
        while (numOfEntries-- > 0L) {
            Entry e = new Entry();
            e.iv = new byte[useThisIvSize < 0 ? 8 : useThisIvSize];
            content.get(e.iv);
            if ((this.getFlags() & 2) > 0) {
                int numOfPairs = IsoTypeReader.readUInt16(content);
                e.pairs = new LinkedList<Entry.Pair>();
                while (numOfPairs-- > 0) {
                    e.pairs.add(e.createPair(IsoTypeReader.readUInt16(content), IsoTypeReader.readUInt32(content)));
                }
            }
            this.entries.add(e);
        }
    }

    public int getSampleCount() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_1, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.entries.size();
    }

    public List<Entry> getEntries() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_2, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.entries;
    }

    public void setEntries(List<Entry> entries) {
        List<Entry> list = entries;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_3, (Object)this, (Object)this, list);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.entries = entries;
    }

    public int getAlgorithmId() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_4, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.algorithmId;
    }

    public void setAlgorithmId(int algorithmId) {
        int n = algorithmId;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_5, (Object)this, (Object)this, Conversions.intObject(n));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.algorithmId = algorithmId;
    }

    public int getIvSize() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_6, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.ivSize;
    }

    public void setIvSize(int ivSize) {
        int n = ivSize;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_7, (Object)this, (Object)this, Conversions.intObject(n));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.ivSize = ivSize;
    }

    public byte[] getKid() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_8, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.kid;
    }

    public void setKid(byte[] kid) {
        byte[] byArray = kid;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_9, (Object)this, (Object)this, (Object)byArray);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.kid = kid;
    }

    @DoNotParseDetail
    public boolean isSubSampleEncryption() {
        return (this.getFlags() & 2) > 0;
    }

    @DoNotParseDetail
    public boolean isOverrideTrackEncryptionBoxParameters() {
        return (this.getFlags() & 1) > 0;
    }

    @DoNotParseDetail
    public void setSubSampleEncryption(boolean b) {
        if (b) {
            this.setFlags(this.getFlags() | 2);
        } else {
            this.setFlags(this.getFlags() & 0xFFFFFD);
        }
    }

    @DoNotParseDetail
    public void setOverrideTrackEncryptionBoxParameters(boolean b) {
        if (b) {
            this.setFlags(this.getFlags() | 1);
        } else {
            this.setFlags(this.getFlags() & 0xFFFFFE);
        }
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        if (this.isOverrideTrackEncryptionBoxParameters()) {
            IsoTypeWriter.writeUInt24(byteBuffer, this.algorithmId);
            IsoTypeWriter.writeUInt8(byteBuffer, this.ivSize);
            byteBuffer.put(this.kid);
        }
        IsoTypeWriter.writeUInt32(byteBuffer, this.entries.size());
        for (Entry entry : this.entries) {
            if (this.isOverrideTrackEncryptionBoxParameters()) {
                byte[] ivFull = new byte[this.ivSize];
                System.arraycopy(entry.iv, 0, ivFull, this.ivSize - entry.iv.length, entry.iv.length);
                byteBuffer.put(ivFull);
            } else {
                byteBuffer.put(entry.iv);
            }
            if (!this.isSubSampleEncryption()) continue;
            IsoTypeWriter.writeUInt16(byteBuffer, entry.pairs.size());
            for (Entry.Pair pair : entry.pairs) {
                IsoTypeWriter.writeUInt16(byteBuffer, pair.clear);
                IsoTypeWriter.writeUInt32(byteBuffer, pair.encrypted);
            }
        }
    }

    @Override
    protected long getContentSize() {
        long contentSize = 4L;
        if (this.isOverrideTrackEncryptionBoxParameters()) {
            contentSize += 4L;
            contentSize += (long)this.kid.length;
        }
        contentSize += 4L;
        for (Entry entry : this.entries) {
            contentSize += (long)entry.getSize();
        }
        return contentSize;
    }

    @Override
    public void getBox(WritableByteChannel os) throws IOException {
        super.getBox(os);
    }

    public Entry createEntry() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_10, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return new Entry();
    }

    public boolean equals(Object o) {
        Object object = o;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_11, (Object)this, (Object)this, object);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractSampleEncryptionBox that = (AbstractSampleEncryptionBox)o;
        if (this.algorithmId != that.algorithmId) {
            return false;
        }
        if (this.ivSize != that.ivSize) {
            return false;
        }
        if (this.entries != null ? !this.entries.equals(that.entries) : that.entries != null) {
            return false;
        }
        return Arrays.equals(this.kid, that.kid);
    }

    public int hashCode() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_12, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        int result = this.algorithmId;
        result = 31 * result + this.ivSize;
        result = 31 * result + (this.kid != null ? Arrays.hashCode(this.kid) : 0);
        result = 31 * result + (this.entries != null ? this.entries.hashCode() : 0);
        return result;
    }

    public List<Short> getEntrySizes() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_13, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        ArrayList<Short> entrySizes = new ArrayList<Short>(this.entries.size());
        for (Entry entry : this.entries) {
            short size = (short)entry.iv.length;
            if (this.isSubSampleEncryption()) {
                size = (short)(size + 2);
                size = (short)(size + entry.pairs.size() * 6);
            }
            entrySizes.add(size);
        }
        return entrySizes;
    }

    static {
        AbstractSampleEncryptionBox.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AbstractSampleEncryptionBox.java", AbstractSampleEncryptionBox.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getOffsetToFirstIV", "com.googlecode.mp4parser.boxes.AbstractSampleEncryptionBox", "", "", "", "int"), 33);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSampleCount", "com.googlecode.mp4parser.boxes.AbstractSampleEncryptionBox", "", "", "", "int"), 81);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createEntry", "com.googlecode.mp4parser.boxes.AbstractSampleEncryptionBox", "", "", "", "com.googlecode.mp4parser.boxes.AbstractSampleEncryptionBox$Entry"), 194);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "equals", "com.googlecode.mp4parser.boxes.AbstractSampleEncryptionBox", "java.lang.Object", "o", "", "boolean"), 307);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "hashCode", "com.googlecode.mp4parser.boxes.AbstractSampleEncryptionBox", "", "", "", "int"), 334);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getEntrySizes", "com.googlecode.mp4parser.boxes.AbstractSampleEncryptionBox", "", "", "", "java.util.List"), 342);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getEntries", "com.googlecode.mp4parser.boxes.AbstractSampleEncryptionBox", "", "", "", "java.util.List"), 85);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setEntries", "com.googlecode.mp4parser.boxes.AbstractSampleEncryptionBox", "java.util.List", "entries", "", "void"), 89);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAlgorithmId", "com.googlecode.mp4parser.boxes.AbstractSampleEncryptionBox", "", "", "", "int"), 93);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setAlgorithmId", "com.googlecode.mp4parser.boxes.AbstractSampleEncryptionBox", "int", "algorithmId", "", "void"), 97);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getIvSize", "com.googlecode.mp4parser.boxes.AbstractSampleEncryptionBox", "", "", "", "int"), 101);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setIvSize", "com.googlecode.mp4parser.boxes.AbstractSampleEncryptionBox", "int", "ivSize", "", "void"), 105);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getKid", "com.googlecode.mp4parser.boxes.AbstractSampleEncryptionBox", "", "", "", "[B"), 109);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setKid", "com.googlecode.mp4parser.boxes.AbstractSampleEncryptionBox", "[B", "kid", "", "void"), 113);
    }

    public class Entry {
        public byte[] iv;
        public List<Pair> pairs = new LinkedList<Pair>();

        public int getSize() {
            int size = 0;
            size = AbstractSampleEncryptionBox.this.isOverrideTrackEncryptionBoxParameters() ? AbstractSampleEncryptionBox.this.ivSize : this.iv.length;
            if (AbstractSampleEncryptionBox.this.isSubSampleEncryption()) {
                size += 2;
                Iterator<Pair> iterator = this.pairs.iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                    size += 6;
                }
            }
            return size;
        }

        public Pair createPair(int clear, long encrypted) {
            return new Pair(clear, encrypted);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (!new BigInteger(this.iv).equals(new BigInteger(entry.iv))) {
                return false;
            }
            return !(this.pairs != null ? !this.pairs.equals(entry.pairs) : entry.pairs != null);
        }

        public int hashCode() {
            int result = this.iv != null ? Arrays.hashCode(this.iv) : 0;
            result = 31 * result + (this.pairs != null ? this.pairs.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Entry{iv=" + Hex.encodeHex(this.iv) + ", pairs=" + this.pairs + '}';
        }

        public class Pair {
            public int clear;
            public long encrypted;

            public Pair(int clear, long encrypted) {
                this.clear = clear;
                this.encrypted = encrypted;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Pair pair = (Pair)o;
                if (this.clear != pair.clear) {
                    return false;
                }
                return this.encrypted == pair.encrypted;
            }

            public int hashCode() {
                int result = this.clear;
                result = 31 * result + (int)(this.encrypted ^ this.encrypted >>> 32);
                return result;
            }

            public String toString() {
                return "clr:" + this.clear + " enc:" + this.encrypted;
            }
        }
    }
}

