/*
 * Decompiled with CFR 0.152.
 */
package m.framework.ui.widget.slidingmenu;

import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import m.framework.ui.widget.slidingmenu.SlidingMenu;
import m.framework.ui.widget.slidingmenu.SlidingMenuGroup;
import m.framework.ui.widget.slidingmenu.SlidingMenuItem;

public abstract class MenuAdapter {
    private ArrayList<SlidingMenuGroup> menus = new ArrayList();

    public MenuAdapter(SlidingMenu menu) {
    }

    private SlidingMenuGroup findGroupById(int id) {
        if (this.menus == null) {
            return null;
        }
        for (SlidingMenuGroup group : this.menus) {
            if (group == null || group.id != id) continue;
            return group;
        }
        return null;
    }

    public void setGroup(int id, String text) {
        SlidingMenuGroup group = this.findGroupById(id);
        if (group == null) {
            group = new SlidingMenuGroup();
            group.id = id;
            this.menus.add(group);
        }
        group.text = text;
    }

    void setGroup(SlidingMenuGroup group) {
        if (group == null) {
            return;
        }
        SlidingMenuGroup groupTmp = this.findGroupById(group.id);
        if (groupTmp == null) {
            this.menus.add(group);
            return;
        }
        int index = this.menus.indexOf(groupTmp);
        this.menus.remove(index);
        this.menus.add(index, group);
    }

    public void setItem(int groupId, SlidingMenuItem item) {
        if (item == null) {
            return;
        }
        SlidingMenuGroup group = this.findGroupById(groupId);
        if (group == null) {
            return;
        }
        group.setItem(item);
    }

    public View getMenuTitle() {
        return null;
    }

    int getGroupCount() {
        return this.menus == null ? 0 : this.menus.size();
    }

    SlidingMenuGroup getGroup(int position) {
        return this.menus.get(position);
    }

    protected String getTitle(int position) {
        return this.menus.get((int)position).text;
    }

    public abstract View getGroupView(int var1, ViewGroup var2);

    protected SlidingMenuItem getItem(int groupPosition, int position) {
        return this.menus.get(groupPosition).getItem(position);
    }

    public abstract View getItemView(SlidingMenuItem var1, ViewGroup var2);

    public void notifyDataSetChanged(SlidingMenuItem item) {
    }

    public boolean onItemTrigger(SlidingMenuItem item) {
        return false;
    }

    public void onMenuSwitch(boolean menuShown) {
    }

    public SlidingMenuItem getMenuItem(int groupId, int itemId) {
        SlidingMenuGroup group = this.findGroupById(groupId);
        if (group == null) {
            return null;
        }
        return group.findItemById(itemId);
    }
}

