/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.sparta;

import com.hp.hpl.sparta.ParseCharStream;
import com.hp.hpl.sparta.ParseLog;

public class ParseException
extends Exception {
    private int lineNumber_ = -1;
    private Throwable cause_ = null;

    public ParseException(String string) {
        super(string);
    }

    public ParseException(String string, Throwable throwable) {
        super(string + " " + throwable);
        this.cause_ = throwable;
    }

    public ParseException(String string, int n, int n2, String string2, String string3) {
        super(ParseException.toMessage(string, n, n2, string2, string3));
        this.lineNumber_ = n;
    }

    public ParseException(ParseLog parseLog, String string, int n, int n2, String string2, String string3) {
        this(string, n, n2, string2, string3);
        parseLog.error(string3, string, n);
    }

    public ParseException(ParseCharStream parseCharStream, String string) {
        this(parseCharStream.getLog(), parseCharStream.getSystemId(), parseCharStream.getLineNumber(), parseCharStream.getLastCharRead(), parseCharStream.getHistory(), string);
    }

    public ParseException(ParseCharStream parseCharStream, char c, char c2) {
        this(parseCharStream, "got '" + c + "' instead of expected '" + c2 + "'");
    }

    public ParseException(ParseCharStream parseCharStream, char c, char[] cArray) {
        this(parseCharStream, "got '" + c + "' instead of " + ParseException.toString(cArray));
    }

    public ParseException(ParseCharStream parseCharStream, char c, String string) {
        this(parseCharStream, "got '" + c + "' instead of " + string + " as expected");
    }

    public ParseException(ParseCharStream parseCharStream, String string, String string2) {
        this(parseCharStream, "got \"" + string + "\" instead of \"" + string2 + "\" as expected");
    }

    private static String toString(char[] cArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(cArray[0]);
        int n = 1;
        while (n < cArray.length) {
            stringBuffer.append("or " + cArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public ParseException(ParseCharStream parseCharStream, String string, char[] cArray) {
        this(parseCharStream, string, new String(cArray));
    }

    public int getLineNumber() {
        return this.lineNumber_;
    }

    public Throwable getCause() {
        return this.cause_;
    }

    private static String toMessage(String string, int n, int n2, String string2, String string3) {
        return string + "(" + n + "): \n" + string2 + "\nLast character read was '" + ParseException.charRepr(n2) + "'\n" + string3;
    }

    static String charRepr(int n) {
        return n == -1 ? "EOF" : "" + (char)n;
    }
}

