/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.core;

import android.graphics.Bitmap;
import android.os.Handler;
import com.nostra13.universalimageloader.cache.disc.DiscCacheAware;
import com.nostra13.universalimageloader.core.DisplayBitmapTask;
import com.nostra13.universalimageloader.core.DisplayImageOptions;
import com.nostra13.universalimageloader.core.ImageLoaderConfiguration;
import com.nostra13.universalimageloader.core.ImageLoaderEngine;
import com.nostra13.universalimageloader.core.ImageLoadingInfo;
import com.nostra13.universalimageloader.core.assist.FailReason;
import com.nostra13.universalimageloader.core.assist.ImageLoadingListener;
import com.nostra13.universalimageloader.core.assist.ImageLoadingProgressListener;
import com.nostra13.universalimageloader.core.assist.ImageScaleType;
import com.nostra13.universalimageloader.core.assist.ImageSize;
import com.nostra13.universalimageloader.core.assist.LoadedFrom;
import com.nostra13.universalimageloader.core.assist.ViewScaleType;
import com.nostra13.universalimageloader.core.decode.ImageDecoder;
import com.nostra13.universalimageloader.core.decode.ImageDecodingInfo;
import com.nostra13.universalimageloader.core.download.ImageDownloader;
import com.nostra13.universalimageloader.core.imageaware.ImageAware;
import com.nostra13.universalimageloader.utils.IoUtils;
import com.nostra13.universalimageloader.utils.L;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

final class LoadAndDisplayImageTask
implements Runnable,
IoUtils.CopyListener {
    private static final String LOG_WAITING_FOR_RESUME = "ImageLoader is paused. Waiting...  [%s]";
    private static final String LOG_RESUME_AFTER_PAUSE = ".. Resume loading [%s]";
    private static final String LOG_DELAY_BEFORE_LOADING = "Delay %d ms before loading...  [%s]";
    private static final String LOG_START_DISPLAY_IMAGE_TASK = "Start display image task [%s]";
    private static final String LOG_WAITING_FOR_IMAGE_LOADED = "Image already is loading. Waiting... [%s]";
    private static final String LOG_GET_IMAGE_FROM_MEMORY_CACHE_AFTER_WAITING = "...Get cached bitmap from memory after waiting. [%s]";
    private static final String LOG_LOAD_IMAGE_FROM_NETWORK = "Load image from network [%s]";
    private static final String LOG_LOAD_IMAGE_FROM_DISC_CACHE = "Load image from disc cache [%s]";
    private static final String LOG_RESIZE_CACHED_IMAGE_FILE = "Resize image in disc cache [%s]";
    private static final String LOG_PREPROCESS_IMAGE = "PreProcess image before caching in memory [%s]";
    private static final String LOG_POSTPROCESS_IMAGE = "PostProcess image before displaying [%s]";
    private static final String LOG_CACHE_IMAGE_IN_MEMORY = "Cache image in memory [%s]";
    private static final String LOG_CACHE_IMAGE_ON_DISC = "Cache image on disc [%s]";
    private static final String LOG_PROCESS_IMAGE_BEFORE_CACHE_ON_DISC = "Process image before cache on disc [%s]";
    private static final String LOG_TASK_CANCELLED_IMAGEAWARE_REUSED = "ImageAware is reused for another image. Task is cancelled. [%s]";
    private static final String LOG_TASK_CANCELLED_IMAGEAWARE_COLLECTED = "ImageAware was collected by GC. Task is cancelled. [%s]";
    private static final String LOG_TASK_INTERRUPTED = "Task was interrupted [%s]";
    private static final String ERROR_PRE_PROCESSOR_NULL = "Pre-processor returned null [%s]";
    private static final String ERROR_POST_PROCESSOR_NULL = "Post-processor returned null [%s]";
    private static final String ERROR_PROCESSOR_FOR_DISC_CACHE_NULL = "Bitmap processor for disc cache returned null [%s]";
    private static final int BUFFER_SIZE = 32768;
    private final ImageLoaderEngine engine;
    private final ImageLoadingInfo imageLoadingInfo;
    private final Handler handler;
    private final ImageLoaderConfiguration configuration;
    private final ImageDownloader downloader;
    private final ImageDownloader networkDeniedDownloader;
    private final ImageDownloader slowNetworkDownloader;
    private final ImageDecoder decoder;
    private final boolean writeLogs;
    final String uri;
    private final String memoryCacheKey;
    final ImageAware imageAware;
    private final ImageSize targetSize;
    final DisplayImageOptions options;
    final ImageLoadingListener listener;
    final ImageLoadingProgressListener progressListener;
    private LoadedFrom loadedFrom = LoadedFrom.NETWORK;

    public LoadAndDisplayImageTask(ImageLoaderEngine engine, ImageLoadingInfo imageLoadingInfo, Handler handler) {
        this.engine = engine;
        this.imageLoadingInfo = imageLoadingInfo;
        this.handler = handler;
        this.configuration = engine.configuration;
        this.downloader = this.configuration.downloader;
        this.networkDeniedDownloader = this.configuration.networkDeniedDownloader;
        this.slowNetworkDownloader = this.configuration.slowNetworkDownloader;
        this.decoder = this.configuration.decoder;
        this.writeLogs = this.configuration.writeLogs;
        this.uri = imageLoadingInfo.uri;
        this.memoryCacheKey = imageLoadingInfo.memoryCacheKey;
        this.imageAware = imageLoadingInfo.imageAware;
        this.targetSize = imageLoadingInfo.targetSize;
        this.options = imageLoadingInfo.options;
        this.listener = imageLoadingInfo.listener;
        this.progressListener = imageLoadingInfo.progressListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Bitmap bmp;
        if (this.waitIfPaused()) {
            return;
        }
        if (this.delayIfNeed()) {
            return;
        }
        ReentrantLock loadFromUriLock = this.imageLoadingInfo.loadFromUriLock;
        this.log(LOG_START_DISPLAY_IMAGE_TASK);
        if (loadFromUriLock.isLocked()) {
            this.log(LOG_WAITING_FOR_IMAGE_LOADED);
        }
        loadFromUriLock.lock();
        try {
            this.checkTaskNotActual();
            bmp = this.configuration.memoryCache.get(this.memoryCacheKey);
            if (bmp == null) {
                bmp = this.tryLoadBitmap();
                if (bmp == null) {
                    return;
                }
                this.checkTaskNotActual();
                this.checkTaskInterrupted();
                if (this.options.shouldPreProcess()) {
                    this.log(LOG_PREPROCESS_IMAGE);
                    bmp = this.options.getPreProcessor().process(bmp);
                    if (bmp == null) {
                        L.e(ERROR_PRE_PROCESSOR_NULL, this.memoryCacheKey);
                    }
                }
                if (bmp != null && this.options.isCacheInMemory()) {
                    this.log(LOG_CACHE_IMAGE_IN_MEMORY);
                    this.configuration.memoryCache.put(this.memoryCacheKey, bmp);
                }
            } else {
                this.loadedFrom = LoadedFrom.MEMORY_CACHE;
                this.log(LOG_GET_IMAGE_FROM_MEMORY_CACHE_AFTER_WAITING);
            }
            if (bmp != null && this.options.shouldPostProcess()) {
                this.log(LOG_POSTPROCESS_IMAGE);
                bmp = this.options.getPostProcessor().process(bmp);
                if (bmp == null) {
                    L.e(ERROR_POST_PROCESSOR_NULL, this.memoryCacheKey);
                }
            }
            this.checkTaskNotActual();
            this.checkTaskInterrupted();
        }
        catch (TaskCancelledException e) {
            this.fireCancelEvent();
            return;
        }
        finally {
            loadFromUriLock.unlock();
        }
        DisplayBitmapTask displayBitmapTask = new DisplayBitmapTask(bmp, this.imageLoadingInfo, this.engine, this.loadedFrom);
        displayBitmapTask.setLoggingEnabled(this.writeLogs);
        if (this.options.isSyncLoading()) {
            displayBitmapTask.run();
        } else {
            this.handler.post((Runnable)displayBitmapTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitIfPaused() {
        AtomicBoolean pause = this.engine.getPause();
        if (pause.get()) {
            Object object = this.engine.getPauseLock();
            synchronized (object) {
                if (pause.get()) {
                    this.log(LOG_WAITING_FOR_RESUME);
                    try {
                        this.engine.getPauseLock().wait();
                    }
                    catch (InterruptedException e) {
                        L.e(LOG_TASK_INTERRUPTED, this.memoryCacheKey);
                        return true;
                    }
                    this.log(LOG_RESUME_AFTER_PAUSE);
                }
            }
        }
        return this.isTaskNotActual();
    }

    private boolean delayIfNeed() {
        if (this.options.shouldDelayBeforeLoading()) {
            this.log(LOG_DELAY_BEFORE_LOADING, this.options.getDelayBeforeLoading(), this.memoryCacheKey);
            try {
                Thread.sleep(this.options.getDelayBeforeLoading());
            }
            catch (InterruptedException e) {
                L.e(LOG_TASK_INTERRUPTED, this.memoryCacheKey);
                return true;
            }
            return this.isTaskNotActual();
        }
        return false;
    }

    private Bitmap tryLoadBitmap() throws TaskCancelledException {
        File imageFile = this.getImageFileInDiscCache();
        Bitmap bitmap = null;
        try {
            String cacheFileUri = ImageDownloader.Scheme.FILE.wrap(imageFile.getAbsolutePath());
            if (imageFile.exists()) {
                this.log(LOG_LOAD_IMAGE_FROM_DISC_CACHE);
                this.loadedFrom = LoadedFrom.DISC_CACHE;
                this.checkTaskNotActual();
                bitmap = this.decodeImage(cacheFileUri);
            }
            if (bitmap == null || bitmap.getWidth() <= 0 || bitmap.getHeight() <= 0) {
                this.log(LOG_LOAD_IMAGE_FROM_NETWORK);
                this.loadedFrom = LoadedFrom.NETWORK;
                String imageUriForDecoding = this.options.isCacheOnDisc() && this.tryCacheImageOnDisc(imageFile) ? cacheFileUri : this.uri;
                this.checkTaskNotActual();
                bitmap = this.decodeImage(imageUriForDecoding);
                if (bitmap == null || bitmap.getWidth() <= 0 || bitmap.getHeight() <= 0) {
                    this.fireFailEvent(FailReason.FailType.DECODING_ERROR, null);
                }
            }
        }
        catch (IllegalStateException e) {
            this.fireFailEvent(FailReason.FailType.NETWORK_DENIED, null);
        }
        catch (TaskCancelledException e) {
            throw e;
        }
        catch (IOException e) {
            L.e(e);
            this.fireFailEvent(FailReason.FailType.IO_ERROR, e);
            if (imageFile.exists()) {
                imageFile.delete();
            }
        }
        catch (OutOfMemoryError e) {
            L.e(e);
            this.fireFailEvent(FailReason.FailType.OUT_OF_MEMORY, e);
        }
        catch (Throwable e) {
            L.e(e);
            this.fireFailEvent(FailReason.FailType.UNKNOWN, e);
        }
        return bitmap;
    }

    private File getImageFileInDiscCache() {
        DiscCacheAware discCache = this.configuration.discCache;
        File imageFile = discCache.get(this.uri);
        File cacheDir = imageFile.getParentFile();
        if (!(cacheDir != null && (cacheDir.exists() || cacheDir.mkdirs()) || (cacheDir = (imageFile = this.configuration.reserveDiscCache.get(this.uri)).getParentFile()) == null || cacheDir.exists())) {
            cacheDir.mkdirs();
        }
        return imageFile;
    }

    private Bitmap decodeImage(String imageUri) throws IOException {
        ViewScaleType viewScaleType = this.imageAware.getScaleType();
        ImageDecodingInfo decodingInfo = new ImageDecodingInfo(this.memoryCacheKey, imageUri, this.targetSize, viewScaleType, this.getDownloader(), this.options);
        return this.decoder.decode(decodingInfo);
    }

    private boolean tryCacheImageOnDisc(File targetFile) throws TaskCancelledException {
        boolean loaded;
        block4: {
            this.log(LOG_CACHE_IMAGE_ON_DISC);
            loaded = false;
            try {
                loaded = this.downloadImage(targetFile);
                if (loaded) {
                    int width = this.configuration.maxImageWidthForDiscCache;
                    int height = this.configuration.maxImageHeightForDiscCache;
                    if (width > 0 || height > 0) {
                        this.log(LOG_RESIZE_CACHED_IMAGE_FILE);
                        loaded = this.resizeAndSaveImage(targetFile, width, height);
                    }
                    this.configuration.discCache.put(this.uri, targetFile);
                }
            }
            catch (IOException e) {
                L.e(e);
                if (!targetFile.exists()) break block4;
                targetFile.delete();
            }
        }
        return loaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean downloadImage(File targetFile) throws IOException {
        boolean loaded;
        InputStream is = this.getDownloader().getStream(this.uri, this.options.getExtraForDownloader());
        try {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(targetFile), 32768);
            try {
                loaded = IoUtils.copyStream(is, os, this);
            }
            finally {
                IoUtils.closeSilently(os);
            }
        }
        finally {
            IoUtils.closeSilently(is);
        }
        return loaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean resizeAndSaveImage(File targetFile, int maxWidth, int maxHeight) throws IOException {
        boolean saved = false;
        ImageSize targetImageSize = new ImageSize(maxWidth, maxHeight);
        DisplayImageOptions specialOptions = new DisplayImageOptions.Builder().cloneFrom(this.options).imageScaleType(ImageScaleType.IN_SAMPLE_INT).build();
        ImageDecodingInfo decodingInfo = new ImageDecodingInfo(this.memoryCacheKey, ImageDownloader.Scheme.FILE.wrap(targetFile.getAbsolutePath()), targetImageSize, ViewScaleType.FIT_INSIDE, this.getDownloader(), specialOptions);
        Bitmap bmp = this.decoder.decode(decodingInfo);
        if (bmp != null && this.configuration.processorForDiscCache != null) {
            this.log(LOG_PROCESS_IMAGE_BEFORE_CACHE_ON_DISC);
            bmp = this.configuration.processorForDiscCache.process(bmp);
            if (bmp == null) {
                L.e(ERROR_PROCESSOR_FOR_DISC_CACHE_NULL, this.memoryCacheKey);
            }
        }
        if (bmp != null) {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(targetFile), 32768);
            try {
                bmp.compress(this.configuration.imageCompressFormatForDiscCache, this.configuration.imageQualityForDiscCache, (OutputStream)os);
            }
            finally {
                IoUtils.closeSilently(os);
            }
            bmp.recycle();
        }
        return true;
    }

    @Override
    public boolean onBytesCopied(int current, int total) {
        return this.progressListener == null || this.fireProgressEvent(current, total);
    }

    private boolean fireProgressEvent(final int current, final int total) {
        if (this.options.isSyncLoading() || this.isTaskInterrupted() || this.isTaskNotActual()) {
            return false;
        }
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                LoadAndDisplayImageTask.this.progressListener.onProgressUpdate(LoadAndDisplayImageTask.this.uri, LoadAndDisplayImageTask.this.imageAware.getWrappedView(), current, total);
            }
        });
        return true;
    }

    private void fireFailEvent(final FailReason.FailType failType, final Throwable failCause) {
        if (this.options.isSyncLoading() || this.isTaskInterrupted() || this.isTaskNotActual()) {
            return;
        }
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                if (LoadAndDisplayImageTask.this.options.shouldShowImageOnFail()) {
                    LoadAndDisplayImageTask.this.imageAware.setImageDrawable(LoadAndDisplayImageTask.this.options.getImageOnFail(((LoadAndDisplayImageTask)LoadAndDisplayImageTask.this).configuration.resources));
                }
                LoadAndDisplayImageTask.this.listener.onLoadingFailed(LoadAndDisplayImageTask.this.uri, LoadAndDisplayImageTask.this.imageAware.getWrappedView(), new FailReason(failType, failCause));
            }
        });
    }

    private void fireCancelEvent() {
        if (this.options.isSyncLoading() || this.isTaskInterrupted()) {
            return;
        }
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                LoadAndDisplayImageTask.this.listener.onLoadingCancelled(LoadAndDisplayImageTask.this.uri, LoadAndDisplayImageTask.this.imageAware.getWrappedView());
            }
        });
    }

    private ImageDownloader getDownloader() {
        ImageDownloader d = this.engine.isNetworkDenied() ? this.networkDeniedDownloader : (this.engine.isSlowNetwork() ? this.slowNetworkDownloader : this.downloader);
        return d;
    }

    private void checkTaskNotActual() throws TaskCancelledException {
        this.checkViewCollected();
        this.checkViewReused();
    }

    private boolean isTaskNotActual() {
        return this.isViewCollected() || this.isViewReused();
    }

    private void checkViewCollected() throws TaskCancelledException {
        if (this.isViewCollected()) {
            throw new TaskCancelledException();
        }
    }

    private boolean isViewCollected() {
        if (this.imageAware.isCollected()) {
            this.log(LOG_TASK_CANCELLED_IMAGEAWARE_COLLECTED);
            return true;
        }
        return false;
    }

    private void checkViewReused() throws TaskCancelledException {
        if (this.isViewReused()) {
            throw new TaskCancelledException();
        }
    }

    private boolean isViewReused() {
        boolean imageAwareWasReused;
        String currentCacheKey = this.engine.getLoadingUriForView(this.imageAware);
        boolean bl = imageAwareWasReused = !this.memoryCacheKey.equals(currentCacheKey);
        if (imageAwareWasReused) {
            this.log(LOG_TASK_CANCELLED_IMAGEAWARE_REUSED);
            return true;
        }
        return false;
    }

    private void checkTaskInterrupted() throws TaskCancelledException {
        if (this.isTaskInterrupted()) {
            throw new TaskCancelledException();
        }
    }

    private boolean isTaskInterrupted() {
        if (Thread.interrupted()) {
            this.log(LOG_TASK_INTERRUPTED);
            return true;
        }
        return false;
    }

    String getLoadingUri() {
        return this.uri;
    }

    private void log(String message) {
        if (this.writeLogs) {
            L.d(message, this.memoryCacheKey);
        }
    }

    private void log(String message, Object ... args) {
        if (this.writeLogs) {
            L.d(message, args);
        }
    }

    class TaskCancelledException
    extends Exception {
        TaskCancelledException() {
        }
    }
}

