/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.isoviewer;

import com.coremedia.iso.gui.IsoViewerPanel;
import java.io.File;
import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;

public class IsoViewer
extends SingleFrameApplication {
    IsoViewerPanel isoViewerPanel;
    String sessionFile = "sessionState.xml";
    ApplicationContext ctx = this.getContext();
    Logger logger = Logger.getLogger("IsoViewer");
    File openInitially = null;

    public IsoViewer() {
        Logger logger = Logger.getLogger("global");
        logger.setLevel(Level.FINEST);
        SimpleFormatter formatter = new SimpleFormatter();
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setFormatter(formatter);
        logger.addHandler(consoleHandler);
    }

    protected void initialize(String[] args) {
        if (args.length > 0) {
            this.openInitially = new File(args[0]);
        }
    }

    protected void startup() {
        ResourceMap resource = this.ctx.getResourceMap();
        this.isoViewerPanel = new IsoViewerPanel(this.getMainFrame());
        resource.injectFields(this.isoViewerPanel);
        this.isoViewerPanel.createLayout();
        try {
            if (this.openInitially != null) {
                this.isoViewerPanel.open(this.openInitially);
            } else {
                this.ctx.getSessionStorage().restore(this.isoViewerPanel, this.sessionFile);
            }
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "couldn't restore session or open initial file given in command line", e);
        }
        ApplicationActionMap map = this.ctx.getActionMap(this.isoViewerPanel);
        this.getMainFrame().setJMenuBar(this.createMenu(map));
        this.show(this.isoViewerPanel);
    }

    protected void shutdown() {
        super.shutdown();
        try {
            this.ctx.getSessionStorage().save(this.isoViewerPanel, this.sessionFile);
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "couldn't save session", e);
        }
    }

    public static void main(String[] args) {
        Application.launch(IsoViewer.class, args);
    }

    protected JMenuBar createMenu(ApplicationActionMap map) {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menuBar.add(menu);
        JMenuItem open = new JMenuItem();
        open.setAction(map.get("open-iso-file"));
        menu.add(open);
        return menuBar;
    }
}

