/*
 * Decompiled with CFR 0.152.
 */
package m.framework.network;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class MultiPartInputStream
extends InputStream {
    private ArrayList<InputStream> isList = new ArrayList();
    private int curIs;

    MultiPartInputStream() {
    }

    public void addInputStream(InputStream is) throws Throwable {
        this.isList.add(is);
    }

    private boolean isEmpty() {
        return this.isList == null || this.isList.size() <= 0;
    }

    @Override
    public int available() throws IOException {
        if (this.isEmpty()) {
            return 0;
        }
        return this.isList.get(this.curIs).available();
    }

    @Override
    public void close() throws IOException {
        for (InputStream is : this.isList) {
            is.close();
        }
    }

    @Override
    public long skip(long n) throws IOException {
        throw new IOException();
    }

    @Override
    public int read() throws IOException {
        if (this.isEmpty()) {
            return -1;
        }
        InputStream is = this.isList.get(this.curIs);
        int data = is.read();
        while (data < 0) {
            ++this.curIs;
            if (this.curIs >= this.isList.size()) break;
            is = this.isList.get(this.curIs);
            data = is.read();
        }
        return data;
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        if (this.isEmpty()) {
            return -1;
        }
        InputStream is = this.isList.get(this.curIs);
        int len = is.read(b, offset, length);
        while (len < 0) {
            ++this.curIs;
            if (this.curIs >= this.isList.size()) break;
            is = this.isList.get(this.curIs);
            len = is.read(b, offset, length);
        }
        return len;
    }
}

