/*
 * Decompiled with CFR 0.152.
 */
package m.framework.ui.widget.slidingmenu;

import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import java.lang.reflect.Method;
import java.util.HashMap;
import m.framework.ui.widget.slidingmenu.BodyContainer;
import m.framework.ui.widget.slidingmenu.MenuAdapter;
import m.framework.ui.widget.slidingmenu.MenuConfig;
import m.framework.ui.widget.slidingmenu.SlidingMenuItem;

public class SlidingMenu
extends RelativeLayout {
    private MenuConfig config;
    private HashMap<SlidingMenuItem, View> itemToView;
    private View.OnClickListener ocListener;
    private View.OnTouchListener otListener;
    private MenuAdapter adapter;
    private int screenWidth;
    private int menuWidth;
    private int showMenuWidth;
    private boolean menuShown;
    private FrameLayout flMenu;
    private LinearLayout llMenu;
    private View vCover;
    private BodyContainer svBody;
    private LinearLayout llBody;
    private View curBody;

    public SlidingMenu(Context context) {
        super(context);
        this.init(context);
    }

    public SlidingMenu(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public SlidingMenu(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    private void init(Context context) {
        this.config = new MenuConfig();
        this.itemToView = new HashMap();
        this.ocListener = new View.OnClickListener(){

            public void onClick(View v) {
                SlidingMenuItem item = (SlidingMenuItem)v.getTag();
                if (item == null) {
                    return;
                }
                if (SlidingMenu.this.adapter == null) {
                    return;
                }
                if (!SlidingMenu.this.adapter.onItemTrigger(item)) {
                    SlidingMenu.this.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            SlidingMenu.this.hideMenu();
                        }
                    }, 500L);
                }
            }
        };
        this.otListener = new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction()) {
                    case 0: {
                        v.setBackgroundResource(((SlidingMenu)SlidingMenu.this).config.itemDownBack);
                        break;
                    }
                    case 1: 
                    case 3: {
                        v.setBackgroundResource(((SlidingMenu)SlidingMenu.this).config.itemDownRelease);
                    }
                }
                return false;
            }
        };
        this.screenWidth = context.getResources().getDisplayMetrics().widthPixels;
        this.menuWidth = (int)((float)this.screenWidth * this.config.menuWeight);
        this.showMenuWidth = (this.screenWidth - this.menuWidth) / 2;
        this.setBackgroundResource(this.config.menuBackground);
        this.initMenu(context);
        this.initBody(context);
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                SlidingMenu.this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                SlidingMenu.this.post(new Runnable(){

                    @Override
                    public void run() {
                        SlidingMenu.this.hideMenu();
                    }
                });
            }
        });
    }

    private void initMenu(Context context) {
        this.flMenu = new FrameLayout(context){

            public boolean onInterceptTouchEvent(MotionEvent ev) {
                if (!SlidingMenu.this.menuShown) {
                    return true;
                }
                return super.onInterceptTouchEvent(ev);
            }
        };
        this.flMenu.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(this.menuWidth, -1));
        this.addView((View)this.flMenu);
        LinearLayout llMenuCtn = new LinearLayout(context);
        llMenuCtn.setOrientation(1);
        llMenuCtn.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.flMenu.addView((View)llMenuCtn);
        ScrollView svMenu = new ScrollView(context);
        svMenu.setVerticalScrollBarEnabled(false);
        svMenu.setVerticalFadingEdgeEnabled(false);
        this.disableOverScrollMode((View)svMenu);
        LinearLayout.LayoutParams lpSv = new LinearLayout.LayoutParams(-1, -1);
        lpSv.weight = 1.0f;
        svMenu.setLayoutParams((ViewGroup.LayoutParams)lpSv);
        llMenuCtn.addView((View)svMenu);
        this.llMenu = new LinearLayout(context);
        this.llMenu.setOrientation(1);
        this.llMenu.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        svMenu.addView((View)this.llMenu);
        this.vCover = new View(context);
        this.vCover.setBackgroundColor(0);
        this.vCover.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.flMenu.addView(this.vCover);
    }

    private void initBody(Context context) {
        this.svBody = new BodyContainer(this);
        this.svBody.setHorizontalScrollBarEnabled(false);
        this.svBody.setHorizontalFadingEdgeEnabled(false);
        this.disableOverScrollMode((View)this.svBody);
        this.svBody.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(this.screenWidth, -1));
        this.addView((View)this.svBody);
        LinearLayout rlBodyContainer = new LinearLayout(context);
        rlBodyContainer.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(this.screenWidth + this.menuWidth, -1));
        this.svBody.addView((View)rlBodyContainer);
        FrameLayout flPlh = new FrameLayout(this.getContext());
        LinearLayout.LayoutParams lpPlh = new LinearLayout.LayoutParams(this.menuWidth, -1);
        flPlh.setLayoutParams((ViewGroup.LayoutParams)lpPlh);
        rlBodyContainer.addView((View)flPlh);
        ImageView ivShadow = new ImageView(context);
        ivShadow.setImageResource(this.config.rightShadow);
        ivShadow.setScaleType(ImageView.ScaleType.FIT_XY);
        FrameLayout.LayoutParams lpShadow = new FrameLayout.LayoutParams(-2, -1);
        lpShadow.gravity = 5;
        ivShadow.setLayoutParams((ViewGroup.LayoutParams)lpShadow);
        flPlh.addView((View)ivShadow);
        this.llBody = new LinearLayout(context){

            public boolean onTouchEvent(MotionEvent event) {
                return true;
            }
        };
        this.llBody.setBackgroundResource(this.config.bodyBackground);
        LinearLayout.LayoutParams lpBody = new LinearLayout.LayoutParams(this.screenWidth, -1);
        this.llBody.setLayoutParams((ViewGroup.LayoutParams)lpBody);
        rlBodyContainer.addView((View)this.llBody);
    }

    public void setAdapter(MenuAdapter adapter) {
        this.adapter = adapter;
        this.refresh();
    }

    public void refresh() {
        if (this.adapter != null) {
            this.reInit(this.getContext());
            this.invalidateMenu();
        }
    }

    private void reInit(Context context) {
        this.screenWidth = context.getResources().getDisplayMetrics().widthPixels;
        this.menuWidth = (int)((float)this.screenWidth * this.config.menuWeight);
        this.showMenuWidth = (this.screenWidth - this.menuWidth) / 2;
        this.setBackgroundResource(this.config.menuBackground);
        this.reInitMenu(context);
        this.reInitBody(context);
    }

    private void reInitMenu(Context context) {
        View vTitle;
        ViewGroup.LayoutParams lpMenu = this.flMenu.getLayoutParams();
        lpMenu.width = this.menuWidth;
        this.flMenu.setLayoutParams(lpMenu);
        this.llMenu.setPadding(this.config.paddingLeft, this.config.paddingTop, this.config.paddingRight, this.config.paddingBottom);
        if (this.adapter != null && (vTitle = this.adapter.getMenuTitle()) != null) {
            ViewGroup.LayoutParams lp = vTitle.getLayoutParams();
            int height = -2;
            if (lp != null) {
                height = lp.height;
            }
            vTitle.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, height));
            LinearLayout llMenuCtn = (LinearLayout)this.flMenu.getChildAt(0);
            llMenuCtn.addView(vTitle);
        }
    }

    private void reInitBody(Context context) {
        ViewGroup.LayoutParams lpBody = this.svBody.getLayoutParams();
        lpBody.width = this.screenWidth;
        this.svBody.setLayoutParams(lpBody);
        LinearLayout rlBodyContainer = (LinearLayout)this.svBody.getChildAt(0);
        ViewGroup.LayoutParams lp = rlBodyContainer.getLayoutParams();
        lp.width = this.screenWidth + this.menuWidth;
        rlBodyContainer.setLayoutParams(lp);
        FrameLayout flPlh = (FrameLayout)rlBodyContainer.getChildAt(0);
        lp = flPlh.getLayoutParams();
        lp.width = this.menuWidth;
        flPlh.setLayoutParams(lp);
        lp = this.llBody.getLayoutParams();
        lp.width = this.screenWidth;
        this.llBody.setLayoutParams(lp);
        this.llBody.setBackgroundResource(this.config.bodyBackground);
        ImageView ivShadow = (ImageView)flPlh.getChildAt(0);
        ivShadow.setImageResource(this.config.rightShadow);
        if (!this.menuShown) {
            this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    SlidingMenu.this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    SlidingMenu.this.post(new Runnable(){

                        @Override
                        public void run() {
                            SlidingMenu.this.svBody.scrollTo(SlidingMenu.this.menuWidth, 0);
                        }
                    });
                }
            });
        }
    }

    public void setBodyView(View body) {
        this.curBody = body;
        this.llBody.removeAllViews();
        if (this.curBody != null) {
            this.curBody.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
            this.llBody.addView(this.curBody);
        }
    }

    public View getBodyView() {
        return this.curBody;
    }

    private void invalidateMenu() {
        Context context = this.getContext();
        this.llMenu.removeAllViews();
        int count = this.adapter.getGroupCount();
        int i = 0;
        while (i < count) {
            View title = this.adapter.getGroupView(i, (ViewGroup)this.llMenu);
            this.llMenu.addView(title);
            int groupCount = this.adapter.getGroup(i).getCount();
            int j = 0;
            while (j < groupCount) {
                SlidingMenuItem data = this.adapter.getItem(i, j);
                View item = this.adapter.getItemView(data, (ViewGroup)this.llMenu);
                this.llMenu.addView(item);
                this.llMenu.addView(this.getSepView(context));
                this.itemToView.put(data, item);
                item.setTag((Object)data);
                item.setOnClickListener(this.ocListener);
                item.setOnTouchListener(this.otListener);
                ++j;
            }
            int viewCount = this.llMenu.getChildCount();
            if (viewCount > 0) {
                this.llMenu.removeViewAt(viewCount - 1);
            }
            ++i;
        }
    }

    private View getSepView(Context context) {
        View vSep = new View(context);
        vSep.setBackgroundResource(this.config.menuSep);
        vSep.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 2));
        return vSep;
    }

    public void switchMenu() {
        if (this.menuShown) {
            this.hideMenu();
        } else {
            this.showMenu();
        }
    }

    public void showMenu() {
        this.menuShown = true;
        this.svBody.smoothScrollTo(0, 0);
        if (this.adapter != null) {
            this.adapter.onMenuSwitch(this.menuShown);
        }
    }

    public void hideMenu() {
        this.menuShown = false;
        this.svBody.smoothScrollTo(this.menuWidth, 0);
        if (this.adapter != null) {
            this.adapter.onMenuSwitch(this.menuShown);
        }
    }

    public boolean isMenuShown() {
        return this.menuShown;
    }

    int getMenuWidth() {
        return this.menuWidth;
    }

    int getShowMenuWidth() {
        return this.showMenuWidth;
    }

    MenuConfig getMenuConfig() {
        return this.config;
    }

    View getMenuCover() {
        return this.vCover;
    }

    public void setMenuItemBackground(int down, int release) {
        this.config.itemDownBack = down;
        this.config.itemDownRelease = release;
    }

    public void setMenuWeight(float weight) {
        this.config.menuWeight = weight;
    }

    public void setMenuBackground(int resId) {
        this.config.menuBackground = resId;
    }

    public void setMenuPadding(int left, int top, int right, int bottom) {
        this.config.paddingLeft = left;
        this.config.paddingTop = top;
        this.config.paddingRight = right;
        this.config.paddingBottom = bottom;
    }

    public void setTtleHeight(int height) {
        this.config.titleHeight = height;
    }

    public void setShadowRes(int resId) {
        this.config.rightShadow = resId;
    }

    public void setBodyBackground(int resId) {
        this.config.bodyBackground = resId;
    }

    public void setMenuDivider(int resId) {
        this.config.menuSep = resId;
    }

    private void disableOverScrollMode(View view) {
        if (Build.VERSION.SDK_INT < 9) {
            return;
        }
        try {
            Method m = View.class.getMethod("setOverScrollMode", Integer.TYPE);
            m.setAccessible(true);
            m.invoke((Object)view, 2);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    View itemToView(SlidingMenuItem item) {
        return this.itemToView.get(item);
    }

    public void triggerItem(int groupId, int itemId) {
        if (this.adapter == null) {
            return;
        }
        SlidingMenuItem item = this.adapter.getMenuItem(groupId, itemId);
        if (item != null) {
            this.adapter.onItemTrigger(item);
        }
    }

    public void triggerItem(SlidingMenuItem item) {
        if (this.adapter == null) {
            return;
        }
        if (item != null) {
            this.adapter.onItemTrigger(item);
        }
    }
}

