/*
 * Decompiled with CFR 0.152.
 */
package com.lidroid.xutils.db.table;

import android.text.TextUtils;
import com.lidroid.xutils.db.annotation.Table;
import com.lidroid.xutils.db.converter.ColumnConverterFactory;
import com.lidroid.xutils.db.table.Column;
import com.lidroid.xutils.db.table.ColumnUtils;
import com.lidroid.xutils.db.table.Finder;
import com.lidroid.xutils.db.table.Foreign;
import com.lidroid.xutils.db.table.Id;
import com.lidroid.xutils.util.LogUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;

public class TableUtils {
    private static ConcurrentHashMap<String, HashMap<String, Column>> entityColumnsMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Id> entityIdMap = new ConcurrentHashMap();

    private TableUtils() {
    }

    public static String getTableName(Class<?> entityType) {
        Table table = entityType.getAnnotation(Table.class);
        if (table == null || TextUtils.isEmpty((CharSequence)table.name())) {
            return entityType.getName().replace('.', '_');
        }
        return table.name();
    }

    public static String getExecAfterTableCreated(Class<?> entityType) {
        Table table = entityType.getAnnotation(Table.class);
        if (table != null) {
            return table.execAfterTableCreated();
        }
        return null;
    }

    static synchronized HashMap<String, Column> getColumnMap(Class<?> entityType) {
        if (entityColumnsMap.containsKey(entityType.getName())) {
            return entityColumnsMap.get(entityType.getName());
        }
        HashMap<String, Column> columnMap = new HashMap<String, Column>();
        String primaryKeyFieldName = TableUtils.getPrimaryKeyFieldName(entityType);
        TableUtils.addColumns2Map(entityType, primaryKeyFieldName, columnMap);
        entityColumnsMap.put(entityType.getName(), columnMap);
        return columnMap;
    }

    private static void addColumns2Map(Class<?> entityType, String primaryKeyFieldName, HashMap<String, Column> columnMap) {
        if (Object.class.equals(entityType)) {
            return;
        }
        try {
            Field[] fields;
            Field[] fieldArray = fields = entityType.getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (!ColumnUtils.isTransient(field) && !Modifier.isStatic(field.getModifiers())) {
                    Column column;
                    if (ColumnConverterFactory.isSupportColumnConverter(field.getType())) {
                        if (!field.getName().equals(primaryKeyFieldName) && !columnMap.containsKey((column = new Column(entityType, field)).getColumnName())) {
                            columnMap.put(column.getColumnName(), column);
                        }
                    } else if (ColumnUtils.isForeign(field)) {
                        column = new Foreign(entityType, field);
                        if (!columnMap.containsKey(column.getColumnName())) {
                            columnMap.put(column.getColumnName(), column);
                        }
                    } else if (ColumnUtils.isFinder(field) && !columnMap.containsKey((column = new Finder(entityType, field)).getColumnName())) {
                        columnMap.put(column.getColumnName(), column);
                    }
                }
                ++n2;
            }
            if (!Object.class.equals(entityType.getSuperclass())) {
                TableUtils.addColumns2Map(entityType.getSuperclass(), primaryKeyFieldName, columnMap);
            }
        }
        catch (Throwable e) {
            LogUtils.e(e.getMessage(), e);
        }
    }

    static Column getColumnOrId(Class<?> entityType, String columnName) {
        if (TableUtils.getPrimaryKeyColumnName(entityType).equals(columnName)) {
            return TableUtils.getId(entityType);
        }
        return TableUtils.getColumnMap(entityType).get(columnName);
    }

    static synchronized Id getId(Class<?> entityType) {
        if (Object.class.equals(entityType)) {
            throw new RuntimeException("field 'id' not found");
        }
        if (entityIdMap.containsKey(entityType.getName())) {
            return entityIdMap.get(entityType.getName());
        }
        Field primaryKeyField = null;
        Field[] fields = entityType.getDeclaredFields();
        if (fields != null) {
            Field field;
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                field = fieldArray[n2];
                if (field.getAnnotation(com.lidroid.xutils.db.annotation.Id.class) != null) {
                    primaryKeyField = field;
                    break;
                }
                ++n2;
            }
            if (primaryKeyField == null) {
                fieldArray = fields;
                n = fields.length;
                n2 = 0;
                while (n2 < n) {
                    field = fieldArray[n2];
                    if ("id".equals(field.getName()) || "_id".equals(field.getName())) {
                        primaryKeyField = field;
                        break;
                    }
                    ++n2;
                }
            }
        }
        if (primaryKeyField == null) {
            return TableUtils.getId(entityType.getSuperclass());
        }
        Id id = new Id(entityType, primaryKeyField);
        entityIdMap.put(entityType.getName(), id);
        return id;
    }

    private static String getPrimaryKeyFieldName(Class<?> entityType) {
        Id id = TableUtils.getId(entityType);
        return id == null ? null : id.getColumnField().getName();
    }

    private static String getPrimaryKeyColumnName(Class<?> entityType) {
        Id id = TableUtils.getId(entityType);
        return id == null ? null : id.getColumnName();
    }
}

