/*
 * Decompiled with CFR 0.152.
 */
package com.qq.taf.jce;

import com.qq.taf.jce.HexUtil;
import com.qq.taf.jce.JceDecodeException;
import com.qq.taf.jce.JceStruct;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JceInputStream {
    private ByteBuffer bs;
    protected String sServerEncoding = "GBK";

    public JceInputStream() {
    }

    public JceInputStream(ByteBuffer bs) {
        this.bs = bs;
    }

    public JceInputStream(byte[] bs) {
        this.bs = ByteBuffer.wrap(bs);
    }

    public JceInputStream(byte[] bs, int pos) {
        this.bs = ByteBuffer.wrap(bs);
        this.bs.position(pos);
    }

    public void warp(byte[] bs) {
        this.wrap(bs);
    }

    public void wrap(byte[] bs) {
        this.bs = ByteBuffer.wrap(bs);
    }

    public static int readHead(HeadData hd, ByteBuffer bb) {
        byte b = bb.get();
        hd.type = (byte)(b & 0xF);
        hd.tag = (b & 0xF0) >> 4;
        if (hd.tag == 15) {
            hd.tag = bb.get() & 0xFF;
            return 2;
        }
        return 1;
    }

    public void readHead(HeadData hd) {
        JceInputStream.readHead(hd, this.bs);
    }

    private int peakHead(HeadData hd) {
        return JceInputStream.readHead(hd, this.bs.duplicate());
    }

    private void skip(int len) {
        this.bs.position(this.bs.position() + len);
    }

    public boolean skipToTag(int tag) {
        try {
            HeadData hd = new HeadData();
            while (true) {
                int len = this.peakHead(hd);
                if (hd.type == 11) {
                    return false;
                }
                if (tag <= hd.tag) {
                    return tag == hd.tag;
                }
                this.skip(len);
                this.skipField(hd.type);
            }
        }
        catch (JceDecodeException e) {
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            // empty catch block
        }
        return false;
    }

    public void skipToStructEnd() {
        HeadData hd = new HeadData();
        do {
            this.readHead(hd);
            this.skipField(hd.type);
        } while (hd.type != 11);
    }

    private void skipField() {
        HeadData hd = new HeadData();
        this.readHead(hd);
        this.skipField(hd.type);
    }

    private void skipField(byte type) {
        switch (type) {
            case 0: {
                this.skip(1);
                break;
            }
            case 1: {
                this.skip(2);
                break;
            }
            case 2: {
                this.skip(4);
                break;
            }
            case 3: {
                this.skip(8);
                break;
            }
            case 4: {
                this.skip(4);
                break;
            }
            case 5: {
                this.skip(8);
                break;
            }
            case 6: {
                int len = this.bs.get();
                if (len < 0) {
                    len += 256;
                }
                this.skip(len);
                break;
            }
            case 7: {
                this.skip(this.bs.getInt());
                break;
            }
            case 8: {
                int size = this.read(0, 0, true);
                for (int i = 0; i < size * 2; ++i) {
                    this.skipField();
                }
                break;
            }
            case 9: {
                int size = this.read(0, 0, true);
                for (int i = 0; i < size; ++i) {
                    this.skipField();
                }
                break;
            }
            case 13: {
                HeadData hd = new HeadData();
                this.readHead(hd);
                if (hd.type != 0) {
                    throw new JceDecodeException("skipField with invalid type, type value: " + type + ", " + hd.type);
                }
                int size = this.read(0, 0, true);
                this.skip(size);
                break;
            }
            case 10: {
                this.skipToStructEnd();
                break;
            }
            case 11: 
            case 12: {
                break;
            }
            default: {
                throw new JceDecodeException("invalid type.");
            }
        }
    }

    public boolean read(boolean b, int tag, boolean isRequire) {
        byte c = this.read((byte)0, tag, isRequire);
        return c != 0;
    }

    public byte read(byte c, int tag, boolean isRequire) {
        if (this.skipToTag(tag)) {
            HeadData hd = new HeadData();
            this.readHead(hd);
            switch (hd.type) {
                case 12: {
                    c = 0;
                    break;
                }
                case 0: {
                    c = this.bs.get();
                    break;
                }
                default: {
                    throw new JceDecodeException("type mismatch.");
                }
            }
        } else if (isRequire) {
            throw new JceDecodeException("require field not exist.");
        }
        return c;
    }

    public short read(short n, int tag, boolean isRequire) {
        if (this.skipToTag(tag)) {
            HeadData hd = new HeadData();
            this.readHead(hd);
            switch (hd.type) {
                case 12: {
                    n = 0;
                    break;
                }
                case 0: {
                    n = this.bs.get();
                    break;
                }
                case 1: {
                    n = this.bs.getShort();
                    break;
                }
                default: {
                    throw new JceDecodeException("type mismatch.");
                }
            }
        } else if (isRequire) {
            throw new JceDecodeException("require field not exist.");
        }
        return n;
    }

    public int read(int n, int tag, boolean isRequire) {
        if (this.skipToTag(tag)) {
            HeadData hd = new HeadData();
            this.readHead(hd);
            switch (hd.type) {
                case 12: {
                    n = 0;
                    break;
                }
                case 0: {
                    n = this.bs.get();
                    break;
                }
                case 1: {
                    n = this.bs.getShort();
                    break;
                }
                case 2: {
                    n = this.bs.getInt();
                    break;
                }
                default: {
                    throw new JceDecodeException("type mismatch.");
                }
            }
        } else if (isRequire) {
            throw new JceDecodeException("require field not exist.");
        }
        return n;
    }

    public long read(long n, int tag, boolean isRequire) {
        if (this.skipToTag(tag)) {
            HeadData hd = new HeadData();
            this.readHead(hd);
            switch (hd.type) {
                case 12: {
                    n = 0L;
                    break;
                }
                case 0: {
                    n = this.bs.get();
                    break;
                }
                case 1: {
                    n = this.bs.getShort();
                    break;
                }
                case 2: {
                    n = this.bs.getInt();
                    break;
                }
                case 3: {
                    n = this.bs.getLong();
                    break;
                }
                default: {
                    throw new JceDecodeException("type mismatch.");
                }
            }
        } else if (isRequire) {
            throw new JceDecodeException("require field not exist.");
        }
        return n;
    }

    public float read(float n, int tag, boolean isRequire) {
        if (this.skipToTag(tag)) {
            HeadData hd = new HeadData();
            this.readHead(hd);
            switch (hd.type) {
                case 12: {
                    n = 0.0f;
                    break;
                }
                case 4: {
                    n = this.bs.getFloat();
                    break;
                }
                default: {
                    throw new JceDecodeException("type mismatch.");
                }
            }
        } else if (isRequire) {
            throw new JceDecodeException("require field not exist.");
        }
        return n;
    }

    public double read(double n, int tag, boolean isRequire) {
        if (this.skipToTag(tag)) {
            HeadData hd = new HeadData();
            this.readHead(hd);
            switch (hd.type) {
                case 12: {
                    n = 0.0;
                    break;
                }
                case 4: {
                    n = this.bs.getFloat();
                    break;
                }
                case 5: {
                    n = this.bs.getDouble();
                    break;
                }
                default: {
                    throw new JceDecodeException("type mismatch.");
                }
            }
        } else if (isRequire) {
            throw new JceDecodeException("require field not exist.");
        }
        return n;
    }

    public String readByteString(String s, int tag, boolean isRequire) {
        if (this.skipToTag(tag)) {
            HeadData hd = new HeadData();
            this.readHead(hd);
            switch (hd.type) {
                case 6: {
                    int len = this.bs.get();
                    if (len < 0) {
                        len += 256;
                    }
                    byte[] ss = new byte[len];
                    this.bs.get(ss);
                    s = HexUtil.bytes2HexStr(ss);
                    break;
                }
                case 7: {
                    int len = this.bs.getInt();
                    if (len > 0x6400000 || len < 0) {
                        throw new JceDecodeException("String too long: " + len);
                    }
                    byte[] ss = new byte[len];
                    this.bs.get(ss);
                    s = HexUtil.bytes2HexStr(ss);
                    break;
                }
                default: {
                    throw new JceDecodeException("type mismatch.");
                }
            }
        } else if (isRequire) {
            throw new JceDecodeException("require field not exist.");
        }
        return s;
    }

    public String read(String s, int tag, boolean isRequire) {
        if (this.skipToTag(tag)) {
            HeadData hd = new HeadData();
            this.readHead(hd);
            switch (hd.type) {
                case 6: {
                    int len = this.bs.get();
                    if (len < 0) {
                        len += 256;
                    }
                    byte[] ss = new byte[len];
                    this.bs.get(ss);
                    try {
                        s = new String(ss, this.sServerEncoding);
                    }
                    catch (UnsupportedEncodingException e) {
                        s = new String(ss);
                    }
                    break;
                }
                case 7: {
                    int len = this.bs.getInt();
                    if (len > 0x6400000 || len < 0) {
                        throw new JceDecodeException("String too long: " + len);
                    }
                    byte[] ss = new byte[len];
                    this.bs.get(ss);
                    try {
                        s = new String(ss, this.sServerEncoding);
                    }
                    catch (UnsupportedEncodingException e) {
                        s = new String(ss);
                    }
                    break;
                }
                default: {
                    throw new JceDecodeException("type mismatch.");
                }
            }
        } else if (isRequire) {
            throw new JceDecodeException("require field not exist.");
        }
        return s;
    }

    public String readString(int tag, boolean isRequire) {
        String s = null;
        if (this.skipToTag(tag)) {
            HeadData hd = new HeadData();
            this.readHead(hd);
            switch (hd.type) {
                case 6: {
                    int len = this.bs.get();
                    if (len < 0) {
                        len += 256;
                    }
                    byte[] ss = new byte[len];
                    this.bs.get(ss);
                    try {
                        s = new String(ss, this.sServerEncoding);
                    }
                    catch (UnsupportedEncodingException e) {
                        s = new String(ss);
                    }
                    break;
                }
                case 7: {
                    int len = this.bs.getInt();
                    if (len > 0x6400000 || len < 0) {
                        throw new JceDecodeException("String too long: " + len);
                    }
                    byte[] ss = new byte[len];
                    this.bs.get(ss);
                    try {
                        s = new String(ss, this.sServerEncoding);
                    }
                    catch (UnsupportedEncodingException e) {
                        s = new String(ss);
                    }
                    break;
                }
                default: {
                    throw new JceDecodeException("type mismatch.");
                }
            }
        } else if (isRequire) {
            throw new JceDecodeException("require field not exist.");
        }
        return s;
    }

    public String[] read(String[] s, int tag, boolean isRequire) {
        return this.readArray(s, tag, isRequire);
    }

    public Map<String, String> readStringMap(int tag, boolean isRequire) {
        HashMap<String, String> mr;
        block7: {
            block6: {
                mr = new HashMap<String, String>();
                if (!this.skipToTag(tag)) break block6;
                HeadData hd = new HeadData();
                this.readHead(hd);
                switch (hd.type) {
                    case 8: {
                        int size = this.read(0, 0, true);
                        if (size < 0) {
                            throw new JceDecodeException("size invalid: " + size);
                        }
                        for (int i = 0; i < size; ++i) {
                            String k = this.readString(0, true);
                            String v = this.readString(1, true);
                            mr.put(k, v);
                        }
                        break block7;
                    }
                    default: {
                        throw new JceDecodeException("type mismatch.");
                    }
                }
            }
            if (isRequire) {
                throw new JceDecodeException("require field not exist.");
            }
        }
        return mr;
    }

    public <K, V> HashMap<K, V> readMap(Map<K, V> m, int tag, boolean isRequire) {
        return (HashMap)this.readMap(new HashMap(), m, tag, isRequire);
    }

    private <K, V> Map<K, V> readMap(Map<K, V> mr, Map<K, V> m, int tag, boolean isRequire) {
        block8: {
            block7: {
                if (m == null || m.isEmpty()) {
                    return new HashMap();
                }
                Iterator<Map.Entry<K, V>> it = m.entrySet().iterator();
                Map.Entry<K, V> en = it.next();
                K mk = en.getKey();
                V mv = en.getValue();
                if (!this.skipToTag(tag)) break block7;
                HeadData hd = new HeadData();
                this.readHead(hd);
                switch (hd.type) {
                    case 8: {
                        int size = this.read(0, 0, true);
                        if (size < 0) {
                            throw new JceDecodeException("size invalid: " + size);
                        }
                        for (int i = 0; i < size; ++i) {
                            Object k = this.read(mk, 0, true);
                            Object v = this.read(mv, 1, true);
                            mr.put(k, v);
                        }
                        break block8;
                    }
                    default: {
                        throw new JceDecodeException("type mismatch.");
                    }
                }
            }
            if (isRequire) {
                throw new JceDecodeException("require field not exist.");
            }
        }
        return mr;
    }

    public List readList(int tag, boolean isRequire) {
        ArrayList<Serializable> lr;
        block24: {
            block23: {
                lr = new ArrayList<Serializable>();
                if (!this.skipToTag(tag)) break block23;
                HeadData hd = new HeadData();
                this.readHead(hd);
                switch (hd.type) {
                    case 9: {
                        int size = this.read(0, 0, true);
                        if (size < 0) {
                            throw new JceDecodeException("size invalid: " + size);
                        }
                        block19: for (int i = 0; i < size; ++i) {
                            HeadData subH = new HeadData();
                            this.readHead(subH);
                            switch (subH.type) {
                                case 0: {
                                    this.skip(1);
                                    continue block19;
                                }
                                case 1: {
                                    this.skip(2);
                                    continue block19;
                                }
                                case 2: {
                                    this.skip(4);
                                    continue block19;
                                }
                                case 3: {
                                    this.skip(8);
                                    continue block19;
                                }
                                case 4: {
                                    this.skip(4);
                                    continue block19;
                                }
                                case 5: {
                                    this.skip(8);
                                    continue block19;
                                }
                                case 6: {
                                    int len = this.bs.get();
                                    if (len < 0) {
                                        len += 256;
                                    }
                                    this.skip(len);
                                    continue block19;
                                }
                                case 7: {
                                    this.skip(this.bs.getInt());
                                    continue block19;
                                }
                                case 8: {
                                    continue block19;
                                }
                                case 9: {
                                    continue block19;
                                }
                                case 10: {
                                    try {
                                        Class<?> newoneClass = Class.forName(JceStruct.class.getName());
                                        Constructor<?> cons = newoneClass.getConstructor(new Class[0]);
                                        JceStruct struct = (JceStruct)cons.newInstance(new Object[0]);
                                        struct.readFrom(this);
                                        this.skipToStructEnd();
                                        lr.add(struct);
                                        continue block19;
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                        throw new JceDecodeException("type mismatch." + e);
                                    }
                                }
                                case 12: {
                                    lr.add(new Integer(0));
                                    continue block19;
                                }
                                default: {
                                    throw new JceDecodeException("type mismatch.");
                                }
                            }
                        }
                        break block24;
                    }
                    default: {
                        throw new JceDecodeException("type mismatch.");
                    }
                }
            }
            if (isRequire) {
                throw new JceDecodeException("require field not exist.");
            }
        }
        return lr;
    }

    public boolean[] read(boolean[] l, int tag, boolean isRequire) {
        boolean[] lr;
        block7: {
            block6: {
                lr = null;
                if (!this.skipToTag(tag)) break block6;
                HeadData hd = new HeadData();
                this.readHead(hd);
                switch (hd.type) {
                    case 9: {
                        int size = this.read(0, 0, true);
                        if (size < 0) {
                            throw new JceDecodeException("size invalid: " + size);
                        }
                        lr = new boolean[size];
                        for (int i = 0; i < size; ++i) {
                            lr[i] = this.read(lr[0], 0, true);
                        }
                        break block7;
                    }
                    default: {
                        throw new JceDecodeException("type mismatch.");
                    }
                }
            }
            if (isRequire) {
                throw new JceDecodeException("require field not exist.");
            }
        }
        return lr;
    }

    public byte[] read(byte[] l, int tag, boolean isRequire) {
        byte[] lr;
        block10: {
            block9: {
                lr = null;
                if (!this.skipToTag(tag)) break block9;
                HeadData hd = new HeadData();
                this.readHead(hd);
                switch (hd.type) {
                    case 13: {
                        HeadData hh = new HeadData();
                        this.readHead(hh);
                        if (hh.type != 0) {
                            throw new JceDecodeException("type mismatch, tag: " + tag + ", type: " + hd.type + ", " + hh.type);
                        }
                        int size = this.read(0, 0, true);
                        if (size < 0) {
                            throw new JceDecodeException("invalid size, tag: " + tag + ", type: " + hd.type + ", " + hh.type + ", size: " + size);
                        }
                        lr = new byte[size];
                        this.bs.get(lr);
                        break;
                    }
                    case 9: {
                        int size = this.read(0, 0, true);
                        if (size < 0) {
                            throw new JceDecodeException("size invalid: " + size);
                        }
                        lr = new byte[size];
                        for (int i = 0; i < size; ++i) {
                            lr[i] = this.read(lr[0], 0, true);
                        }
                        break block10;
                    }
                    default: {
                        throw new JceDecodeException("type mismatch.");
                    }
                }
                break block10;
            }
            if (isRequire) {
                throw new JceDecodeException("require field not exist.");
            }
        }
        return lr;
    }

    public short[] read(short[] l, int tag, boolean isRequire) {
        short[] lr;
        block7: {
            block6: {
                lr = null;
                if (!this.skipToTag(tag)) break block6;
                HeadData hd = new HeadData();
                this.readHead(hd);
                switch (hd.type) {
                    case 9: {
                        int size = this.read(0, 0, true);
                        if (size < 0) {
                            throw new JceDecodeException("size invalid: " + size);
                        }
                        lr = new short[size];
                        for (int i = 0; i < size; ++i) {
                            lr[i] = this.read(lr[0], 0, true);
                        }
                        break block7;
                    }
                    default: {
                        throw new JceDecodeException("type mismatch.");
                    }
                }
            }
            if (isRequire) {
                throw new JceDecodeException("require field not exist.");
            }
        }
        return lr;
    }

    public int[] read(int[] l, int tag, boolean isRequire) {
        int[] lr;
        block7: {
            block6: {
                lr = null;
                if (!this.skipToTag(tag)) break block6;
                HeadData hd = new HeadData();
                this.readHead(hd);
                switch (hd.type) {
                    case 9: {
                        int size = this.read(0, 0, true);
                        if (size < 0) {
                            throw new JceDecodeException("size invalid: " + size);
                        }
                        lr = new int[size];
                        for (int i = 0; i < size; ++i) {
                            lr[i] = this.read(lr[0], 0, true);
                        }
                        break block7;
                    }
                    default: {
                        throw new JceDecodeException("type mismatch.");
                    }
                }
            }
            if (isRequire) {
                throw new JceDecodeException("require field not exist.");
            }
        }
        return lr;
    }

    public long[] read(long[] l, int tag, boolean isRequire) {
        long[] lr;
        block7: {
            block6: {
                lr = null;
                if (!this.skipToTag(tag)) break block6;
                HeadData hd = new HeadData();
                this.readHead(hd);
                switch (hd.type) {
                    case 9: {
                        int size = this.read(0, 0, true);
                        if (size < 0) {
                            throw new JceDecodeException("size invalid: " + size);
                        }
                        lr = new long[size];
                        for (int i = 0; i < size; ++i) {
                            lr[i] = this.read(lr[0], 0, true);
                        }
                        break block7;
                    }
                    default: {
                        throw new JceDecodeException("type mismatch.");
                    }
                }
            }
            if (isRequire) {
                throw new JceDecodeException("require field not exist.");
            }
        }
        return lr;
    }

    public float[] read(float[] l, int tag, boolean isRequire) {
        float[] lr;
        block7: {
            block6: {
                lr = null;
                if (!this.skipToTag(tag)) break block6;
                HeadData hd = new HeadData();
                this.readHead(hd);
                switch (hd.type) {
                    case 9: {
                        int size = this.read(0, 0, true);
                        if (size < 0) {
                            throw new JceDecodeException("size invalid: " + size);
                        }
                        lr = new float[size];
                        for (int i = 0; i < size; ++i) {
                            lr[i] = this.read(lr[0], 0, true);
                        }
                        break block7;
                    }
                    default: {
                        throw new JceDecodeException("type mismatch.");
                    }
                }
            }
            if (isRequire) {
                throw new JceDecodeException("require field not exist.");
            }
        }
        return lr;
    }

    public double[] read(double[] l, int tag, boolean isRequire) {
        double[] lr;
        block7: {
            block6: {
                lr = null;
                if (!this.skipToTag(tag)) break block6;
                HeadData hd = new HeadData();
                this.readHead(hd);
                switch (hd.type) {
                    case 9: {
                        int size = this.read(0, 0, true);
                        if (size < 0) {
                            throw new JceDecodeException("size invalid: " + size);
                        }
                        lr = new double[size];
                        for (int i = 0; i < size; ++i) {
                            lr[i] = this.read(lr[0], 0, true);
                        }
                        break block7;
                    }
                    default: {
                        throw new JceDecodeException("type mismatch.");
                    }
                }
            }
            if (isRequire) {
                throw new JceDecodeException("require field not exist.");
            }
        }
        return lr;
    }

    public <T> T[] readArray(T[] l, int tag, boolean isRequire) {
        if (l == null || l.length == 0) {
            throw new JceDecodeException("unable to get type of key and value.");
        }
        return this.readArrayImpl(l[0], tag, isRequire);
    }

    public <T> List<T> readArray(List<T> l, int tag, boolean isRequire) {
        if (l == null || l.isEmpty()) {
            return new ArrayList();
        }
        T[] tt = this.readArrayImpl(l.get(0), tag, isRequire);
        if (tt == null) {
            return null;
        }
        ArrayList<T> ll = new ArrayList<T>();
        for (int i = 0; i < tt.length; ++i) {
            ll.add(tt[i]);
        }
        return ll;
    }

    private <T> T[] readArrayImpl(T mt, int tag, boolean isRequire) {
        if (this.skipToTag(tag)) {
            HeadData hd = new HeadData();
            this.readHead(hd);
            switch (hd.type) {
                case 9: {
                    int size = this.read(0, 0, true);
                    if (size < 0) {
                        throw new JceDecodeException("size invalid: " + size);
                    }
                    Object[] lr = (Object[])Array.newInstance(mt.getClass(), size);
                    for (int i = 0; i < size; ++i) {
                        Object t;
                        lr[i] = t = this.read(mt, 0, true);
                    }
                    return lr;
                }
            }
            throw new JceDecodeException("type mismatch.");
        }
        if (isRequire) {
            throw new JceDecodeException("require field not exist.");
        }
        return null;
    }

    public JceStruct directRead(JceStruct o, int tag, boolean isRequire) {
        JceStruct ref = null;
        if (this.skipToTag(tag)) {
            try {
                ref = o.newInit();
            }
            catch (Exception e) {
                throw new JceDecodeException(e.getMessage());
            }
            HeadData hd = new HeadData();
            this.readHead(hd);
            if (hd.type != 10) {
                throw new JceDecodeException("type mismatch.");
            }
            ref.readFrom(this);
            this.skipToStructEnd();
        } else if (isRequire) {
            throw new JceDecodeException("require field not exist.");
        }
        return ref;
    }

    public JceStruct read(JceStruct o, int tag, boolean isRequire) {
        JceStruct ref = null;
        if (this.skipToTag(tag)) {
            try {
                ref = (JceStruct)o.getClass().newInstance();
            }
            catch (Exception e) {
                throw new JceDecodeException(e.getMessage());
            }
            HeadData hd = new HeadData();
            this.readHead(hd);
            if (hd.type != 10) {
                throw new JceDecodeException("type mismatch.");
            }
            ref.readFrom(this);
            this.skipToStructEnd();
        } else if (isRequire) {
            throw new JceDecodeException("require field not exist.");
        }
        return ref;
    }

    public JceStruct[] read(JceStruct[] o, int tag, boolean isRequire) {
        return this.readArray(o, tag, isRequire);
    }

    public <T> Object read(T o, int tag, boolean isRequire) {
        if (o instanceof Byte) {
            return this.read((byte)0, tag, isRequire);
        }
        if (o instanceof Boolean) {
            return this.read(false, tag, isRequire);
        }
        if (o instanceof Short) {
            return this.read((short)0, tag, isRequire);
        }
        if (o instanceof Integer) {
            int i = this.read(0, tag, isRequire);
            return i;
        }
        if (o instanceof Long) {
            return this.read(0L, tag, isRequire);
        }
        if (o instanceof Float) {
            return Float.valueOf(this.read(0.0f, tag, isRequire));
        }
        if (o instanceof Double) {
            return this.read(0.0, tag, isRequire);
        }
        if (o instanceof String) {
            return this.readString(tag, isRequire);
        }
        if (o instanceof Map) {
            return this.readMap((Map)o, tag, isRequire);
        }
        if (o instanceof List) {
            return this.readArray((List)o, tag, isRequire);
        }
        if (o instanceof JceStruct) {
            return this.read((JceStruct)o, tag, isRequire);
        }
        if (o.getClass().isArray()) {
            if (o instanceof byte[] || o instanceof Byte[]) {
                return this.read((byte[])null, tag, isRequire);
            }
            if (o instanceof boolean[]) {
                return this.read((boolean[])null, tag, isRequire);
            }
            if (o instanceof short[]) {
                return this.read((short[])null, tag, isRequire);
            }
            if (o instanceof int[]) {
                return this.read((int[])null, tag, isRequire);
            }
            if (o instanceof long[]) {
                return this.read((long[])null, tag, isRequire);
            }
            if (o instanceof float[]) {
                return this.read((float[])null, tag, isRequire);
            }
            if (o instanceof double[]) {
                return this.read((double[])null, tag, isRequire);
            }
            return this.readArray((Object[])o, tag, isRequire);
        }
        throw new JceDecodeException("read object error: unsupport type.");
    }

    public int setServerEncoding(String se) {
        this.sServerEncoding = se;
        return 0;
    }

    public static void main(String[] args) {
    }

    public ByteBuffer getBs() {
        return this.bs;
    }

    public static class HeadData {
        public byte type;
        public int tag;

        public void clear() {
            this.type = 0;
            this.tag = 0;
        }
    }
}

